/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.BiomeCacheBlock;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.LongHashMap;
import net.minecraft.src.WorldChunkManager;

public class BiomeCache {
    private final WorldChunkManager chunkManager;
    private long lastCleanupTime = 0L;
    private LongHashMap cacheMap = new LongHashMap();
    private List cache = new ArrayList();

    public BiomeCache(WorldChunkManager par1WorldChunkManager) {
        this.chunkManager = par1WorldChunkManager;
    }

    public BiomeCacheBlock getBiomeCacheBlock(int par1, int par2) {
        long l = (long)(par1 >>= 4) & 0xFFFFFFFFL | ((long)(par2 >>= 4) & 0xFFFFFFFFL) << 32;
        BiomeCacheBlock biomecacheblock = (BiomeCacheBlock)this.cacheMap.getValueByKey(l);
        if (biomecacheblock == null) {
            biomecacheblock = new BiomeCacheBlock(this, par1, par2);
            this.cacheMap.add(l, biomecacheblock);
            this.cache.add(biomecacheblock);
        }
        biomecacheblock.lastAccessTime = System.currentTimeMillis();
        return biomecacheblock;
    }

    public BiomeGenBase getBiomeGenAt(int par1, int par2) {
        return this.getBiomeCacheBlock(par1, par2).getBiomeGenAt(par1, par2);
    }

    public void cleanupCache() {
        long l = System.currentTimeMillis();
        long l1 = l - this.lastCleanupTime;
        if (l1 > 7500L || l1 < 0L) {
            this.lastCleanupTime = l;
            for (int i = 0; i < this.cache.size(); ++i) {
                BiomeCacheBlock biomecacheblock = (BiomeCacheBlock)this.cache.get(i);
                long l2 = l - biomecacheblock.lastAccessTime;
                if (l2 <= 30000L && l2 >= 0L) continue;
                this.cache.remove(i--);
                long l3 = (long)biomecacheblock.xPosition & 0xFFFFFFFFL | ((long)biomecacheblock.zPosition & 0xFFFFFFFFL) << 32;
                this.cacheMap.remove(l3);
            }
        }
    }

    public BiomeGenBase[] getCachedBiomes(int par1, int par2) {
        return this.getBiomeCacheBlock((int)par1, (int)par2).biomes;
    }

    static WorldChunkManager getChunkManager(BiomeCache par0BiomeCache) {
        return par0BiomeCache.chunkManager;
    }
}

