/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;

public class AxisAlignedBB {
    private static List boundingBoxes = new ArrayList();
    private static int numBoundingBoxesInUse = 0;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;

    public static AxisAlignedBB getBoundingBox(double par0, double par2, double par4, double par6, double par8, double par10) {
        return new AxisAlignedBB(par0, par2, par4, par6, par8, par10);
    }

    public static void clearBoundingBoxes() {
        boundingBoxes.clear();
        numBoundingBoxesInUse = 0;
    }

    public static void clearBoundingBoxPool() {
        numBoundingBoxesInUse = 0;
    }

    public static AxisAlignedBB getBoundingBoxFromPool(double par0, double par2, double par4, double par6, double par8, double par10) {
        if (numBoundingBoxesInUse >= boundingBoxes.size()) {
            boundingBoxes.add(AxisAlignedBB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }
        return ((AxisAlignedBB)boundingBoxes.get(numBoundingBoxesInUse++)).setBounds(par0, par2, par4, par6, par8, par10);
    }

    private AxisAlignedBB(double par1, double par3, double par5, double par7, double par9, double par11) {
        this.minX = par1;
        this.minY = par3;
        this.minZ = par5;
        this.maxX = par7;
        this.maxY = par9;
        this.maxZ = par11;
    }

    public AxisAlignedBB setBounds(double par1, double par3, double par5, double par7, double par9, double par11) {
        this.minX = par1;
        this.minY = par3;
        this.minZ = par5;
        this.maxX = par7;
        this.maxY = par9;
        this.maxZ = par11;
        return this;
    }

    public AxisAlignedBB addCoord(double par1, double par3, double par5) {
        double d = this.minX;
        double d1 = this.minY;
        double d2 = this.minZ;
        double d3 = this.maxX;
        double d4 = this.maxY;
        double d5 = this.maxZ;
        if (par1 < 0.0) {
            d += par1;
        }
        if (par1 > 0.0) {
            d3 += par1;
        }
        if (par3 < 0.0) {
            d1 += par3;
        }
        if (par3 > 0.0) {
            d4 += par3;
        }
        if (par5 < 0.0) {
            d2 += par5;
        }
        if (par5 > 0.0) {
            d5 += par5;
        }
        return AxisAlignedBB.getBoundingBoxFromPool(d, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB expand(double par1, double par3, double par5) {
        double d = this.minX - par1;
        double d1 = this.minY - par3;
        double d2 = this.minZ - par5;
        double d3 = this.maxX + par1;
        double d4 = this.maxY + par3;
        double d5 = this.maxZ + par5;
        return AxisAlignedBB.getBoundingBoxFromPool(d, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB getOffsetBoundingBox(double par1, double par3, double par5) {
        return AxisAlignedBB.getBoundingBoxFromPool(this.minX + par1, this.minY + par3, this.minZ + par5, this.maxX + par1, this.maxY + par3, this.maxZ + par5);
    }

    public double calculateXOffset(AxisAlignedBB par1AxisAlignedBB, double par2) {
        double d1;
        double d;
        if (par1AxisAlignedBB.maxY <= this.minY || par1AxisAlignedBB.minY >= this.maxY) {
            return par2;
        }
        if (par1AxisAlignedBB.maxZ <= this.minZ || par1AxisAlignedBB.minZ >= this.maxZ) {
            return par2;
        }
        if (par2 > 0.0 && par1AxisAlignedBB.maxX <= this.minX && (d = this.minX - par1AxisAlignedBB.maxX) < par2) {
            par2 = d;
        }
        if (par2 < 0.0 && par1AxisAlignedBB.minX >= this.maxX && (d1 = this.maxX - par1AxisAlignedBB.minX) > par2) {
            par2 = d1;
        }
        return par2;
    }

    public double calculateYOffset(AxisAlignedBB par1AxisAlignedBB, double par2) {
        double d1;
        double d;
        if (par1AxisAlignedBB.maxX <= this.minX || par1AxisAlignedBB.minX >= this.maxX) {
            return par2;
        }
        if (par1AxisAlignedBB.maxZ <= this.minZ || par1AxisAlignedBB.minZ >= this.maxZ) {
            return par2;
        }
        if (par2 > 0.0 && par1AxisAlignedBB.maxY <= this.minY && (d = this.minY - par1AxisAlignedBB.maxY) < par2) {
            par2 = d;
        }
        if (par2 < 0.0 && par1AxisAlignedBB.minY >= this.maxY && (d1 = this.maxY - par1AxisAlignedBB.minY) > par2) {
            par2 = d1;
        }
        return par2;
    }

    public double calculateZOffset(AxisAlignedBB par1AxisAlignedBB, double par2) {
        double d1;
        double d;
        if (par1AxisAlignedBB.maxX <= this.minX || par1AxisAlignedBB.minX >= this.maxX) {
            return par2;
        }
        if (par1AxisAlignedBB.maxY <= this.minY || par1AxisAlignedBB.minY >= this.maxY) {
            return par2;
        }
        if (par2 > 0.0 && par1AxisAlignedBB.maxZ <= this.minZ && (d = this.minZ - par1AxisAlignedBB.maxZ) < par2) {
            par2 = d;
        }
        if (par2 < 0.0 && par1AxisAlignedBB.minZ >= this.maxZ && (d1 = this.maxZ - par1AxisAlignedBB.minZ) > par2) {
            par2 = d1;
        }
        return par2;
    }

    public boolean intersectsWith(AxisAlignedBB par1AxisAlignedBB) {
        if (par1AxisAlignedBB.maxX <= this.minX || par1AxisAlignedBB.minX >= this.maxX) {
            return false;
        }
        if (par1AxisAlignedBB.maxY <= this.minY || par1AxisAlignedBB.minY >= this.maxY) {
            return false;
        }
        return par1AxisAlignedBB.maxZ > this.minZ && par1AxisAlignedBB.minZ < this.maxZ;
    }

    public AxisAlignedBB offset(double par1, double par3, double par5) {
        this.minX += par1;
        this.minY += par3;
        this.minZ += par5;
        this.maxX += par1;
        this.maxY += par3;
        this.maxZ += par5;
        return this;
    }

    public boolean isVecInside(Vec3D par1Vec3D) {
        if (par1Vec3D.xCoord <= this.minX || par1Vec3D.xCoord >= this.maxX) {
            return false;
        }
        if (par1Vec3D.yCoord <= this.minY || par1Vec3D.yCoord >= this.maxY) {
            return false;
        }
        return par1Vec3D.zCoord > this.minZ && par1Vec3D.zCoord < this.maxZ;
    }

    public double getAverageEdgeLength() {
        double d = this.maxX - this.minX;
        double d1 = this.maxY - this.minY;
        double d2 = this.maxZ - this.minZ;
        return (d + d1 + d2) / 3.0;
    }

    public AxisAlignedBB contract(double par1, double par3, double par5) {
        double d = this.minX + par1;
        double d1 = this.minY + par3;
        double d2 = this.minZ + par5;
        double d3 = this.maxX - par1;
        double d4 = this.maxY - par3;
        double d5 = this.maxZ - par5;
        return AxisAlignedBB.getBoundingBoxFromPool(d, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB copy() {
        return AxisAlignedBB.getBoundingBoxFromPool(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public MovingObjectPosition calculateIntercept(Vec3D par1Vec3D, Vec3D par2Vec3D) {
        Vec3D vec3d = par1Vec3D.getIntermediateWithXValue(par2Vec3D, this.minX);
        Vec3D vec3d1 = par1Vec3D.getIntermediateWithXValue(par2Vec3D, this.maxX);
        Vec3D vec3d2 = par1Vec3D.getIntermediateWithYValue(par2Vec3D, this.minY);
        Vec3D vec3d3 = par1Vec3D.getIntermediateWithYValue(par2Vec3D, this.maxY);
        Vec3D vec3d4 = par1Vec3D.getIntermediateWithZValue(par2Vec3D, this.minZ);
        Vec3D vec3d5 = par1Vec3D.getIntermediateWithZValue(par2Vec3D, this.maxZ);
        if (!this.isVecInYZ(vec3d)) {
            vec3d = null;
        }
        if (!this.isVecInYZ(vec3d1)) {
            vec3d1 = null;
        }
        if (!this.isVecInXZ(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInXZ(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInXY(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInXY(vec3d5)) {
            vec3d5 = null;
        }
        Vec3D vec3d6 = null;
        if (vec3d != null && (vec3d6 == null || par1Vec3D.squareDistanceTo(vec3d) < par1Vec3D.squareDistanceTo(vec3d6))) {
            vec3d6 = vec3d;
        }
        if (vec3d1 != null && (vec3d6 == null || par1Vec3D.squareDistanceTo(vec3d1) < par1Vec3D.squareDistanceTo(vec3d6))) {
            vec3d6 = vec3d1;
        }
        if (vec3d2 != null && (vec3d6 == null || par1Vec3D.squareDistanceTo(vec3d2) < par1Vec3D.squareDistanceTo(vec3d6))) {
            vec3d6 = vec3d2;
        }
        if (vec3d3 != null && (vec3d6 == null || par1Vec3D.squareDistanceTo(vec3d3) < par1Vec3D.squareDistanceTo(vec3d6))) {
            vec3d6 = vec3d3;
        }
        if (vec3d4 != null && (vec3d6 == null || par1Vec3D.squareDistanceTo(vec3d4) < par1Vec3D.squareDistanceTo(vec3d6))) {
            vec3d6 = vec3d4;
        }
        if (vec3d5 != null && (vec3d6 == null || par1Vec3D.squareDistanceTo(vec3d5) < par1Vec3D.squareDistanceTo(vec3d6))) {
            vec3d6 = vec3d5;
        }
        if (vec3d6 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d6 == vec3d) {
            byte0 = 4;
        }
        if (vec3d6 == vec3d1) {
            byte0 = 5;
        }
        if (vec3d6 == vec3d2) {
            byte0 = 0;
        }
        if (vec3d6 == vec3d3) {
            byte0 = 1;
        }
        if (vec3d6 == vec3d4) {
            byte0 = 2;
        }
        if (vec3d6 == vec3d5) {
            byte0 = 3;
        }
        return new MovingObjectPosition(0, 0, 0, byte0, vec3d6);
    }

    private boolean isVecInYZ(Vec3D par1Vec3D) {
        if (par1Vec3D == null) {
            return false;
        }
        return par1Vec3D.yCoord >= this.minY && par1Vec3D.yCoord <= this.maxY && par1Vec3D.zCoord >= this.minZ && par1Vec3D.zCoord <= this.maxZ;
    }

    private boolean isVecInXZ(Vec3D par1Vec3D) {
        if (par1Vec3D == null) {
            return false;
        }
        return par1Vec3D.xCoord >= this.minX && par1Vec3D.xCoord <= this.maxX && par1Vec3D.zCoord >= this.minZ && par1Vec3D.zCoord <= this.maxZ;
    }

    private boolean isVecInXY(Vec3D par1Vec3D) {
        if (par1Vec3D == null) {
            return false;
        }
        return par1Vec3D.xCoord >= this.minX && par1Vec3D.xCoord <= this.maxX && par1Vec3D.yCoord >= this.minY && par1Vec3D.yCoord <= this.maxY;
    }

    public void setBB(AxisAlignedBB par1AxisAlignedBB) {
        this.minX = par1AxisAlignedBB.minX;
        this.minY = par1AxisAlignedBB.minY;
        this.minZ = par1AxisAlignedBB.minZ;
        this.maxX = par1AxisAlignedBB.maxX;
        this.maxY = par1AxisAlignedBB.maxY;
        this.maxZ = par1AxisAlignedBB.maxZ;
    }

    public String toString() {
        return "box[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }
}

