/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.MinecraftApplet;
import net.minecraft.src.AchievementList;
import net.minecraft.src.AnvilSaveConverter;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkProviderLoadOrGenerate;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.ColorizerWater;
import net.minecraft.src.EffectRenderer;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.EnumOS2;
import net.minecraft.src.EnumOptions;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameSettings;
import net.minecraft.src.GameWindowListener;
import net.minecraft.src.GuiAchievement;
import net.minecraft.src.GuiChat;
import net.minecraft.src.GuiConflictWarning;
import net.minecraft.src.GuiConnecting;
import net.minecraft.src.GuiErrorScreen;
import net.minecraft.src.GuiGameOver;
import net.minecraft.src.GuiIngame;
import net.minecraft.src.GuiIngameMenu;
import net.minecraft.src.GuiInventory;
import net.minecraft.src.GuiMainMenu;
import net.minecraft.src.GuiMemoryErrorScreen;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSleepMP;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemRenderer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.KeyBinding;
import net.minecraft.src.LoadingScreenRenderer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MinecraftError;
import net.minecraft.src.MinecraftException;
import net.minecraft.src.MinecraftImpl;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.MouseHelper;
import net.minecraft.src.MovementInputFromOptions;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.OpenGlCapsChecker;
import net.minecraft.src.OpenGlHelper;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.PlayerController;
import net.minecraft.src.PlayerUsageSnooper;
import net.minecraft.src.Profiler;
import net.minecraft.src.ProfilerResult;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.RenderManager;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.ScreenShotHelper;
import net.minecraft.src.Session;
import net.minecraft.src.SoundManager;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StatFileWriter;
import net.minecraft.src.StatList;
import net.minecraft.src.StatStringFormatKeyInv;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.Teleporter;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TextureCompassFX;
import net.minecraft.src.TextureFlamesFX;
import net.minecraft.src.TextureLavaFX;
import net.minecraft.src.TextureLavaFlowFX;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.TexturePortalFX;
import net.minecraft.src.TextureWatchFX;
import net.minecraft.src.TextureWaterFX;
import net.minecraft.src.TextureWaterFlowFX;
import net.minecraft.src.ThreadCheckHasPaid;
import net.minecraft.src.ThreadClientSleep;
import net.minecraft.src.ThreadDownloadResources;
import net.minecraft.src.Timer;
import net.minecraft.src.UnexpectedThrowable;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.WorldProvider;
import net.minecraft.src.WorldRenderer;
import net.minecraft.src.WorldSettings;
import net.minecraft.src.WorldType;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

public abstract class Minecraft
implements Runnable {
    public static byte[] field_28006_b = new byte[0xA00000];
    private static Minecraft theMinecraft;
    public PlayerController playerController;
    private boolean fullscreen = false;
    private boolean hasCrashed = false;
    public int displayWidth;
    public int displayHeight;
    private OpenGlCapsChecker glCapabilities;
    private Timer timer = new Timer(20.0f);
    public World theWorld;
    public RenderGlobal renderGlobal;
    public EntityPlayerSP thePlayer;
    public EntityLiving renderViewEntity;
    public EffectRenderer effectRenderer;
    public Session session = null;
    public String minecraftUri;
    public Canvas mcCanvas;
    public boolean hideQuitButton = false;
    public volatile boolean isGamePaused = false;
    public RenderEngine renderEngine;
    public FontRenderer fontRenderer;
    public FontRenderer standardGalacticFontRenderer;
    public GuiScreen currentScreen = null;
    public LoadingScreenRenderer loadingScreen;
    public EntityRenderer entityRenderer;
    private ThreadDownloadResources downloadResourcesThread;
    private int ticksRan = 0;
    private int leftClickCounter = 0;
    private int tempDisplayWidth;
    private int tempDisplayHeight;
    public GuiAchievement guiAchievement = new GuiAchievement(this);
    public GuiIngame ingameGUI;
    public boolean skipRenderWorld = false;
    public ModelBiped playerModelBiped = new ModelBiped(0.0f);
    public MovingObjectPosition objectMouseOver = null;
    public GameSettings gameSettings;
    protected MinecraftApplet mcApplet;
    public SoundManager sndManager = new SoundManager();
    public MouseHelper mouseHelper;
    public TexturePackList texturePackList;
    public File mcDataDir;
    private ISaveFormat saveLoader;
    public static long[] frameTimes;
    public static long[] tickTimes;
    public static int numRecordedFrameTimes;
    public static long hasPaidCheckTime;
    private int rightClickDelayTimer = 0;
    public StatFileWriter statFileWriter;
    private String serverName;
    private int serverPort;
    private TextureWaterFX textureWaterFX = new TextureWaterFX();
    private TextureLavaFX textureLavaFX = new TextureLavaFX();
    private static File minecraftDir;
    public volatile boolean running = true;
    public String debug = "";
    long debugUpdateTime = System.currentTimeMillis();
    int fpsCounter = 0;
    boolean isTakingScreenshot = false;
    long prevFrameTime = -1L;
    private String debugProfilerName = "root";
    public boolean inGameHasFocus = false;
    public boolean isRaining = false;
    long systemTime = System.currentTimeMillis();
    private int joinPlayerCounter = 0;

    public Minecraft(Component par1Component, Canvas par2Canvas, MinecraftApplet par3MinecraftApplet, int par4, int par5, boolean par6) {
        StatList.func_27360_a();
        this.tempDisplayHeight = par5;
        this.fullscreen = par6;
        this.mcApplet = par3MinecraftApplet;
        Packet3Chat.field_52010_b = Short.MAX_VALUE;
        new ThreadClientSleep(this, "Timer hack thread");
        this.mcCanvas = par2Canvas;
        this.displayWidth = par4;
        this.displayHeight = par5;
        this.fullscreen = par6;
        if (par3MinecraftApplet == null || "true".equals(par3MinecraftApplet.getParameter("stand-alone"))) {
            this.hideQuitButton = false;
        }
        theMinecraft = this;
    }

    public void onMinecraftCrash(UnexpectedThrowable par1UnexpectedThrowable) {
        this.hasCrashed = true;
        this.displayUnexpectedThrowable(par1UnexpectedThrowable);
    }

    public abstract void displayUnexpectedThrowable(UnexpectedThrowable var1);

    public void setServer(String par1Str, int par2) {
        this.serverName = par1Str;
        this.serverPort = par2;
    }

    public void startGame() throws LWJGLException {
        if (this.mcCanvas != null) {
            Graphics g = this.mcCanvas.getGraphics();
            if (g != null) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, this.displayWidth, this.displayHeight);
                g.dispose();
            }
            Display.setParent((Canvas)this.mcCanvas);
        } else if (this.fullscreen) {
            Display.setFullscreen((boolean)true);
            this.displayWidth = Display.getDisplayMode().getWidth();
            this.displayHeight = Display.getDisplayMode().getHeight();
            if (this.displayWidth <= 0) {
                this.displayWidth = 1;
            }
            if (this.displayHeight <= 0) {
                this.displayHeight = 1;
            }
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.displayWidth, this.displayHeight));
        }
        Display.setTitle((String)"Minecraft Minecraft 1.2.5");
        System.out.println("LWJGL Version: " + Sys.getVersion());
        try {
            PixelFormat pixelformat = new PixelFormat();
            pixelformat = pixelformat.withDepthBits(24);
            Display.create((PixelFormat)pixelformat);
        }
        catch (LWJGLException lwjglexception) {
            lwjglexception.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        OpenGlHelper.initializeTextures();
        this.mcDataDir = Minecraft.getMinecraftDir();
        this.saveLoader = new AnvilSaveConverter(new File(this.mcDataDir, "saves"));
        this.gameSettings = new GameSettings(this, this.mcDataDir);
        this.texturePackList = new TexturePackList(this, this.mcDataDir);
        this.renderEngine = new RenderEngine(this.texturePackList, this.gameSettings);
        this.loadScreen();
        this.fontRenderer = new FontRenderer(this.gameSettings, "/font/default.png", this.renderEngine, false);
        this.standardGalacticFontRenderer = new FontRenderer(this.gameSettings, "/font/alternate.png", this.renderEngine, false);
        if (this.gameSettings.language != null) {
            StringTranslate.getInstance().setLanguage(this.gameSettings.language);
            this.fontRenderer.setUnicodeFlag(StringTranslate.getInstance().isUnicode());
            this.fontRenderer.setBidiFlag(StringTranslate.isBidrectional(this.gameSettings.language));
        }
        ColorizerWater.setWaterBiomeColorizer(this.renderEngine.getTextureContents("/misc/watercolor.png"));
        ColorizerGrass.setGrassBiomeColorizer(this.renderEngine.getTextureContents("/misc/grasscolor.png"));
        ColorizerFoliage.getFoilageBiomeColorizer(this.renderEngine.getTextureContents("/misc/foliagecolor.png"));
        this.entityRenderer = new EntityRenderer(this);
        RenderManager.instance.itemRenderer = new ItemRenderer(this);
        this.statFileWriter = new StatFileWriter(this.session, this.mcDataDir);
        AchievementList.openInventory.setStatStringFormatter(new StatStringFormatKeyInv(this));
        this.loadScreen();
        Mouse.create();
        this.mouseHelper = new MouseHelper(this.mcCanvas);
        try {
            Controllers.create();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Minecraft.createAndSendReport();
        this.checkGLError("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.checkGLError("Startup");
        this.glCapabilities = new OpenGlCapsChecker();
        this.sndManager.loadSoundSettings(this.gameSettings);
        this.renderEngine.registerTextureFX(this.textureLavaFX);
        this.renderEngine.registerTextureFX(this.textureWaterFX);
        this.renderEngine.registerTextureFX(new TexturePortalFX());
        this.renderEngine.registerTextureFX(new TextureCompassFX(this));
        this.renderEngine.registerTextureFX(new TextureWatchFX(this));
        this.renderEngine.registerTextureFX(new TextureWaterFlowFX());
        this.renderEngine.registerTextureFX(new TextureLavaFlowFX());
        this.renderEngine.registerTextureFX(new TextureFlamesFX(0));
        this.renderEngine.registerTextureFX(new TextureFlamesFX(1));
        this.renderGlobal = new RenderGlobal(this, this.renderEngine);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        this.effectRenderer = new EffectRenderer(this.theWorld, this.renderEngine);
        try {
            this.downloadResourcesThread = new ThreadDownloadResources(this.mcDataDir, this);
            this.downloadResourcesThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkGLError("Post startup");
        this.ingameGUI = new GuiIngame(this);
        if (this.serverName != null) {
            this.displayGuiScreen(new GuiConnecting(this, this.serverName, this.serverPort));
        } else {
            this.displayGuiScreen(new GuiMainMenu());
        }
        this.loadingScreen = new LoadingScreenRenderer(this);
    }

    private void loadScreen() throws LWJGLException {
        ScaledResolution scaledresolution = new ScaledResolution(this.gameSettings, this.displayWidth, this.displayHeight);
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.scaledWidthD, (double)scaledresolution.scaledHeightD, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/title/mojang.png"));
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int c = 256;
        int c1 = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.setColorOpaque_I(0xFFFFFF);
        this.scaledTessellator((scaledresolution.getScaledWidth() - c) / 2, (scaledresolution.getScaledHeight() - c1) / 2, 0, 0, c, c1);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
    }

    public void scaledTessellator(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(par1 + 0, par2 + par6, 0.0, (float)(par3 + 0) * f, (float)(par4 + par6) * f1);
        tessellator.addVertexWithUV(par1 + par5, par2 + par6, 0.0, (float)(par3 + par5) * f, (float)(par4 + par6) * f1);
        tessellator.addVertexWithUV(par1 + par5, par2 + 0, 0.0, (float)(par3 + par5) * f, (float)(par4 + 0) * f1);
        tessellator.addVertexWithUV(par1 + 0, par2 + 0, 0.0, (float)(par3 + 0) * f, (float)(par4 + 0) * f1);
        tessellator.draw();
    }

    public static File getMinecraftDir() {
        if (minecraftDir == null) {
            minecraftDir = Minecraft.getAppDir("minecraft");
        }
        return minecraftDir;
    }

    public static File getAppDir(String par0Str) {
        File file;
        String s = System.getProperty("user.home", ".");
        switch (Minecraft.getOs()) {
            case linux: 
            case solaris: {
                file = new File(s, '.' + par0Str + '/');
                break;
            }
            case windows: {
                String s1 = System.getenv("APPDATA");
                if (s1 != null) {
                    file = new File(s1, "." + par0Str + '/');
                    break;
                }
                file = new File(s, '.' + par0Str + '/');
                break;
            }
            case macos: {
                file = new File(s, "Library/Application Support/" + par0Str);
                break;
            }
            default: {
                file = new File(s, par0Str + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static EnumOS2 getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS2.windows;
        }
        if (s.contains("mac")) {
            return EnumOS2.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS2.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS2.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS2.linux;
        }
        if (s.contains("unix")) {
            return EnumOS2.linux;
        }
        return EnumOS2.unknown;
    }

    public ISaveFormat getSaveLoader() {
        return this.saveLoader;
    }

    public void displayGuiScreen(GuiScreen par1GuiScreen) {
        if (this.currentScreen instanceof GuiErrorScreen) {
            return;
        }
        if (this.currentScreen != null) {
            this.currentScreen.onGuiClosed();
        }
        if (par1GuiScreen instanceof GuiMainMenu) {
            this.statFileWriter.func_27175_b();
        }
        this.statFileWriter.syncStats();
        if (par1GuiScreen == null && this.theWorld == null) {
            par1GuiScreen = new GuiMainMenu();
        } else if (par1GuiScreen == null && this.thePlayer.getHealth() <= 0) {
            par1GuiScreen = new GuiGameOver();
        }
        if (par1GuiScreen instanceof GuiMainMenu) {
            this.gameSettings.showDebugInfo = false;
            this.ingameGUI.clearChatMessages();
        }
        this.currentScreen = par1GuiScreen;
        if (par1GuiScreen != null) {
            this.setIngameNotInFocus();
            ScaledResolution scaledresolution = new ScaledResolution(this.gameSettings, this.displayWidth, this.displayHeight);
            int i = scaledresolution.getScaledWidth();
            int j = scaledresolution.getScaledHeight();
            par1GuiScreen.setWorldAndResolution(this, i, j);
            this.skipRenderWorld = false;
        } else {
            this.setIngameFocus();
        }
    }

    private void checkGLError(String par1Str) {
        int i = GL11.glGetError();
        if (i != 0) {
            String s = GLU.gluErrorString((int)i);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + par1Str);
            System.out.println(i + ": " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownMinecraftApplet() {
        try {
            this.statFileWriter.func_27175_b();
            this.statFileWriter.syncStats();
            if (this.mcApplet != null) {
                this.mcApplet.clearApplet();
            }
            try {
                if (this.downloadResourcesThread != null) {
                    this.downloadResourcesThread.closeMinecraft();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Stopping!");
            try {
                this.changeWorld1(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                GLAllocation.deleteTexturesAndDisplayLists();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sndManager.closeMinecraft();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
            if (!this.hasCrashed) {
                System.exit(0);
            }
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            this.startGame();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.onMinecraftCrash(new UnexpectedThrowable("Failed to start game", exception));
            return;
        }
        try {
            while (this.running) {
                try {
                    this.runGameLoop();
                }
                catch (MinecraftException minecraftexception) {
                    this.theWorld = null;
                    this.changeWorld1(null);
                    this.displayGuiScreen(new GuiConflictWarning());
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    this.freeMemory();
                    this.displayGuiScreen(new GuiMemoryErrorScreen());
                    System.gc();
                }
            }
        }
        catch (MinecraftError minecrafterror) {
        }
        catch (Throwable throwable) {
            this.freeMemory();
            throwable.printStackTrace();
            this.onMinecraftCrash(new UnexpectedThrowable("Unexpected error", throwable));
        }
        finally {
            this.shutdownMinecraftApplet();
        }
    }

    private void runGameLoop() {
        if (this.mcApplet != null && !this.mcApplet.isActive()) {
            this.running = false;
            return;
        }
        AxisAlignedBB.clearBoundingBoxPool();
        Vec3D.initialize();
        Profiler.startSection("root");
        if (this.mcCanvas == null && Display.isCloseRequested()) {
            this.shutdown();
        }
        if (this.isGamePaused && this.theWorld != null) {
            float f = this.timer.renderPartialTicks;
            this.timer.updateTimer();
            this.timer.renderPartialTicks = f;
        } else {
            this.timer.updateTimer();
        }
        long l = System.nanoTime();
        Profiler.startSection("tick");
        for (int i = 0; i < this.timer.elapsedTicks; ++i) {
            ++this.ticksRan;
            try {
                this.runTick();
                continue;
            }
            catch (MinecraftException minecraftexception) {
                this.theWorld = null;
                this.changeWorld1(null);
                this.displayGuiScreen(new GuiConflictWarning());
            }
        }
        Profiler.endSection();
        long l1 = System.nanoTime() - l;
        this.checkGLError("Pre render");
        RenderBlocks.fancyGrass = this.gameSettings.fancyGraphics;
        Profiler.startSection("sound");
        this.sndManager.setListener(this.thePlayer, this.timer.renderPartialTicks);
        Profiler.endStartSection("updatelights");
        if (this.theWorld != null) {
            this.theWorld.updatingLighting();
        }
        Profiler.endSection();
        Profiler.startSection("render");
        Profiler.startSection("display");
        GL11.glEnable((int)3553);
        if (!Keyboard.isKeyDown((int)65)) {
            Display.update();
        }
        if (this.thePlayer != null && this.thePlayer.isEntityInsideOpaqueBlock()) {
            this.gameSettings.thirdPersonView = 0;
        }
        Profiler.endSection();
        if (!this.skipRenderWorld) {
            Profiler.startSection("gameMode");
            if (this.playerController != null) {
                this.playerController.setPartialTime(this.timer.renderPartialTicks);
            }
            Profiler.endStartSection("gameRenderer");
            this.entityRenderer.updateCameraAndRender(this.timer.renderPartialTicks);
            Profiler.endSection();
        }
        GL11.glFlush();
        Profiler.endSection();
        if (!Display.isActive() && this.fullscreen) {
            this.toggleFullscreen();
        }
        Profiler.endSection();
        if (this.gameSettings.showDebugInfo && this.gameSettings.field_50119_G) {
            if (!Profiler.profilingEnabled) {
                Profiler.clearProfiling();
            }
            Profiler.profilingEnabled = true;
            this.displayDebugInfo(l1);
        } else {
            Profiler.profilingEnabled = false;
            this.prevFrameTime = System.nanoTime();
        }
        this.guiAchievement.updateAchievementWindow();
        Profiler.startSection("root");
        Thread.yield();
        if (Keyboard.isKeyDown((int)65)) {
            Display.update();
        }
        this.screenshotListener();
        if (!(this.mcCanvas == null || this.fullscreen || this.mcCanvas.getWidth() == this.displayWidth && this.mcCanvas.getHeight() == this.displayHeight)) {
            this.displayWidth = this.mcCanvas.getWidth();
            this.displayHeight = this.mcCanvas.getHeight();
            if (this.displayWidth <= 0) {
                this.displayWidth = 1;
            }
            if (this.displayHeight <= 0) {
                this.displayHeight = 1;
            }
            this.resize(this.displayWidth, this.displayHeight);
        }
        this.checkGLError("Post render");
        ++this.fpsCounter;
        boolean bl = this.isGamePaused = !this.isMultiplayerWorld() && this.currentScreen != null && this.currentScreen.doesGuiPauseGame();
        while (System.currentTimeMillis() >= this.debugUpdateTime + 1000L) {
            this.debug = this.fpsCounter + " fps, " + WorldRenderer.chunksUpdated + " chunk updates";
            WorldRenderer.chunksUpdated = 0;
            this.debugUpdateTime += 1000L;
            this.fpsCounter = 0;
        }
        Profiler.endSection();
    }

    public void freeMemory() {
        try {
            field_28006_b = new byte[0];
            this.renderGlobal.func_28137_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            AxisAlignedBB.clearBoundingBoxes();
            Vec3D.clearVectorList();
        }
        catch (Throwable throwable1) {
            // empty catch block
        }
        try {
            System.gc();
            this.changeWorld1(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void screenshotListener() {
        if (Keyboard.isKeyDown((int)60)) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                this.ingameGUI.addChatMessage(ScreenShotHelper.saveScreenshot(minecraftDir, this.displayWidth, this.displayHeight));
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    private void updateDebugProfilerName(int par1) {
        List list = Profiler.getProfilingData(this.debugProfilerName);
        if (list == null || list.size() == 0) {
            return;
        }
        ProfilerResult profilerresult = (ProfilerResult)list.remove(0);
        if (par1 == 0) {
            int i;
            if (profilerresult.name.length() > 0 && (i = this.debugProfilerName.lastIndexOf(".")) >= 0) {
                this.debugProfilerName = this.debugProfilerName.substring(0, i);
            }
        } else if (--par1 < list.size() && !((ProfilerResult)list.get((int)par1)).name.equals("unspecified")) {
            if (this.debugProfilerName.length() > 0) {
                this.debugProfilerName = this.debugProfilerName + ".";
            }
            this.debugProfilerName = this.debugProfilerName + ((ProfilerResult)list.get((int)par1)).name;
        }
    }

    private void displayDebugInfo(long par1) {
        List list = Profiler.getProfilingData(this.debugProfilerName);
        ProfilerResult profilerresult = (ProfilerResult)list.remove(0);
        long l = 16666666L;
        if (this.prevFrameTime == -1L) {
            this.prevFrameTime = System.nanoTime();
        }
        long l1 = System.nanoTime();
        Minecraft.tickTimes[Minecraft.numRecordedFrameTimes & Minecraft.frameTimes.length - 1] = par1;
        Minecraft.frameTimes[Minecraft.numRecordedFrameTimes++ & Minecraft.frameTimes.length - 1] = l1 - this.prevFrameTime;
        this.prevFrameTime = l1;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glEnable((int)2903);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.displayWidth, (double)this.displayHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(7);
        int i = (int)(l / 200000L);
        tessellator.setColorOpaque_I(0x20000000);
        tessellator.addVertex(0.0, this.displayHeight - i, 0.0);
        tessellator.addVertex(0.0, this.displayHeight, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight - i, 0.0);
        tessellator.setColorOpaque_I(0x20200000);
        tessellator.addVertex(0.0, this.displayHeight - i * 2, 0.0);
        tessellator.addVertex(0.0, this.displayHeight - i, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight - i, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight - i * 2, 0.0);
        tessellator.draw();
        long l2 = 0L;
        for (int j = 0; j < frameTimes.length; ++j) {
            l2 += frameTimes[j];
        }
        int k = (int)(l2 / 200000L / (long)frameTimes.length);
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_I(0x20400000);
        tessellator.addVertex(0.0, this.displayHeight - k, 0.0);
        tessellator.addVertex(0.0, this.displayHeight, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight - k, 0.0);
        tessellator.draw();
        tessellator.startDrawing(1);
        for (int i1 = 0; i1 < frameTimes.length; ++i1) {
            int k1 = (i1 - numRecordedFrameTimes & frameTimes.length - 1) * 255 / frameTimes.length;
            int j2 = k1 * k1 / 255;
            j2 = j2 * j2 / 255;
            int i3 = j2 * j2 / 255;
            i3 = i3 * i3 / 255;
            if (frameTimes[i1] > l) {
                tessellator.setColorOpaque_I(-16777216 + j2 * 65536);
            } else {
                tessellator.setColorOpaque_I(-16777216 + j2 * 256);
            }
            long l3 = frameTimes[i1] / 200000L;
            long l4 = tickTimes[i1] / 200000L;
            tessellator.addVertex((float)i1 + 0.5f, (float)((long)this.displayHeight - l3) + 0.5f, 0.0);
            tessellator.addVertex((float)i1 + 0.5f, (float)this.displayHeight + 0.5f, 0.0);
            tessellator.setColorOpaque_I(-16777216 + j2 * 65536 + j2 * 256 + j2 * 1);
            tessellator.addVertex((float)i1 + 0.5f, (float)((long)this.displayHeight - l3) + 0.5f, 0.0);
            tessellator.addVertex((float)i1 + 0.5f, (float)((long)this.displayHeight - (l3 - l4)) + 0.5f, 0.0);
        }
        tessellator.draw();
        int j1 = 160;
        int i2 = this.displayWidth - j1 - 10;
        int k2 = this.displayHeight - j1 * 2;
        GL11.glEnable((int)3042);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 200);
        tessellator.addVertex((float)i2 - (float)j1 * 1.1f, (float)k2 - (float)j1 * 0.6f - 16.0f, 0.0);
        tessellator.addVertex((float)i2 - (float)j1 * 1.1f, k2 + j1 * 2, 0.0);
        tessellator.addVertex((float)i2 + (float)j1 * 1.1f, k2 + j1 * 2, 0.0);
        tessellator.addVertex((float)i2 + (float)j1 * 1.1f, (float)k2 - (float)j1 * 0.6f - 16.0f, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3042);
        double d = 0.0;
        for (int j3 = 0; j3 < list.size(); ++j3) {
            ProfilerResult profilerresult1 = (ProfilerResult)list.get(j3);
            int i4 = MathHelper.floor_double(profilerresult1.sectionPercentage / 4.0) + 1;
            tessellator.startDrawing(6);
            tessellator.setColorOpaque_I(profilerresult1.getDisplayColor());
            tessellator.addVertex(i2, k2, 0.0);
            for (int k4 = i4; k4 >= 0; --k4) {
                float f = (float)((d + profilerresult1.sectionPercentage * (double)k4 / (double)i4) * Math.PI * 2.0 / 100.0);
                float f2 = MathHelper.sin(f) * (float)j1;
                float f4 = MathHelper.cos(f) * (float)j1 * 0.5f;
                tessellator.addVertex((float)i2 + f2, (float)k2 - f4, 0.0);
            }
            tessellator.draw();
            tessellator.startDrawing(5);
            tessellator.setColorOpaque_I((profilerresult1.getDisplayColor() & 0xFEFEFE) >> 1);
            for (int i5 = i4; i5 >= 0; --i5) {
                float f1 = (float)((d + profilerresult1.sectionPercentage * (double)i5 / (double)i4) * Math.PI * 2.0 / 100.0);
                float f3 = MathHelper.sin(f1) * (float)j1;
                float f5 = MathHelper.cos(f1) * (float)j1 * 0.5f;
                tessellator.addVertex((float)i2 + f3, (float)k2 - f5, 0.0);
                tessellator.addVertex((float)i2 + f3, (float)k2 - f5 + 10.0f, 0.0);
            }
            tessellator.draw();
            d += profilerresult1.sectionPercentage;
        }
        DecimalFormat decimalformat = new DecimalFormat("##0.00");
        GL11.glEnable((int)3553);
        String s = "";
        if (!profilerresult.name.equals("unspecified")) {
            s = s + "[0] ";
        }
        s = profilerresult.name.length() == 0 ? s + "ROOT " : s + profilerresult.name + " ";
        int j4 = 0xFFFFFF;
        this.fontRenderer.drawStringWithShadow(s, i2 - j1, k2 - j1 / 2 - 16, j4);
        s = decimalformat.format(profilerresult.globalPercentage) + "%";
        this.fontRenderer.drawStringWithShadow(s, i2 + j1 - this.fontRenderer.getStringWidth(s), k2 - j1 / 2 - 16, j4);
        for (int k3 = 0; k3 < list.size(); ++k3) {
            ProfilerResult profilerresult2 = (ProfilerResult)list.get(k3);
            String s1 = "";
            s1 = !profilerresult2.name.equals("unspecified") ? s1 + "[" + (k3 + 1) + "] " : s1 + "[?] ";
            s1 = s1 + profilerresult2.name;
            this.fontRenderer.drawStringWithShadow(s1, i2 - j1, k2 + j1 / 2 + k3 * 8 + 20, profilerresult2.getDisplayColor());
            s1 = decimalformat.format(profilerresult2.sectionPercentage) + "%";
            this.fontRenderer.drawStringWithShadow(s1, i2 + j1 - 50 - this.fontRenderer.getStringWidth(s1), k2 + j1 / 2 + k3 * 8 + 20, profilerresult2.getDisplayColor());
            s1 = decimalformat.format(profilerresult2.globalPercentage) + "%";
            this.fontRenderer.drawStringWithShadow(s1, i2 + j1 - this.fontRenderer.getStringWidth(s1), k2 + j1 / 2 + k3 * 8 + 20, profilerresult2.getDisplayColor());
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public void setIngameFocus() {
        if (!Display.isActive()) {
            return;
        }
        if (this.inGameHasFocus) {
            return;
        }
        this.inGameHasFocus = true;
        this.mouseHelper.grabMouseCursor();
        this.displayGuiScreen(null);
        this.leftClickCounter = 10000;
    }

    public void setIngameNotInFocus() {
        if (!this.inGameHasFocus) {
            return;
        }
        KeyBinding.unPressAllKeys();
        this.inGameHasFocus = false;
        this.mouseHelper.ungrabMouseCursor();
    }

    public void displayInGameMenu() {
        if (this.currentScreen != null) {
            return;
        }
        this.displayGuiScreen(new GuiIngameMenu());
    }

    private void sendClickBlockToController(int par1, boolean par2) {
        if (!par2) {
            this.leftClickCounter = 0;
        }
        if (par1 == 0 && this.leftClickCounter > 0) {
            return;
        }
        if (par2 && this.objectMouseOver != null && this.objectMouseOver.typeOfHit == EnumMovingObjectType.TILE && par1 == 0) {
            int i = this.objectMouseOver.blockX;
            int j = this.objectMouseOver.blockY;
            int k = this.objectMouseOver.blockZ;
            this.playerController.onPlayerDamageBlock(i, j, k, this.objectMouseOver.sideHit);
            if (this.thePlayer.canPlayerEdit(i, j, k)) {
                this.effectRenderer.addBlockHitEffects(i, j, k, this.objectMouseOver.sideHit);
                this.thePlayer.swingItem();
            }
        } else {
            this.playerController.resetBlockRemoving();
        }
    }

    private void clickMouse(int par1) {
        ItemStack itemstack1;
        if (par1 == 0 && this.leftClickCounter > 0) {
            return;
        }
        if (par1 == 0) {
            this.thePlayer.swingItem();
        }
        if (par1 == 1) {
            this.rightClickDelayTimer = 4;
        }
        boolean flag = true;
        ItemStack itemstack = this.thePlayer.inventory.getCurrentItem();
        if (this.objectMouseOver == null) {
            if (par1 == 0 && this.playerController.isNotCreative()) {
                this.leftClickCounter = 10;
            }
        } else if (this.objectMouseOver.typeOfHit == EnumMovingObjectType.ENTITY) {
            if (par1 == 0) {
                this.playerController.attackEntity(this.thePlayer, this.objectMouseOver.entityHit);
            }
            if (par1 == 1) {
                this.playerController.interactWithEntity(this.thePlayer, this.objectMouseOver.entityHit);
            }
        } else if (this.objectMouseOver.typeOfHit == EnumMovingObjectType.TILE) {
            int i = this.objectMouseOver.blockX;
            int j = this.objectMouseOver.blockY;
            int k = this.objectMouseOver.blockZ;
            int l = this.objectMouseOver.sideHit;
            if (par1 == 0) {
                this.playerController.clickBlock(i, j, k, this.objectMouseOver.sideHit);
            } else {
                int i1;
                ItemStack itemstack2 = itemstack;
                int n = i1 = itemstack2 == null ? 0 : itemstack2.stackSize;
                if (this.playerController.onPlayerRightClick(this.thePlayer, this.theWorld, itemstack2, i, j, k, l)) {
                    flag = false;
                    this.thePlayer.swingItem();
                }
                if (itemstack2 == null) {
                    return;
                }
                if (itemstack2.stackSize == 0) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                } else if (itemstack2.stackSize != i1 || this.playerController.isInCreativeMode()) {
                    this.entityRenderer.itemRenderer.func_9449_b();
                }
            }
        }
        if (flag && par1 == 1 && (itemstack1 = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.sendUseItem(this.thePlayer, this.theWorld, itemstack1)) {
            this.entityRenderer.itemRenderer.func_9450_c();
        }
    }

    public void toggleFullscreen() {
        try {
            boolean bl = this.fullscreen = !this.fullscreen;
            if (this.fullscreen) {
                Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                this.displayWidth = Display.getDisplayMode().getWidth();
                this.displayHeight = Display.getDisplayMode().getHeight();
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
            } else {
                if (this.mcCanvas != null) {
                    this.displayWidth = this.mcCanvas.getWidth();
                    this.displayHeight = this.mcCanvas.getHeight();
                } else {
                    this.displayWidth = this.tempDisplayWidth;
                    this.displayHeight = this.tempDisplayHeight;
                }
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
            }
            if (this.currentScreen != null) {
                this.resize(this.displayWidth, this.displayHeight);
            }
            Display.setFullscreen((boolean)this.fullscreen);
            Display.update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resize(int par1, int par2) {
        if (par1 <= 0) {
            par1 = 1;
        }
        if (par2 <= 0) {
            par2 = 1;
        }
        this.displayWidth = par1;
        this.displayHeight = par2;
        if (this.currentScreen != null) {
            ScaledResolution scaledresolution = new ScaledResolution(this.gameSettings, par1, par2);
            int i = scaledresolution.getScaledWidth();
            int j = scaledresolution.getScaledHeight();
            this.currentScreen.setWorldAndResolution(this, i, j);
        }
    }

    private void startThreadCheckHasPaid() {
        new ThreadCheckHasPaid(this).start();
    }

    public void runTick() {
        IChunkProvider ichunkprovider;
        if (this.rightClickDelayTimer > 0) {
            --this.rightClickDelayTimer;
        }
        if (this.ticksRan == 6000) {
            this.startThreadCheckHasPaid();
        }
        Profiler.startSection("stats");
        this.statFileWriter.func_27178_d();
        Profiler.endStartSection("gui");
        if (!this.isGamePaused) {
            this.ingameGUI.updateTick();
        }
        Profiler.endStartSection("pick");
        this.entityRenderer.getMouseOver(1.0f);
        Profiler.endStartSection("centerChunkSource");
        if (this.thePlayer != null && (ichunkprovider = this.theWorld.getChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            int k = MathHelper.floor_float((int)this.thePlayer.posX) >> 4;
            int j1 = MathHelper.floor_float((int)this.thePlayer.posZ) >> 4;
            chunkproviderloadorgenerate.setCurrentChunkOver(k, j1);
        }
        Profiler.endStartSection("gameMode");
        if (!this.isGamePaused && this.theWorld != null) {
            this.playerController.updateController();
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain.png"));
        Profiler.endStartSection("textures");
        if (!this.isGamePaused) {
            this.renderEngine.updateDynamicTextures();
        }
        if (this.currentScreen == null && this.thePlayer != null) {
            if (this.thePlayer.getHealth() <= 0) {
                this.displayGuiScreen(null);
            } else if (this.thePlayer.isPlayerSleeping() && this.theWorld != null && this.theWorld.isRemote) {
                this.displayGuiScreen(new GuiSleepMP());
            }
        } else if (this.currentScreen != null && this.currentScreen instanceof GuiSleepMP && !this.thePlayer.isPlayerSleeping()) {
            this.displayGuiScreen(null);
        }
        if (this.currentScreen != null) {
            this.leftClickCounter = 10000;
        }
        if (this.currentScreen != null) {
            this.currentScreen.handleInput();
            if (this.currentScreen != null) {
                this.currentScreen.guiParticles.update();
                this.currentScreen.updateScreen();
            }
        }
        if (this.currentScreen == null || this.currentScreen.allowUserInput) {
            Profiler.endStartSection("mouse");
            while (Mouse.next()) {
                long l;
                KeyBinding.setKeyBindState(Mouse.getEventButton() - 100, Mouse.getEventButtonState());
                if (Mouse.getEventButtonState()) {
                    KeyBinding.onTick(Mouse.getEventButton() - 100);
                }
                if ((l = System.currentTimeMillis() - this.systemTime) > 200L) continue;
                int i1 = Mouse.getEventDWheel();
                if (i1 != 0) {
                    this.thePlayer.inventory.changeCurrentItem(i1);
                    if (this.gameSettings.noclip) {
                        if (i1 > 0) {
                            i1 = 1;
                        }
                        if (i1 < 0) {
                            i1 = -1;
                        }
                        this.gameSettings.noclipRate += (float)i1 * 0.25f;
                    }
                }
                if (this.currentScreen == null) {
                    if (this.inGameHasFocus || !Mouse.getEventButtonState()) continue;
                    this.setIngameFocus();
                    continue;
                }
                if (this.currentScreen == null) continue;
                this.currentScreen.handleMouseInput();
            }
            if (this.leftClickCounter > 0) {
                --this.leftClickCounter;
            }
            Profiler.endStartSection("keyboard");
            while (Keyboard.next()) {
                KeyBinding.setKeyBindState(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                if (Keyboard.getEventKeyState()) {
                    KeyBinding.onTick(Keyboard.getEventKey());
                }
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 87) {
                    this.toggleFullscreen();
                    continue;
                }
                if (this.currentScreen != null) {
                    this.currentScreen.handleKeyboardInput();
                } else {
                    if (Keyboard.getEventKey() == 1) {
                        this.displayInGameMenu();
                    }
                    if (Keyboard.getEventKey() == 31 && Keyboard.isKeyDown((int)61)) {
                        this.forceReload();
                    }
                    if (Keyboard.getEventKey() == 20 && Keyboard.isKeyDown((int)61)) {
                        this.renderEngine.refreshTextures();
                    }
                    if (Keyboard.getEventKey() == 33 && Keyboard.isKeyDown((int)61)) {
                        boolean flag = Keyboard.isKeyDown((int)42) | Keyboard.isKeyDown((int)54);
                        this.gameSettings.setOptionValue(EnumOptions.RENDER_DISTANCE, flag ? -1 : 1);
                    }
                    if (Keyboard.getEventKey() == 30 && Keyboard.isKeyDown((int)61)) {
                        this.renderGlobal.loadRenderers();
                    }
                    if (Keyboard.getEventKey() == 59) {
                        boolean bl = this.gameSettings.hideGUI = !this.gameSettings.hideGUI;
                    }
                    if (Keyboard.getEventKey() == 61) {
                        this.gameSettings.showDebugInfo = !this.gameSettings.showDebugInfo;
                        boolean bl = this.gameSettings.field_50119_G = !GuiScreen.func_50049_m();
                    }
                    if (Keyboard.getEventKey() == 63) {
                        ++this.gameSettings.thirdPersonView;
                        if (this.gameSettings.thirdPersonView > 2) {
                            this.gameSettings.thirdPersonView = 0;
                        }
                    }
                    if (Keyboard.getEventKey() == 66) {
                        this.gameSettings.smoothCamera = !this.gameSettings.smoothCamera;
                    }
                }
                for (int i = 0; i < 9; ++i) {
                    if (Keyboard.getEventKey() != 2 + i) continue;
                    this.thePlayer.inventory.currentItem = i;
                }
                if (!this.gameSettings.showDebugInfo || !this.gameSettings.field_50119_G) continue;
                if (Keyboard.getEventKey() == 11) {
                    this.updateDebugProfilerName(0);
                }
                for (int j = 0; j < 9; ++j) {
                    if (Keyboard.getEventKey() != 2 + j) continue;
                    this.updateDebugProfilerName(j + 1);
                }
            }
            while (this.gameSettings.keyBindInventory.isPressed()) {
                this.displayGuiScreen(new GuiInventory(this.thePlayer));
            }
            while (this.gameSettings.keyBindDrop.isPressed()) {
                this.thePlayer.dropOneItem();
            }
            while (this.isMultiplayerWorld() && this.gameSettings.keyBindChat.isPressed()) {
                this.displayGuiScreen(new GuiChat());
            }
            if (this.isMultiplayerWorld() && this.currentScreen == null && (Keyboard.isKeyDown((int)53) || Keyboard.isKeyDown((int)181))) {
                this.displayGuiScreen(new GuiChat("/"));
            }
            if (this.thePlayer.isUsingItem()) {
                if (!this.gameSettings.keyBindUseItem.pressed) {
                    this.playerController.onStoppedUsingItem(this.thePlayer);
                }
                while (this.gameSettings.keyBindAttack.isPressed()) {
                }
                while (this.gameSettings.keyBindUseItem.isPressed()) {
                }
                while (this.gameSettings.keyBindPickBlock.isPressed()) {
                }
            } else {
                while (this.gameSettings.keyBindAttack.isPressed()) {
                    this.clickMouse(0);
                }
                while (this.gameSettings.keyBindUseItem.isPressed()) {
                    this.clickMouse(1);
                }
                while (this.gameSettings.keyBindPickBlock.isPressed()) {
                    this.clickMiddleMouseButton();
                }
            }
            if (this.gameSettings.keyBindUseItem.pressed && this.rightClickDelayTimer == 0 && !this.thePlayer.isUsingItem()) {
                this.clickMouse(1);
            }
            this.sendClickBlockToController(0, this.currentScreen == null && this.gameSettings.keyBindAttack.pressed && this.inGameHasFocus);
        }
        if (this.theWorld != null) {
            if (this.thePlayer != null) {
                ++this.joinPlayerCounter;
                if (this.joinPlayerCounter == 30) {
                    this.joinPlayerCounter = 0;
                    this.theWorld.joinEntityInSurroundings(this.thePlayer);
                }
            }
            this.theWorld.difficultySetting = this.theWorld.getWorldInfo().isHardcoreModeEnabled() ? 3 : this.gameSettings.difficulty;
            if (this.theWorld.isRemote) {
                this.theWorld.difficultySetting = 1;
            }
            Profiler.endStartSection("gameRenderer");
            if (!this.isGamePaused) {
                this.entityRenderer.updateRenderer();
            }
            Profiler.endStartSection("levelRenderer");
            if (!this.isGamePaused) {
                this.renderGlobal.updateClouds();
            }
            Profiler.endStartSection("level");
            if (!this.isGamePaused) {
                if (this.theWorld.lightningFlash > 0) {
                    --this.theWorld.lightningFlash;
                }
                this.theWorld.updateEntities();
            }
            if (!this.isGamePaused || this.isMultiplayerWorld()) {
                this.theWorld.setAllowedSpawnTypes(this.theWorld.difficultySetting > 0, true);
                this.theWorld.tick();
            }
            Profiler.endStartSection("animateTick");
            if (!this.isGamePaused && this.theWorld != null) {
                this.theWorld.randomDisplayUpdates(MathHelper.floor_double(this.thePlayer.posX), MathHelper.floor_double(this.thePlayer.posY), MathHelper.floor_double(this.thePlayer.posZ));
            }
            Profiler.endStartSection("particles");
            if (!this.isGamePaused) {
                this.effectRenderer.updateEffects();
            }
        }
        Profiler.endSection();
        this.systemTime = System.currentTimeMillis();
    }

    private void forceReload() {
        System.out.println("FORCING RELOAD!");
        this.sndManager = new SoundManager();
        this.sndManager.loadSoundSettings(this.gameSettings);
        this.downloadResourcesThread.reloadResources();
    }

    public boolean isMultiplayerWorld() {
        return this.theWorld != null && this.theWorld.isRemote;
    }

    public void startWorld(String par1Str, String par2Str, WorldSettings par3WorldSettings) {
        this.changeWorld1(null);
        System.gc();
        if (this.saveLoader.isOldMapFormat(par1Str)) {
            this.convertMapFormat(par1Str, par2Str);
        } else {
            if (this.loadingScreen != null) {
                this.loadingScreen.printText(StatCollector.translateToLocal("menu.switchingLevel"));
                this.loadingScreen.displayLoadingString("");
            }
            ISaveHandler isavehandler = this.saveLoader.getSaveLoader(par1Str, false);
            World world = null;
            world = new World(isavehandler, par2Str, par3WorldSettings);
            if (world.isNewWorld) {
                this.statFileWriter.readStat(StatList.createWorldStat, 1);
                this.statFileWriter.readStat(StatList.startGameStat, 1);
                this.changeWorld2(world, StatCollector.translateToLocal("menu.generatingLevel"));
            } else {
                this.statFileWriter.readStat(StatList.loadWorldStat, 1);
                this.statFileWriter.readStat(StatList.startGameStat, 1);
                this.changeWorld2(world, StatCollector.translateToLocal("menu.loadingLevel"));
            }
        }
    }

    public void usePortal(int par1) {
        int i = this.thePlayer.dimension;
        this.thePlayer.dimension = par1;
        this.theWorld.setEntityDead(this.thePlayer);
        this.thePlayer.isDead = false;
        double d = this.thePlayer.posX;
        double d1 = this.thePlayer.posZ;
        double d2 = 1.0;
        if (i > -1 && this.thePlayer.dimension == -1) {
            d2 = 0.125;
        } else if (i == -1 && this.thePlayer.dimension > -1) {
            d2 = 8.0;
        }
        d *= d2;
        d1 *= d2;
        if (this.thePlayer.dimension == -1) {
            this.thePlayer.setLocationAndAngles(d, this.thePlayer.posY, d1, this.thePlayer.rotationYaw, this.thePlayer.rotationPitch);
            if (this.thePlayer.isEntityAlive()) {
                this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            }
            World world = null;
            world = new World(this.theWorld, WorldProvider.getProviderForDimension(this.thePlayer.dimension));
            this.changeWorld(world, "Entering the Nether", this.thePlayer);
        } else if (this.thePlayer.dimension == 0) {
            if (this.thePlayer.isEntityAlive()) {
                this.thePlayer.setLocationAndAngles(d, this.thePlayer.posY, d1, this.thePlayer.rotationYaw, this.thePlayer.rotationPitch);
                this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            }
            World world1 = null;
            world1 = new World(this.theWorld, WorldProvider.getProviderForDimension(this.thePlayer.dimension));
            if (i == -1) {
                this.changeWorld(world1, "Leaving the Nether", this.thePlayer);
            } else {
                this.changeWorld(world1, "Leaving the End", this.thePlayer);
            }
        } else {
            World world2 = null;
            world2 = new World(this.theWorld, WorldProvider.getProviderForDimension(this.thePlayer.dimension));
            ChunkCoordinates chunkcoordinates = world2.getEntrancePortalLocation();
            d = chunkcoordinates.posX;
            this.thePlayer.posY = chunkcoordinates.posY;
            d1 = chunkcoordinates.posZ;
            this.thePlayer.setLocationAndAngles(d, this.thePlayer.posY, d1, 90.0f, 0.0f);
            if (this.thePlayer.isEntityAlive()) {
                world2.updateEntityWithOptionalForce(this.thePlayer, false);
            }
            this.changeWorld(world2, "Entering the End", this.thePlayer);
        }
        this.thePlayer.worldObj = this.theWorld;
        System.out.println("Teleported to " + this.theWorld.worldProvider.worldType);
        if (this.thePlayer.isEntityAlive() && i < 1) {
            this.thePlayer.setLocationAndAngles(d, this.thePlayer.posY, d1, this.thePlayer.rotationYaw, this.thePlayer.rotationPitch);
            this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            new Teleporter().placeInPortal(this.theWorld, this.thePlayer);
        }
    }

    public void exitToMainMenu(String par1Str) {
        this.theWorld = null;
        this.changeWorld2(null, par1Str);
    }

    public void changeWorld1(World par1World) {
        this.changeWorld2(par1World, "");
    }

    public void changeWorld2(World par1World, String par2Str) {
        this.changeWorld(par1World, par2Str, null);
    }

    public void changeWorld(World par1World, String par2Str, EntityPlayer par3EntityPlayer) {
        this.statFileWriter.func_27175_b();
        this.statFileWriter.syncStats();
        this.renderViewEntity = null;
        if (this.loadingScreen != null) {
            this.loadingScreen.printText(par2Str);
            this.loadingScreen.displayLoadingString("");
        }
        this.sndManager.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.theWorld != null) {
            this.theWorld.saveWorldIndirectly(this.loadingScreen);
        }
        this.theWorld = par1World;
        if (par1World != null) {
            IChunkProvider ichunkprovider;
            if (this.playerController != null) {
                this.playerController.onWorldChange(par1World);
            }
            if (!this.isMultiplayerWorld()) {
                if (par3EntityPlayer == null) {
                    this.thePlayer = (EntityPlayerSP)par1World.func_4085_a(EntityPlayerSP.class);
                }
            } else if (this.thePlayer != null) {
                this.thePlayer.preparePlayerToSpawn();
                if (par1World != null) {
                    par1World.spawnEntityInWorld(this.thePlayer);
                }
            }
            if (!par1World.isRemote) {
                this.preloadWorld(par2Str);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(par1World);
                this.thePlayer.preparePlayerToSpawn();
                this.playerController.flipPlayer(this.thePlayer);
            }
            this.thePlayer.movementInput = new MovementInputFromOptions(this.gameSettings);
            if (this.renderGlobal != null) {
                this.renderGlobal.changeWorld(par1World);
            }
            if (this.effectRenderer != null) {
                this.effectRenderer.clearEffects(par1World);
            }
            if (par3EntityPlayer != null) {
                par1World.func_6464_c();
            }
            if ((ichunkprovider = par1World.getChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
                ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
                int i = MathHelper.floor_float((int)this.thePlayer.posX) >> 4;
                int j = MathHelper.floor_float((int)this.thePlayer.posZ) >> 4;
                chunkproviderloadorgenerate.setCurrentChunkOver(i, j);
            }
            par1World.spawnPlayerWithLoadedChunks(this.thePlayer);
            this.playerController.func_6473_b(this.thePlayer);
            if (par1World.isNewWorld) {
                par1World.saveWorldIndirectly(this.loadingScreen);
            }
            this.renderViewEntity = this.thePlayer;
        } else {
            this.saveLoader.flushCache();
            this.thePlayer = null;
        }
        System.gc();
        this.systemTime = 0L;
    }

    private void convertMapFormat(String par1Str, String par2Str) {
        this.loadingScreen.printText("Converting World to " + this.saveLoader.getFormatName());
        this.loadingScreen.displayLoadingString("This may take a while :)");
        this.saveLoader.convertMapFormat(par1Str, this.loadingScreen);
        this.startWorld(par1Str, par2Str, new WorldSettings(0L, 0, true, false, WorldType.DEFAULT));
    }

    private void preloadWorld(String par1Str) {
        if (this.loadingScreen != null) {
            this.loadingScreen.printText(par1Str);
            this.loadingScreen.displayLoadingString(StatCollector.translateToLocal("menu.generatingTerrain"));
        }
        int c = 128;
        if (this.playerController.func_35643_e()) {
            c = 64;
        }
        int i = 0;
        int j = c * 2 / 16 + 1;
        j *= j;
        IChunkProvider ichunkprovider = this.theWorld.getChunkProvider();
        ChunkCoordinates chunkcoordinates = this.theWorld.getSpawnPoint();
        if (this.thePlayer != null) {
            chunkcoordinates.posX = (int)this.thePlayer.posX;
            chunkcoordinates.posZ = (int)this.thePlayer.posZ;
        }
        if (ichunkprovider instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            chunkproviderloadorgenerate.setCurrentChunkOver(chunkcoordinates.posX >> 4, chunkcoordinates.posZ >> 4);
        }
        for (int k = -c; k <= c; k += 16) {
            for (int l = -c; l <= c; l += 16) {
                if (this.loadingScreen != null) {
                    this.loadingScreen.setLoadingProgress(i++ * 100 / j);
                }
                this.theWorld.getBlockId(chunkcoordinates.posX + k, 64, chunkcoordinates.posZ + l);
                if (this.playerController.func_35643_e()) continue;
                while (this.theWorld.updatingLighting()) {
                }
            }
        }
        if (!this.playerController.func_35643_e()) {
            if (this.loadingScreen != null) {
                this.loadingScreen.displayLoadingString(StatCollector.translateToLocal("menu.simulating"));
            }
            int c1 = 2000;
            this.theWorld.dropOldChunks();
        }
    }

    public void installResource(String par1Str, File par2File) {
        int i = par1Str.indexOf("/");
        String s = par1Str.substring(0, i);
        par1Str = par1Str.substring(i + 1);
        if (s.equalsIgnoreCase("sound")) {
            this.sndManager.addSound(par1Str, par2File);
        } else if (s.equalsIgnoreCase("newsound")) {
            this.sndManager.addSound(par1Str, par2File);
        } else if (s.equalsIgnoreCase("streaming")) {
            this.sndManager.addStreaming(par1Str, par2File);
        } else if (s.equalsIgnoreCase("music")) {
            this.sndManager.addMusic(par1Str, par2File);
        } else if (s.equalsIgnoreCase("newmusic")) {
            this.sndManager.addMusic(par1Str, par2File);
        }
    }

    public String debugInfoRenders() {
        return this.renderGlobal.getDebugInfoRenders();
    }

    public String getEntityDebug() {
        return this.renderGlobal.getDebugInfoEntities();
    }

    public String getWorldProviderName() {
        return this.theWorld.getProviderName();
    }

    public String debugInfoEntities() {
        return "P: " + this.effectRenderer.getStatistics() + ". T: " + this.theWorld.getDebugLoadedEntities();
    }

    public void respawn(boolean par1, int par2, boolean par3) {
        IChunkProvider ichunkprovider;
        if (!this.theWorld.isRemote && !this.theWorld.worldProvider.canRespawnHere()) {
            this.usePortal(0);
        }
        ChunkCoordinates chunkcoordinates = null;
        ChunkCoordinates chunkcoordinates1 = null;
        boolean flag = true;
        if (this.thePlayer != null && !par1 && (chunkcoordinates = this.thePlayer.getSpawnChunk()) != null && (chunkcoordinates1 = EntityPlayer.verifyRespawnCoordinates(this.theWorld, chunkcoordinates)) == null) {
            this.thePlayer.addChatMessage("tile.bed.notValid");
        }
        if (chunkcoordinates1 == null) {
            chunkcoordinates1 = this.theWorld.getSpawnPoint();
            flag = false;
        }
        if ((ichunkprovider = this.theWorld.getChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            chunkproviderloadorgenerate.setCurrentChunkOver(chunkcoordinates1.posX >> 4, chunkcoordinates1.posZ >> 4);
        }
        this.theWorld.setSpawnLocation();
        this.theWorld.updateEntityList();
        int i = 0;
        if (this.thePlayer != null) {
            i = this.thePlayer.entityId;
            this.theWorld.setEntityDead(this.thePlayer);
        }
        EntityPlayerSP entityplayersp = this.thePlayer;
        this.renderViewEntity = null;
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.theWorld);
        if (par3) {
            this.thePlayer.copyPlayer(entityplayersp);
        }
        this.thePlayer.dimension = par2;
        this.renderViewEntity = this.thePlayer;
        this.thePlayer.preparePlayerToSpawn();
        if (flag) {
            this.thePlayer.setSpawnChunk(chunkcoordinates);
            this.thePlayer.setLocationAndAngles((float)chunkcoordinates1.posX + 0.5f, (float)chunkcoordinates1.posY + 0.1f, (float)chunkcoordinates1.posZ + 0.5f, 0.0f, 0.0f);
        }
        this.playerController.flipPlayer(this.thePlayer);
        this.theWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.movementInput = new MovementInputFromOptions(this.gameSettings);
        this.thePlayer.entityId = i;
        this.thePlayer.func_6420_o();
        this.playerController.func_6473_b(this.thePlayer);
        this.preloadWorld(StatCollector.translateToLocal("menu.respawning"));
        if (this.currentScreen instanceof GuiGameOver) {
            this.displayGuiScreen(null);
        }
    }

    public static void startMainThread1(String par0Str, String par1Str) {
        Minecraft.startMainThread(par0Str, par1Str, null);
    }

    public static void startMainThread(String par0Str, String par1Str, String par2Str) {
        boolean flag = false;
        String s = par0Str;
        Frame frame = new Frame("Minecraft");
        Canvas canvas = new Canvas();
        frame.setLayout(new BorderLayout());
        frame.add((Component)canvas, "Center");
        canvas.setPreferredSize(new Dimension(854, 480));
        frame.pack();
        frame.setLocationRelativeTo(null);
        MinecraftImpl minecraftimpl = new MinecraftImpl(frame, canvas, null, 854, 480, flag, frame);
        Thread thread = new Thread((Runnable)minecraftimpl, "Minecraft main thread");
        thread.setPriority(10);
        minecraftimpl.minecraftUri = "www.minecraft.net";
        minecraftimpl.session = s != null && par1Str != null ? new Session(s, par1Str) : new Session("Player" + System.currentTimeMillis() % 1000L, "");
        if (par2Str != null) {
            String[] as = par2Str.split(":");
            minecraftimpl.setServer(as[0], Integer.parseInt(as[1]));
        }
        frame.setVisible(true);
        frame.addWindowListener(new GameWindowListener(minecraftimpl, thread));
        thread.start();
    }

    public NetClientHandler getSendQueue() {
        if (this.thePlayer instanceof EntityClientPlayerMP) {
            return ((EntityClientPlayerMP)this.thePlayer).sendQueue;
        }
        return null;
    }

    public static void main(String[] par0ArrayOfStr) {
        String s = null;
        String s1 = null;
        s = "Player" + System.currentTimeMillis() % 1000L;
        if (par0ArrayOfStr.length > 0) {
            s = par0ArrayOfStr[0];
        }
        s1 = "-";
        if (par0ArrayOfStr.length > 1) {
            s1 = par0ArrayOfStr[1];
        }
        Minecraft.startMainThread1(s, s1);
    }

    public static boolean isGuiEnabled() {
        return theMinecraft == null || !Minecraft.theMinecraft.gameSettings.hideGUI;
    }

    public static boolean isFancyGraphicsEnabled() {
        return theMinecraft != null && Minecraft.theMinecraft.gameSettings.fancyGraphics;
    }

    public static boolean isAmbientOcclusionEnabled() {
        return theMinecraft != null && Minecraft.theMinecraft.gameSettings.ambientOcclusion;
    }

    public static boolean isDebugInfoEnabled() {
        return theMinecraft != null && Minecraft.theMinecraft.gameSettings.showDebugInfo;
    }

    public boolean lineIsCommand(String par1Str) {
        if (!par1Str.startsWith("/")) {
            // empty if block
        }
        return false;
    }

    private void clickMiddleMouseButton() {
        if (this.objectMouseOver != null) {
            Block block;
            int l;
            boolean flag = this.thePlayer.capabilities.isCreativeMode;
            int i = this.theWorld.getBlockId(this.objectMouseOver.blockX, this.objectMouseOver.blockY, this.objectMouseOver.blockZ);
            if (!flag) {
                if (i == Block.grass.blockID) {
                    i = Block.dirt.blockID;
                }
                if (i == Block.stairDouble.blockID) {
                    i = Block.stairSingle.blockID;
                }
                if (i == Block.bedrock.blockID) {
                    i = Block.stone.blockID;
                }
            }
            int j = 0;
            boolean flag1 = false;
            if (Item.itemsList[i] != null && Item.itemsList[i].getHasSubtypes()) {
                j = this.theWorld.getBlockMetadata(this.objectMouseOver.blockX, this.objectMouseOver.blockY, this.objectMouseOver.blockZ);
                flag1 = true;
            }
            if (Item.itemsList[i] != null && Item.itemsList[i] instanceof ItemBlock && (l = (block = Block.blocksList[i]).idDropped(j, this.thePlayer.worldObj.rand, 0)) > 0) {
                i = l;
            }
            this.thePlayer.inventory.setCurrentItem(i, j, flag1, flag);
            if (flag) {
                int k = this.thePlayer.inventorySlots.inventorySlots.size() - 9 + this.thePlayer.inventory.currentItem;
                this.playerController.sendSlotPacket(this.thePlayer.inventory.getStackInSlot(this.thePlayer.inventory.currentItem), k);
            }
        }
    }

    public static String getVersion() {
        return "1.2.5";
    }

    public static void createAndSendReport() {
        PlayerUsageSnooper playerusagesnooper = new PlayerUsageSnooper("client");
        playerusagesnooper.addData("version", Minecraft.getVersion());
        playerusagesnooper.addData("os_name", System.getProperty("os.name"));
        playerusagesnooper.addData("os_version", System.getProperty("os.version"));
        playerusagesnooper.addData("os_architecture", System.getProperty("os.arch"));
        playerusagesnooper.addData("memory_total", Runtime.getRuntime().totalMemory());
        playerusagesnooper.addData("memory_max", Runtime.getRuntime().maxMemory());
        playerusagesnooper.addData("java_version", System.getProperty("java.version"));
        playerusagesnooper.addData("opengl_version", GL11.glGetString((int)7938));
        playerusagesnooper.addData("opengl_vendor", GL11.glGetString((int)7936));
        playerusagesnooper.sendReport();
    }

    static {
        frameTimes = new long[512];
        tickTimes = new long[512];
        numRecordedFrameTimes = 0;
        hasPaidCheckTime = 0L;
        minecraftDir = null;
    }
}

