/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import java.util.ArrayList;
import net.minecraft.src.NBTTagCompound;

public class ItemRange {
    public int firstID;
    public int firstDamage = -1;
    public int lastID;
    public int lastDamage = -1;
    public byte state = 0;

    public ItemRange(int itemID) {
        this.firstID = itemID;
        this.firstDamage = -1;
        this.lastID = itemID;
        this.lastDamage = -1;
    }

    public ItemRange(int itemID, int damageStart, int damageEnd) {
        this.firstID = itemID;
        this.firstDamage = damageStart;
        this.lastID = itemID;
        this.lastDamage = damageEnd;
    }

    public ItemRange(int itemIDFirst, int itemIDLast) {
        this.firstID = itemIDFirst;
        this.firstDamage = -1;
        this.lastID = itemIDLast;
        this.lastDamage = -1;
    }

    public boolean isItemInRange(int id, int damage) {
        return id >= this.firstID && id <= this.lastID && (this.firstDamage == -1 || damage >= this.firstDamage && damage <= this.lastDamage);
    }

    public String toString() {
        if (this.firstID == this.lastID) {
            if (this.firstDamage == -1) {
                return "[" + this.firstID + "]";
            }
            if (this.firstDamage == this.lastDamage) {
                return "[" + this.firstID + ":" + this.firstDamage + "]";
            }
            return "[" + this.firstID + ":" + this.firstDamage + "-" + this.lastDamage + "]";
        }
        return "[" + this.firstID + "-" + this.lastID + "]";
    }

    public ItemRange(String rangestring) {
        rangestring = rangestring.replace(" ", "");
        rangestring = rangestring.replace("\t", "");
        rangestring = rangestring.substring(1, rangestring.length() - 1);
        String[] damagesplit = rangestring.split(":");
        if (damagesplit.length == 2) {
            String[] rangesplit = damagesplit[1].split("-");
            this.lastID = this.firstID = Integer.parseInt(damagesplit[0]);
            this.firstDamage = Integer.parseInt(rangesplit[0]);
            this.lastDamage = rangesplit.length == 2 ? Integer.parseInt(rangesplit[1]) : this.firstDamage;
        } else {
            String[] rangesplit = damagesplit[0].split("-");
            this.firstID = Integer.parseInt(rangesplit[0]);
            this.lastID = rangesplit.length == 2 ? Integer.parseInt(rangesplit[1]) : this.firstID;
        }
    }

    public void resetHashes() {
    }

    public boolean addItemIfInRange(int item, int damage, NBTTagCompound compound) {
        return false;
    }

    public void hideAllItems() {
    }

    public void showAllItems() {
    }

    public ArrayList<Integer> toIDList() {
        return null;
    }
}

