/*
 * Decompiled with CFR 0.152.
 */
package argo.jdom;

import argo.jdom.JsonNode;
import argo.jdom.JsonNodeType;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

final class JsonNumberNode
extends JsonNode {
    private static final Pattern PATTERN = Pattern.compile("(-?)(0|([1-9]([0-9]*)))(\\.[0-9]+)?((e|E)(\\+|-)?[0-9]+)?");
    private final String value;

    JsonNumberNode(String par1Str) {
        if (par1Str == null) {
            throw new NullPointerException("Attempt to construct a JsonNumber with a null value.");
        }
        if (!PATTERN.matcher(par1Str).matches()) {
            throw new IllegalArgumentException("Attempt to construct a JsonNumber with a String [" + par1Str + "] that does not match the JSON number specification.");
        }
        this.value = par1Str;
    }

    @Override
    public JsonNodeType getType() {
        return JsonNodeType.NUMBER;
    }

    @Override
    public String getText() {
        return this.value;
    }

    @Override
    public Map getFields() {
        throw new IllegalStateException("Attempt to get fields on a JsonNode without fields.");
    }

    @Override
    public List getElements() {
        throw new IllegalStateException("Attempt to get elements on a JsonNode without elements.");
    }

    public boolean equals(Object par1Obj) {
        if (this == par1Obj) {
            return true;
        }
        if (par1Obj == null || this.getClass() != par1Obj.getClass()) {
            return false;
        }
        JsonNumberNode jsonnumbernode = (JsonNumberNode)par1Obj;
        return this.value.equals(jsonnumbernode.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "JsonNumberNode value:[" + this.value + "]";
    }
}

