/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.sf.jadretro.AttributeEntry;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ClassOverflowException;

abstract class ClassEntity {
    ClassEntity() {
    }

    static Vector readAttributes(InputStream inputStream, ClassFile classFile) throws IOException {
        int n = ClassEntity.readUnsignedShort(inputStream);
        Vector<AttributeEntry> vector = new Vector<AttributeEntry>(n);
        while (n-- > 0) {
            vector.addElement(new AttributeEntry(inputStream, classFile));
        }
        return vector;
    }

    static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }

    static byte readByte(InputStream inputStream) throws IOException {
        return (byte)ClassEntity.readUnsignedByte(inputStream);
    }

    static int readUnsignedByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    static short readShort(InputStream inputStream) throws IOException {
        return (short)ClassEntity.readUnsignedShort(inputStream);
    }

    static int readUnsignedShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n << 8 | n2;
    }

    static int readInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return ((n << 8 | n2) << 8 | n3) << 8 | n4;
    }

    abstract void writeTo(OutputStream var1) throws IOException;

    static void writeToForArray(Vector vector, OutputStream outputStream) throws IOException {
        int n = vector.size();
        ClassEntity.writeCheckedUShort(outputStream, n);
        for (int i = 0; i < n; ++i) {
            ((ClassEntity)vector.elementAt(i)).writeTo(outputStream);
        }
    }

    static void writeCheckedUShort(OutputStream outputStream, int n) throws IOException {
        if ((n & 0xFFFF0000) != 0) {
            throw new ClassOverflowException();
        }
        ClassEntity.writeShort(outputStream, n);
    }

    static void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 8);
        outputStream.write(n);
    }

    static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 24);
        outputStream.write(n >> 16);
        outputStream.write(n >> 8);
        outputStream.write(n);
    }
}

