/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.sf.jadretro.AttrContent;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.LineNumberDesc;

final class AttrLineNumsContent
extends AttrContent {
    private Vector lineNumbers;

    AttrLineNumsContent(InputStream inputStream) throws IOException {
        int n = AttrLineNumsContent.readUnsignedShort(inputStream);
        this.lineNumbers = new Vector(n);
        while (n-- > 0) {
            this.lineNumbers.addElement(new LineNumberDesc(inputStream));
        }
    }

    static String nameValue() {
        return "LineNumberTable";
    }

    void mapLabelsPc(int[] nArray) throws BadClassFileException {
        AttrLineNumsContent.mapLabelsPcForArray(this.lineNumbers, nArray);
    }

    boolean removeLabelsInRange(int n, int n2) {
        return AttrLineNumsContent.removeLabelsInRangeForArray(this.lineNumbers, n, n2);
    }

    void incLabelIndices(int n, int n2) {
        AttrLineNumsContent.incLabelIndicesForArray(this.lineNumbers, n, n2);
    }

    void rebuildLabelsPc(int[] nArray) {
        AttrLineNumsContent.rebuildLabelsPcForArray(this.lineNumbers, nArray);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        AttrLineNumsContent.writeToForArray(this.lineNumbers, outputStream);
    }
}

