/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.vi;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_vi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "Gi\u1edd Chu\u1ea9n Qu\u1ea7n \u0110\u1ea3o Falkland",
               "FIST",
               "Gi\u1edd M\u00f9a H\u00e8 Qu\u1ea7n \u0110\u1ea3o Falkland",
               "FIST",
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Falkland",
               "FIT",
            };
        final String[] Iran = new String[] {
               "Gi\u1edd Chu\u1ea9n Iran",
               "IST",
               "Gi\u1edd M\u00f9a H\u00e8 Iran",
               "IDT",
               "Gi\u1edd Iran",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "Gi\u1edd Chu\u1ea9n Cape Verde",
               "CVST",
               "Gi\u1edd M\u00f9a H\u00e8 Cape Verde",
               "CVST",
               "Gi\u1edd Cape Verde",
               "CVT",
            };
        final String[] GMT = new String[] {
               "Gi\u1edd Trung B\u00ecnh Greenwich",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Ponape = new String[] {
               "Gi\u1edd Ponape",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "Gi\u1edd chu\u1ea9n Omsk",
               "OST",
               "Gi\u1edd m\u00f9a h\u00e8 Omsk",
               "OST",
               "Gi\u1edd Omsk",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "Gi\u1edd Kosrae",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Gi\u1edd Chu\u1ea9n Hawaii-Aleutian",
               "HAST",
               "Gi\u1edd M\u00f9a H\u00e8 Hawaii-Aleutian",
               "HADT",
               "Gi\u1edd Hawaii-Aleutian",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "Gi\u1edd Chu\u1ea9n Sakhalin",
               "SST",
               "Gi\u1edd m\u00f9a h\u00e8 Sakhalin",
               "SST",
               "Gi\u1edd Sakhalin",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Yakutsk",
               "YST",
               "Gi\u1edd m\u00f9a h\u00e8 Yakutsk",
               "YST",
               "Gi\u1edd Yakutsk",
               "YT",
            };
        final String[] Gambier = new String[] {
               "Gi\u1edd Gambier",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Paraguay = new String[] {
               "Gi\u1edd Chu\u1ea9n Paraguay",
               "PST",
               "Gi\u1edd M\u00f9a H\u00e8 Paraguay",
               "PST",
               "Gi\u1edd Paraguay",
               "PT",
            };
        final String[] Maldives = new String[] {
               "Gi\u1edd Maldives",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Truk = new String[] {
               "Gi\u1edd Chuuk",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "Gi\u1edd Chu\u1ea9n Nh\u1eadt B\u1ea3n",
               "JST",
               "Gi\u1edd M\u00f9a H\u00e8 Nh\u1eadt B\u1ea3n",
               "JDT",
               "Gi\u1edd Nh\u1eadt B\u1ea3n",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Gi\u1edd Chu\u1ea9n Vladivostok",
               "VST",
               "Gi\u1edd m\u00f9a h\u00e8 Vladivostok",
               "VST",
               "Gi\u1edd Vladivostok",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n T\u00e2y \u00c2u",
               "WEST",
               "Gi\u1edd M\u00f9a h\u00e8 T\u00e2y \u00c2u",
               "WEST",
               "Gi\u1edd T\u00e2y \u00c2u",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "Gi\u1edd Chu\u1ea9n Bangladesh",
               "BST",
               "Gi\u1edd M\u00f9a H\u00e8 Bangladesh",
               "BST",
               "Gi\u1edd Bangladesh",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "Gi\u1edd \u0110\u00f4ng Timor",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n T\u00e2y Greenland",
               "WGST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n T\u00e2y Greenland",
               "WGST",
               "Gi\u1edd Mi\u1ec1n T\u00e2y Greenland",
               "WGT",
            };
        final String[] Marquesas = new String[] {
               "Gi\u1edd Marquesas",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Colombia = new String[] {
               "Gi\u1edd Chu\u1ea9n Colombia",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 Colombia",
               "CST",
               "Gi\u1edd Colombia",
               "CT",
            };
        final String[] Wake = new String[] {
               "Gi\u1edd \u0110\u1ea3o Wake",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Suriname = new String[] {
               "Gi\u1edd Suriname",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Gulf = new String[] {
               "Gi\u1edd Chu\u1ea9n V\u00f9ng V\u1ecbnh",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Hovd = new String[] {
               "Gi\u1edd Chu\u1ea9n Hovd",
               "HST",
               "Gi\u1edd M\u00f9a H\u00e8 Hovd",
               "HST",
               "Gi\u1edd Hovd",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Gi\u1edd Chu\u1ea9n Amazon",
               "AST",
               "Gi\u1edd M\u00f9a H\u00e8 Amazon",
               "AST",
               "Gi\u1edd Amazon",
               "AT",
            };
        final String[] Tokelau = new String[] {
               "Gi\u1edd Tokelau",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Gilbert",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Mongolia = new String[] {
               "Gi\u1edd chu\u1ea9n Ulan Bator",
               "UBST",
               "Gi\u1edd m\u00f9a h\u00e8 Ulan Bator",
               "UBST",
               "Gi\u1edd Ulan Bator",
               "UBT",
            };
        final String[] Palau = new String[] {
               "Gi\u1edd Palau",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "Gi\u1edd Chu\u1ea9n New Caledonia",
               "NCST",
               "Gi\u1edd M\u00f9a H\u00e8 New Caledonia",
               "NCST",
               "Gi\u1edd New Caledonia",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "Gi\u1edd Nauru",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "Gi\u1edd chu\u1ea9n Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PST",
               "Gi\u1edd ban ng\u00e0y Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PDT",
               "Gi\u1edd Th\u00e1i B\u00ecnh D\u01b0\u01a1ng",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n m\u00e2y Argentina",
               "WAST",
               "Gi\u1edd m\u00f9a h\u00e8 mi\u1ec1n t\u00e2y Argentina",
               "WAST",
               "Gi\u1edd mi\u1ec1n t\u00e2y Argentina",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "Gi\u1edd Galapagos",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "Gi\u1edd Guiana thu\u1ed9c Ph\u00e1p",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n \u0110\u00f4ng Greenland",
               "EGST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n \u0110\u00f4ng Greenland",
               "EGST",
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Greenland",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "Gi\u1edd \u0110\u1ea3o Christmas",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "Gi\u1edd Chu\u1ea9n Volgograd",
               "VST",
               "Gi\u1edd M\u00f9a H\u00e8 Volgograd",
               "VST",
               "Gi\u1edd Volgograd",
               "VT",
            };
        final String[] Korea = new String[] {
               "Gi\u1edd Chu\u1ea9n H\u00e0n Qu\u1ed1c",
               "KST",
               "Gi\u1edd M\u00f9a H\u00e8 H\u00e0n Qu\u1ed1c",
               "KDT",
               "Gi\u1edd H\u00e0n Qu\u1ed1c",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "Gi\u1edd Chu\u1ea9n Vanuatu",
               "VST",
               "Gi\u1edd M\u00f9a H\u00e8 Vanuatu",
               "VST",
               "Gi\u1edd Vanuatu",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Gi\u1edd Chu\u1ea9n Argentina",
               "AST",
               "Gi\u1edd M\u00f9a H\u00e8 Argentina",
               "AST",
               "Gi\u1edd Argentina",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Gi\u1edd Chu\u1ea9n Lord Howe",
               "LHST",
               "Gi\u1edd M\u00f9a H\u00e8 Lord Howe",
               "LHDT",
               "Gi\u1edd Lord Howe",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "Gi\u1edd Syowa",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Arabian = new String[] {
               "Gi\u1edd Chu\u1ea9n A-r\u1eadp",
               "AST",
               "Gi\u1edd M\u00f9a H\u00e8 A-r\u1eadp",
               "ADT",
               "Gi\u1edd A-r\u1eadp",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n \u0110\u00f4ng N\u01b0\u1edbc \u00dac",
               "AEST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n \u0110\u00f4ng N\u01b0\u1edbc \u00dac",
               "AEDT",
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng N\u01b0\u1edbc \u00dac",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Irkutsk",
               "IST",
               "Gi\u1edd M\u00f9a H\u00e8 Irkutsk",
               "IST",
               "Gi\u1edd Irkutsk",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "Gi\u1edd Chu\u1ea9n Mauritius",
               "MST",
               "Gi\u1edd M\u00f9a H\u00e8 Mauritius",
               "MST",
               "Gi\u1edd Mauritius",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "Gi\u1edd \u1ea4n \u0110\u1ed9 D\u01b0\u01a1ng",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Gi\u1edd Chu\u1ea9n Choibalsan",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 Choibalsan",
               "CST",
               "Gi\u1edd Choibalsan",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n \u0111\u00f4ng",
               "EST",
               "Gi\u1edd ban ng\u00e0y mi\u1ec1n \u0111\u00f4ng",
               "EDT",
               "Gi\u1edd mi\u1ec1n \u0111\u00f4ng",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n T\u00e2y N\u01b0\u1edbc \u00dac",
               "AWST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n T\u00e2y N\u01b0\u1edbc \u00dac",
               "AWDT",
               "Gi\u1edd Mi\u1ec1n T\u00e2y N\u01b0\u1edbc \u00dac",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n Trung T\u00e2y N\u01b0\u1edbc \u00dac",
               "ACWST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n Trung T\u00e2y N\u01b0\u1edbc \u00dac",
               "ACWDT",
               "Gi\u1edd Mi\u1ec1n Trung T\u00e2y N\u01b0\u1edbc \u00dac",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Gi\u1edd Chu\u1ea9n Krasnoyarsk",
               "KST",
               "Gi\u1edd M\u00f9a H\u00e8 Krasnoyarsk",
               "KST",
               "Gi\u1edd Krasnoyarsk",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Indonexia",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "Gi\u1edd Venezuela",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Pitcairn = new String[] {
               "Gi\u1edd Pitcairn",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Bhutan = new String[] {
               "Gi\u1edd Bhutan",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "Gi\u1edd Chu\u1ea9n Fernando de Noronha",
               "FNST",
               "Gi\u1edd M\u00f9a H\u00e8 Fernando de Noronha",
               "FNST",
               "Gi\u1edd Fernando de Noronha",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Gi\u1edd chu\u1ea9n Novosibirsk",
               "NST",
               "Gi\u1edd m\u00f9a h\u00e8 Novosibirsk",
               "NST",
               "Gi\u1edd Novosibirsk",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n n\u00fai",
               "MST",
               "Gi\u1edd ban ng\u00e0y mi\u1ec1n n\u00fai",
               "MDT",
               "Gi\u1edd mi\u1ec1n n\u00fai",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Norfolk",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "Gi\u1edd Niue",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Vostok = new String[] {
               "Gi\u1edd Vostok",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "Gi\u1edd Chu\u1ea9n Alaska",
               "AKST",
               "Gi\u1edd M\u00f9a H\u00e8 Alaska",
               "AKDT",
               "Gi\u1edd Alaska",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "Gi\u1edd Chu\u1ea9n Armenia",
               "AST",
               "Gi\u1edd M\u00f9a H\u00e8 Armenia",
               "AST",
               "Gi\u1edd Armenia",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Marshall",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "Gi\u1edd Chu\u1ea9n Mi\u1ec1n Trung N\u01b0\u1edbc \u00dac",
               "ACST",
               "Gi\u1edd M\u00f9a H\u00e8 Mi\u1ec1n Trung N\u01b0\u1edbc \u00dac",
               "ACDT",
               "Gi\u1edd Mi\u1ec1n Trung N\u01b0\u1edbc \u00dac",
               "CAT",
            };
        final String[] Azores = new String[] {
               "Gi\u1edd Chu\u1ea9n Azores",
               "AST",
               "Gi\u1edd M\u00f9a H\u00e8 Azores",
               "AST",
               "Gi\u1edd Azores",
               "AT",
            };
        final String[] Reunion = new String[] {
               "Gi\u1edd Reunion",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "Gi\u1edd \u0110\u00f4ng D\u01b0\u01a1ng",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "Gi\u1edd Ecuador",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "Gi\u1edd Chu\u1ea9n Magadan",
               "MST",
               "Gi\u1edd m\u00f9a h\u00e8 Magadan",
               "MST",
               "Gi\u1edd Magadan",
               "MT",
            };
        final String[] Chatham = new String[] {
               "Gi\u1edd Chu\u1ea9n Chatham",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 Chatham",
               "CDT",
               "Gi\u1edd Chatham",
               "CT",
            };
        final String[] Davis = new String[] {
               "Gi\u1edd Davis",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "Gi\u1edd Chu\u1ea9n Cuba",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 Cuba",
               "CDT",
               "Gi\u1edd Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Gi\u1edd Chu\u1ea9n T\u00e2y Phi",
               "WAST",
               "Gi\u1edd M\u00f9a H\u00e8 T\u00e2y Phi",
               "WAST",
               "Gi\u1edd T\u00e2y Phi",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Gi\u1edd Chu\u1ea9n Matxc\u01a1va",
               "MST",
               "Gi\u1edd M\u00f9a H\u00e8 Matxc\u01a1va",
               "MST",
               "Gi\u1edd Matxc\u01a1va",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Gi\u1edd Papua New Guinea",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Gi\u1edd Mi\u1ec1n \u0110\u00f4ng Kazakhstan",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "Gi\u1edd Chu\u1ea9n New Zealand",
               "NZST",
               "Gi\u1edd M\u00f9a H\u00e8 New Zealand",
               "NZDT",
               "Gi\u1edd New Zealand",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "Gi\u1edd Chu\u1ea9n H\u1ed3ng K\u00f4ng",
               "HKST",
               "Gi\u1edd M\u00f9a H\u00e8 H\u1ed3ng K\u00f4ng",
               "HKST",
               "Gi\u1edd H\u1ed3ng K\u00f4ng",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "Gi\u1edd Chu\u1ea9n Brasilia",
               "BST",
               "Gi\u1edd M\u00f9a H\u00e8 Brasilia",
               "BST",
               "Gi\u1edd Brasilia",
               "BT",
            };
        final String[] Cocos = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Cocos",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "Gi\u1edd Afghanistan",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "Gi\u1edd Mi\u1ec1n T\u00e2y Indonexia",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "Gi\u1edd Brunei Darussalam",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Phoenix",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "Gi\u1edd Seychelles",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "Gi\u1edd Trung Phi",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u1ea3o Ph\u1ee5c Sinh",
               "EIST",
               "Gi\u1edd M\u00f9a H\u00e8 \u0110\u1ea3o Ph\u1ee5c Sinh",
               "EIST",
               "Gi\u1edd \u0110\u1ea3o Ph\u1ee5c Sinh",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "Gi\u1edd Nam Georgia",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "Gi\u1edd Mi\u1ec1n Trung Indonexia",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Georgia = new String[] {
               "Gi\u1edd Chu\u1ea9n Georgia",
               "GST",
               "Gi\u1edd M\u00f9a H\u00e8 Georgia",
               "GST",
               "Gi\u1edd Georgia",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "Gi\u1edd Bolivia",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Gi\u1edd Chu\u1ea9n Peru",
               "PST",
               "Gi\u1edd M\u00f9a H\u00e8 Peru",
               "PST",
               "Gi\u1edd Peru",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "Gi\u1edd Chamorro",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "Gi\u1edd Chu\u1ea9n Newfoundland",
               "NST",
               "Gi\u1edd M\u00f9a H\u00e8 Newfoundland",
               "NDT",
               "Gi\u1edd Newfoundland",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Line",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "Gi\u1edd Chu\u1ea9n Qu\u1ea7n \u0110\u1ea3o Cook",
               "CIST",
               "Gi\u1edd N\u1eeda M\u00f9a H\u00e8 Qu\u1ea7n \u0110\u1ea3o Cook",
               "CIHST",
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Cook",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "Gi\u1edd chu\u1ea9n mi\u1ec1n trung",
               "CST",
               "Gi\u1edd ban ng\u00e0y mi\u1ec1n trung",
               "CDT",
               "Gi\u1edd mi\u1ec1n trung",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Gi\u1edd \u0110\u00f4ng Phi",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "Gi\u1edd Chu\u1ea9n Azerbaijan",
               "AST",
               "Gi\u1edd M\u00f9a H\u00e8 Azerbaijan",
               "AST",
               "Gi\u1edd Azerbaijan",
               "AT",
            };
        final String[] Guyana = new String[] {
               "Gi\u1edd Guyana",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Gi\u1edd Chu\u1ea9n Yekaterinburg",
               "YST",
               "Gi\u1edd m\u00f9a h\u00e8 Yekaterinburg",
               "YST",
               "Gi\u1edd Yekaterinburg",
               "YT",
            };
        final String[] China = new String[] {
               "Gi\u1edd Chu\u1ea9n Trung Qu\u1ed1c",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 Trung Qu\u1ed1c",
               "CDT",
               "Gi\u1edd Trung Qu\u1ed1c",
               "CT",
            };
        final String[] Samoa = new String[] {
               "Gi\u1edd Chu\u1ea9n Samoa",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "Gi\u1edd Chu\u1ea9n Tonga",
               "TST",
               "Gi\u1edd M\u00f9a H\u00e8 Tonga",
               "TST",
               "Gi\u1edd Tonga",
               "TT",
            };
        final String[] Solomon = new String[] {
               "Gi\u1edd Qu\u1ea7n \u0110\u1ea3o Solomon",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "Gi\u1edd Chu\u1ea9n Nam Phi",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Gi\u1edd Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "Gi\u1edd Nam C\u1ef1c v\u00e0 Nam N\u01b0\u1edbc Ph\u00e1p",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "Gi\u1edd Chu\u1ea9n Chile",
               "CST",
               "Gi\u1edd M\u00f9a H\u00e8 Chile",
               "CST",
               "Gi\u1edd Chile",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Gi\u1edd Mi\u1ec1n T\u00e2y Kazakhstan",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Gi\u1edd Chu\u1ea9n Israel",
               "IST",
               "Gi\u1edd M\u00f9a H\u00e8 Israel",
               "IDT",
               "Gi\u1edd Israel",
               "IT",
            };
        final String[] Tahiti = new String[] {
               "Gi\u1edd Tahiti",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "Gi\u1edd Mawson",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Gi\u1edd Chu\u1ea9n Pierre v\u00e0 Miquelon",
               "PMST",
               "Gi\u1edd M\u00f9a H\u00e8 Pierre v\u00e0 Miquelon",
               "PMDT",
               "Gi\u1edd Pierre v\u00e0 Miquelon",
               "PMT",
            };
        final String[] Fiji = new String[] {
               "Gi\u1edd Chu\u1ea9n Fiji",
               "FST",
               "Gi\u1edd M\u00f9a H\u00e8 Fiji",
               "FST",
               "Gi\u1edd Fiji",
               "FT",
            };
        final String[] Rothera = new String[] {
               "Gi\u1edd Rothera",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "Gi\u1edd Chu\u1ea9n Trung \u00c2u",
               "CEST",
               "Gi\u1edd M\u00f9a H\u00e8 Trung \u00c2u",
               "CEST",
               "Gi\u1edd Trung \u00c2u",
               "CET",
            };
        final String[] India = new String[] {
               "Gi\u1edd Chu\u1ea9n \u1ea4n \u0110\u1ed9",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "Gi\u1edd Dumont-d'Urville",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Wallis = new String[] {
               "Gi\u1edd Wallis v\u00e0 Futuna",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "Gi\u1edd Tuvalu",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Europe_Eastern = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u00f4ng \u00c2u",
               "EEST",
               "Gi\u1edd M\u00f9a H\u00e8 \u0110\u00f4ng \u00c2u",
               "EEST",
               "Gi\u1edd \u0110\u00f4ng \u00c2u",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Gi\u1edd Chu\u1ea9n \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "AST",
               "Gi\u1edd M\u00f9a h\u00e8 \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "ADT",
               "Gi\u1edd \u0110\u1ea1i T\u00e2y D\u01b0\u01a1ng",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "Gi\u1edd Chu\u1ea9n Uruguay",
               "UST",
               "Gi\u1edd M\u00f9a H\u00e8 Uruguay",
               "UST",
               "Gi\u1edd Uruguay",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Africa/Bissau", GMT },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "Atlantic/Stanley", Falkland },
            { "America/Lima", Peru },
            { "Europe/Rome", Europe_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "Pacific/Wallis", Wallis },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Nome", Alaska },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Wake", Wake },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Pacific/Noumea", New_Caledonia },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
