/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json;

import com.oracle.javafx.jmx.json.ImmutableJSONDocument;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class JSONDocument
implements Iterable<JSONDocument> {
    public static final String JSON_XPATH_URI = "http://javafx.com/json/xpath";
    public static final JSONDocument EMPTY_ARRAY = new ImmutableJSONDocument(Type.ARRAY);
    public static final JSONDocument EMPTY_OBJECT = new ImmutableJSONDocument(Type.OBJECT);
    private final Type type;
    private final List<Object> array;
    private final Map<String, Object> object;

    public static JSONDocument createObject() {
        return new JSONDocument(Type.OBJECT, 0);
    }

    public static JSONDocument createArray() {
        return JSONDocument.createArray(0);
    }

    public static JSONDocument createArray(int length) {
        return new JSONDocument(Type.ARRAY, length);
    }

    public JSONDocument(Type type) {
        this(type, 0);
    }

    private JSONDocument(Type type, int length) {
        this.type = type;
        if (type == Type.ARRAY) {
            Vector<Object> v = new Vector<Object>(length);
            v.setSize(length);
            this.array = v;
            this.object = null;
        } else if (type == Type.OBJECT) {
            this.array = null;
            this.object = new LinkedHashMap<String, Object>();
        } else {
            this.array = null;
            this.object = null;
            throw new IllegalArgumentException();
        }
    }

    public Type type() {
        return this.type;
    }

    public List<Object> array() {
        if (this.type != Type.ARRAY) {
            return EMPTY_ARRAY.array();
        }
        return this.array;
    }

    public Map<String, Object> object() {
        if (this.type != Type.OBJECT) {
            return EMPTY_OBJECT.object();
        }
        return this.object;
    }

    public boolean isArray() {
        return this.type == Type.ARRAY && this.array != null;
    }

    public boolean isObject() {
        return this.type == Type.OBJECT && this.object != null;
    }

    public void toJSON(Writer writer) throws IOException {
        this.printJSON(writer, this.isArray() ? this.array() : this.object(), 0, false);
    }

    public String toJSON() {
        StringWriter sb = new StringWriter(4096);
        try {
            this.printJSON(sb, this.isArray() ? this.array() : this.object(), 0, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.getBuffer().toString();
    }

    private void printJSON(Writer sb, Object obj, int depth, boolean pretty) throws IOException {
        if (obj instanceof JSONDocument) {
            JSONDocument doc = (JSONDocument)obj;
            if (doc.isArray()) {
                this.printArray(sb, doc.array(), depth, pretty);
            } else if (doc.isObject()) {
                this.printObject(sb, doc.object(), depth, pretty);
            } else assert (false);
        } else if (obj instanceof List) {
            this.printArray(sb, (List)obj, depth, pretty);
        } else if (obj instanceof Map) {
            this.printObject(sb, (Map)obj, depth, pretty);
        } else if (obj instanceof String) {
            sb.append("\"");
            JSONDocument.printEscapedString(sb, (String)obj);
            sb.append("\"");
        } else if (obj != null) {
            sb.append(obj.toString());
        } else {
            sb.append("null");
        }
    }

    private void printArray(Writer sb, List<Object> obj, int depth, boolean pretty) throws IOException {
        Iterator<Object> i = obj.iterator();
        int size = obj.size();
        int count = 0;
        sb.append("[");
        if (size > 1) {
            this.prettyPrint(sb, ++depth, pretty);
        }
        while (i.hasNext()) {
            this.printJSON(sb, i.next(), depth, pretty);
            if (count < size - 1) {
                sb.append(",");
                this.prettyPrint(sb, depth, pretty);
            }
            ++count;
        }
        if (size > 1) {
            this.prettyPrint(sb, --depth, pretty);
        }
        sb.append("]");
    }

    private void printObject(Writer sb, Map<String, Object> obj, int depth, boolean pretty) throws IOException {
        Iterator<Map.Entry<String, Object>> i = obj.entrySet().iterator();
        int size = obj.size();
        int count = 0;
        sb.append("{");
        if (size > 1) {
            this.prettyPrint(sb, ++depth, pretty);
        }
        while (i.hasNext()) {
            Map.Entry<String, Object> me = i.next();
            sb.append("\"");
            sb.append(me.getKey());
            sb.append("\":");
            Object value = me.getValue();
            if (pretty && size > 1) {
                int objSize = 0;
                if (value instanceof JSONDocument) {
                    JSONDocument doc = (JSONDocument)value;
                    if (doc.isArray()) {
                        objSize = doc.array().size();
                    } else if (doc.isObject()) {
                        objSize = doc.object().size();
                    } else assert (false);
                }
                if (objSize > 0) {
                    this.prettyPrint(sb, depth, pretty);
                }
            }
            this.printJSON(sb, value, depth, pretty);
            if (count < size - 1) {
                sb.append(",");
                this.prettyPrint(sb, depth, pretty);
            }
            ++count;
        }
        if (size > 1) {
            this.prettyPrint(sb, --depth, pretty);
        }
        sb.append("}");
    }

    static void printEscapedString(Writer sb, String s) throws IOException {
        char[] ca = s.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (ca[i] == '\'') {
                sb.append("'");
                continue;
            }
            if (ca[i] == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (ca[i] == '/') {
                sb.append("\\/");
                continue;
            }
            if (ca[i] == '\u0007') {
                sb.append("\\a");
                continue;
            }
            if (ca[i] == '\b') {
                sb.append("\\b");
                continue;
            }
            if (ca[i] == '\t') {
                sb.append("\\t");
                continue;
            }
            if (ca[i] == '\n') {
                sb.append("\\n");
                continue;
            }
            if (ca[i] == '\u000b') {
                sb.append("\\v");
                continue;
            }
            if (ca[i] == '\f') {
                sb.append("\\f");
                continue;
            }
            if (ca[i] == '\r') {
                sb.append("\\r");
                continue;
            }
            if (ca[i] == '\u0000') {
                sb.append("\\0");
                continue;
            }
            if (ca[i] > '\u007f' && ca[i] < '\uffff') {
                sb.append("\\u");
                sb.append(String.format("%04X", ca[i]));
                continue;
            }
            sb.append(ca[i]);
        }
    }

    private void prettyPrint(Writer sb, int depth, boolean pretty) throws IOException {
        if (pretty) {
            sb.append("\n");
            for (int i = 0; i < depth; ++i) {
                sb.append(" ");
            }
        }
    }

    public String toString() {
        StringWriter sb = new StringWriter(4096);
        try {
            this.printJSON(sb, this.isArray() ? this.array() : this.object(), 0, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.getBuffer().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSONDocument) {
            JSONDocument doc = (JSONDocument)obj;
            return this.isArray() ? this.array().equals(doc.array()) : (this.isObject() ? this.object().equals(doc.object()) : false);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.isArray() ? this.array().hashCode() : (this.isObject() ? this.object().hashCode() : 0));
        return hash;
    }

    public JSONDocument get(String key) {
        Object value;
        if (this.object != null && (value = this.object().get(key)) instanceof JSONDocument) {
            return (JSONDocument)value;
        }
        return EMPTY_OBJECT;
    }

    public JSONDocument get(int index) {
        Object value;
        if (this.array != null && (value = this.array().get(index)) instanceof JSONDocument) {
            return (JSONDocument)value;
        }
        return EMPTY_ARRAY;
    }

    public Map<String, Object> getMap(String key) {
        Object obj = this.get(key, JSONDocument.class);
        if (obj instanceof JSONDocument) {
            return this.getMap((JSONDocument)obj);
        }
        return EMPTY_OBJECT.object();
    }

    public Map<String, Object> getMap(int index) {
        Object obj = this.get(index, JSONDocument.class);
        if (obj instanceof JSONDocument) {
            return this.getMap((JSONDocument)obj);
        }
        return EMPTY_OBJECT.object();
    }

    public List<Object> getList(String key) {
        Object obj = this.get(key, JSONDocument.class);
        if (obj instanceof JSONDocument) {
            return this.getList((JSONDocument)obj);
        }
        return EMPTY_ARRAY.array();
    }

    public List<Object> getList(int index) {
        Object obj = this.get(index, JSONDocument.class);
        if (obj instanceof JSONDocument) {
            return this.getList((JSONDocument)obj);
        }
        return EMPTY_ARRAY.array();
    }

    public String getString(String key) {
        return (String)this.get(key, String.class);
    }

    public String getString(int index) {
        return (String)this.get(index, String.class);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key, Boolean.class);
    }

    public Boolean getBoolean(int index) {
        return (Boolean)this.get(index, Boolean.class);
    }

    public Number getNumber(String key) {
        return (Number)this.get(key, Number.class);
    }

    public Number getNumber(int index) {
        return (Number)this.get(index, Number.class);
    }

    public boolean isNull(String key) {
        if (this.object != null) {
            return null == this.object().get(key);
        }
        return false;
    }

    public boolean isNull(int index) {
        if (this.array != null) {
            return null == this.array().get(index);
        }
        return false;
    }

    private Map<String, Object> getMap(JSONDocument doc) {
        if (doc != null) {
            return doc.object();
        }
        return EMPTY_OBJECT.object();
    }

    private List<Object> getList(JSONDocument doc) {
        if (doc != null) {
            return doc.array();
        }
        return EMPTY_ARRAY.array();
    }

    private Object get(String key, Class<?> type) {
        Object value;
        if (this.object != null && type.isInstance(value = this.object().get(key))) {
            return type.cast(value);
        }
        return null;
    }

    private Object get(int index, Class<?> type) {
        Object value;
        if (this.array != null && type.isInstance(value = this.array().get(index))) {
            return type.cast(value);
        }
        return null;
    }

    public JSONDocument set(String key, JSONDocument child) {
        return (JSONDocument)this.set(key, (Object)child, JSONDocument.class);
    }

    public JSONDocument set(int index, JSONDocument value) {
        return (JSONDocument)this.set(index, (Object)value, JSONDocument.class);
    }

    public String setString(String key, String value) {
        return (String)this.set(key, (Object)value, String.class);
    }

    public String setString(int index, String value) {
        return (String)this.set(index, (Object)value, String.class);
    }

    public Boolean setBoolean(String key, Boolean value) {
        return (Boolean)this.set(key, (Object)value, Boolean.class);
    }

    public Boolean setBoolean(int index, Boolean value) {
        return (Boolean)this.set(index, (Object)value, Boolean.class);
    }

    public Number setNumber(String key, Number value) {
        return (Number)this.set(key, (Object)value, Number.class);
    }

    public Number setNumber(int index, Number value) {
        return (Number)this.set(index, (Object)value, Number.class);
    }

    public Object setNull(String key) {
        if (this.object != null) {
            return this.object.put(key, null);
        }
        return null;
    }

    public Object setNull(int index) {
        if (this.array != null) {
            return this.array.set(index, null);
        }
        return null;
    }

    private Object set(String key, Object value, Class<?> type) {
        if (this.object != null && type.isInstance(value)) {
            return type.cast(this.object().put(key, value));
        }
        return null;
    }

    private Object set(int index, Object value, Class<?> type) {
        if (this.array != null && type.isInstance(value)) {
            return type.cast(this.array().set(index, value));
        }
        return null;
    }

    public IteratorWrapper iterator() {
        return new IteratorWrapper(this.isObject() ? this.object().values().iterator() : this.array().iterator());
    }

    static class IteratorWrapper
    implements Iterator<JSONDocument> {
        final Iterator<Object> iterator;

        IteratorWrapper(Iterator<Object> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public JSONDocument next() {
            Object value = this.iterator.next();
            if (value instanceof JSONDocument) {
                return (JSONDocument)value;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    public static enum Type {
        ARRAY,
        OBJECT;

    }
}

