/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.resource;

import com.sun.javafx.tools.resource.PackagerResource;
import com.sun.javafx.tools.resource.ResourceTraversal;
import java.io.File;

public abstract class DetailedResourceTraversal
implements ResourceTraversal {
    private String lastRelativePath = "";
    private boolean lastIsDirectory = true;

    @Override
    public final boolean traverse(PackagerResource rootResource, File file, String relativePath) {
        boolean isDirectory = file.isDirectory();
        if (!this.traverseBetween(this.lastRelativePath, this.lastIsDirectory, relativePath, isDirectory)) {
            return false;
        }
        this.lastRelativePath = relativePath;
        this.lastIsDirectory = isDirectory;
        return isDirectory ? true : this.traverseFile(rootResource, file, relativePath);
    }

    public final void finish() {
        this.traverseBetween(this.lastRelativePath, this.lastIsDirectory, "", true);
        this.lastRelativePath = "";
        this.lastIsDirectory = true;
    }

    protected abstract boolean enterDirectory(String var1);

    protected abstract boolean exitDirectory(String var1);

    protected abstract boolean traverseFile(PackagerResource var1, File var2, String var3);

    private boolean traverseBetween(String relPath1, boolean isDirectory1, String relPath2, boolean isDirectory2) {
        int commonPathLength = DetailedResourceTraversal.getCommonPathLength(relPath1, relPath2);
        return this.traverseDown(relPath1, isDirectory1, commonPathLength) && this.traverseUp(relPath2, isDirectory2, commonPathLength);
    }

    private boolean traverseDown(String relPath, boolean isDirectory, int commonPathLength) {
        if (relPath.length() == commonPathLength) {
            return true;
        }
        if (isDirectory && !this.exitDirectory(relPath)) {
            return false;
        }
        int prevSeparator = DetailedResourceTraversal.findPrevSeparator(relPath, relPath.length() - 1, commonPathLength);
        while (prevSeparator > commonPathLength) {
            if (!this.exitDirectory(relPath.substring(0, prevSeparator))) {
                return false;
            }
            prevSeparator = DetailedResourceTraversal.findPrevSeparator(relPath, prevSeparator - 1, commonPathLength);
        }
        return true;
    }

    private boolean traverseUp(String relPath, boolean isDirectory, int commonPathLength) {
        if (relPath.length() == commonPathLength) {
            return true;
        }
        int pathLength = relPath.length();
        int nextSeparator = DetailedResourceTraversal.findNextSeparator(relPath, commonPathLength + 1, pathLength);
        while (nextSeparator < pathLength) {
            if (!this.enterDirectory(relPath.substring(0, nextSeparator))) {
                return false;
            }
            nextSeparator = DetailedResourceTraversal.findNextSeparator(relPath, nextSeparator + 1, pathLength);
        }
        return !isDirectory || this.enterDirectory(relPath);
    }

    private static int findPrevSeparator(String relPath, int fromIndex, int minIndex) {
        int prevSeparator = relPath.lastIndexOf(47, fromIndex);
        return prevSeparator < minIndex ? minIndex : prevSeparator;
    }

    private static int findNextSeparator(String relPath, int fromIndex, int maxIndex) {
        int nextSeparator = relPath.indexOf(47, fromIndex);
        return nextSeparator == -1 || nextSeparator > maxIndex ? maxIndex : nextSeparator;
    }

    private static int getCommonPathLength(String relPath1, String relPath2) {
        int i;
        char[] path1Chars = relPath1.toCharArray();
        char[] path2Chars = relPath2.toCharArray();
        int lastMatchIndex = 0;
        for (i = 0; i < path1Chars.length && i < path2Chars.length && path1Chars[i] == path2Chars[i]; ++i) {
            if (path1Chars[i] != '/') continue;
            lastMatchIndex = i;
        }
        if (i == path1Chars.length) {
            if (i == path2Chars.length || path2Chars[i] == '/') {
                lastMatchIndex = i;
            }
        } else if (i == path2Chars.length && path1Chars[i] == '/') {
            lastMatchIndex = i;
        }
        return lastMatchIndex;
    }
}

