/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.windows.WinAppBundler;
import com.oracle.tools.packager.windows.WinResources;
import com.oracle.tools.packager.windows.WinServiceBundler;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WinMsiBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(WinMsiBundler.class.getName());
    public static final BundlerParamInfo<WinAppBundler> APP_BUNDLER = new WindowsBundlerParam<WinAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundler.description"), "win.app.bundler", WinAppBundler.class, params -> new WinAppBundler(), null);
    public static final BundlerParamInfo<WinServiceBundler> SERVICE_BUNDLER = new WindowsBundlerParam<WinServiceBundler>(I18N.getString("param.service-bundler.name"), I18N.getString("param.service-bundler.description"), "win.service.bundler", WinServiceBundler.class, params -> new WinServiceBundler(), null);
    public static final BundlerParamInfo<Boolean> CAN_USE_WIX36 = new WindowsBundlerParam<Boolean>(I18N.getString("param.can-use-wix36.name"), I18N.getString("param.can-use-wix36.description"), "win.msi.canUseWix36", Boolean.class, params -> false, (s, p) -> Boolean.valueOf(s));
    public static final BundlerParamInfo<File> CONFIG_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, params -> {
        File imagesRoot = new File((File)WindowsBundlerParam.BUILD_ROOT.fetchFrom((Map<String, ? super Object>)params), "windows");
        imagesRoot.mkdirs();
        return imagesRoot;
    }, (s, p) -> null);
    public static final BundlerParamInfo<File> MSI_IMAGE_DIR = new WindowsBundlerParam<File>(I18N.getString("param.image-dir.name"), I18N.getString("param.image-dir.description"), "win.msi.imageDir", File.class, params -> {
        File imagesRoot = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)params);
        if (!imagesRoot.exists()) {
            imagesRoot.mkdirs();
        }
        return new File(imagesRoot, "win-msi.image");
    }, (s, p) -> null);
    public static final BundlerParamInfo<File> WIN_APP_IMAGE = new WindowsBundlerParam<File>(I18N.getString("param.app-dir.name"), I18N.getString("param.app-dir.description"), "win.app.image", File.class, null, (s, p) -> null);
    public static final StandardBundlerParam<Boolean> MSI_SYSTEM_WIDE = new StandardBundlerParam<Boolean>(I18N.getString("param.system-wide.name"), I18N.getString("param.system-wide.description"), "win.msi.systemWide", Boolean.class, params -> params.containsKey(WindowsBundlerParam.SYSTEM_WIDE.getID()) ? (Boolean)WindowsBundlerParam.SYSTEM_WIDE.fetchFrom((Map<String, ? super Object>)params) : Boolean.valueOf(true), (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? null : Boolean.valueOf(s));
    public static final StandardBundlerParam<String> PRODUCT_VERSION = new StandardBundlerParam<String>(I18N.getString("param.product-version.name"), I18N.getString("param.product-version.description"), "win.msi.productVersion", String.class, WindowsBundlerParam.VERSION::fetchFrom, (s, p) -> s);
    public static final BundlerParamInfo<UUID> UPGRADE_UUID = new WindowsBundlerParam<UUID>(I18N.getString("param.upgrade-uuid.name"), I18N.getString("param.upgrade-uuid.description"), "win.msi.upgradeUUID", UUID.class, params -> UUID.randomUUID(), (s, p) -> UUID.fromString(s));
    private static final String TOOL_CANDLE = "candle.exe";
    private static final String TOOL_LIGHT = "light.exe";
    private static final String AUTODETECT_DIRS = ";C:\\Program Files (x86)\\WiX Toolset v3.9\\bin;C:\\Program Files\\WiX Toolset v3.9\\bin;C:\\Program Files (x86)\\WiX Toolset v3.8\\bin;C:\\Program Files\\WiX Toolset v3.8\\bin;C:\\Program Files (x86)\\WiX Toolset v3.7\\bin;C:\\Program Files\\WiX Toolset v3.7\\bin";
    public static final BundlerParamInfo<String> TOOL_CANDLE_EXECUTABLE = new WindowsBundlerParam<String>(I18N.getString("param.candle-path.name"), I18N.getString("param.candle-path.description"), "win.msi.candle.exe", String.class, params -> {
        for (String dirString : (System.getenv("PATH") + AUTODETECT_DIRS).split(";")) {
            File f = new File(dirString.replace("\"", ""), TOOL_CANDLE);
            if (!f.isFile()) continue;
            return f.toString();
        }
        return null;
    }, null);
    public static final BundlerParamInfo<String> TOOL_LIGHT_EXECUTABLE = new WindowsBundlerParam<String>(I18N.getString("param.light-path.name"), I18N.getString("param.light-path.description"), "win.msi.light.exe", String.class, params -> {
        for (String dirString : (System.getenv("PATH") + AUTODETECT_DIRS).split(";")) {
            File f = new File(dirString.replace("\"", ""), TOOL_LIGHT);
            if (!f.isFile()) continue;
            return f.toString();
        }
        return null;
    }, null);
    private int id;
    private int compId;
    private static final String LAUNCHER_ID = "LauncherId";
    private static final String LAUNCHER_SVC_ID = "LauncherSvcId";
    private static final String TWEAK_FOR_EXCLUDING_LICENSE = "     <Publish Dialog=\"WelcomeDlg\" Control=\"Next\"              Event=\"NewDialog\" Value=\"InstallDirDlg\" Order=\"2\"> 1     </Publish>\n     <Publish Dialog=\"InstallDirDlg\" Control=\"Back\"              Event=\"NewDialog\" Value=\"WelcomeDlg\" Order=\"2\"> 1     </Publish>\n";
    private static final String MSI_PROJECT_TEMPLATE = "template.wxs";
    private static final String MSI_PROJECT_CONTENT_FILE = "bundle.wxi";

    public WinMsiBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "msi";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(WinAppBundler.getAppBundleParameters());
        results.addAll(WinMsiBundler.getMsiBundleParameters());
        return results;
    }

    public static Collection<BundlerParamInfo<?>> getMsiBundleParameters() {
        return Arrays.asList(StandardBundlerParam.DESCRIPTION, WindowsBundlerParam.MENU_GROUP, WindowsBundlerParam.MENU_HINT, PRODUCT_VERSION, WindowsBundlerParam.SHORTCUT_HINT, WindowsBundlerParam.SYSTEM_WIDE, WindowsBundlerParam.VENDOR, WindowsBundlerParam.LICENSE_FILE, WindowsBundlerParam.INSTALLDIR_CHOOSER);
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.bundle(params, outputParentDir);
    }

    private static double findToolVersion(String toolName) {
        try {
            if (toolName == null || "".equals(toolName)) {
                return 0.0;
            }
            ProcessBuilder pb = new ProcessBuilder(toolName, "/?");
            VersionExtractor ve = new VersionExtractor();
            IOUtils.exec(pb, Log.isDebug(), true, ve);
            double version = ve.getVersion();
            Log.verbose(MessageFormat.format(I18N.getString("message.tool-version"), toolName, version));
            return version;
        }
        catch (Exception e) {
            if (Log.isDebug()) {
                Log.verbose(e);
            }
            return 0.0;
        }
    }

    @Override
    public boolean validate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        try {
            String version;
            if (p == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            APP_BUNDLER.fetchFrom(p).doValidate(p);
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(p)).booleanValue()) {
                SERVICE_BUNDLER.fetchFrom(p).validate(p);
            }
            double candleVersion = WinMsiBundler.findToolVersion(TOOL_CANDLE_EXECUTABLE.fetchFrom(p));
            double lightVersion = WinMsiBundler.findToolVersion(TOOL_LIGHT_EXECUTABLE.fetchFrom(p));
            double minVersion = 3.0;
            boolean bad = false;
            if (candleVersion < minVersion) {
                Log.verbose(MessageFormat.format(I18N.getString("message.wrong-tool-version"), TOOL_CANDLE, candleVersion, minVersion));
                bad = true;
            }
            if (lightVersion < minVersion) {
                Log.verbose(MessageFormat.format(I18N.getString("message.wrong-tool-version"), TOOL_LIGHT, lightVersion, minVersion));
                bad = true;
            }
            if (bad) {
                throw new ConfigException(I18N.getString("error.no-wix-tools"), I18N.getString("error.no-wix-tools.advice"));
            }
            if (lightVersion >= (double)3.6f) {
                Log.verbose(I18N.getString("message.use-wix36-features"));
                p.put(CAN_USE_WIX36.getID(), Boolean.TRUE);
            }
            if (!WinMsiBundler.isVersionStringValid(version = (String)PRODUCT_VERSION.fetchFrom(p))) {
                throw new ConfigException(MessageFormat.format(I18N.getString("error.version-string-wrong-format"), version), MessageFormat.format(I18N.getString("error.version-string-wrong-format.advice"), PRODUCT_VERSION.getID()));
            }
            List associations = (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(p);
            if (associations != null) {
                for (int i = 0; i < associations.size(); ++i) {
                    Map assoc = (Map)associations.get(i);
                    List mimes = (List)WindowsBundlerParam.FA_CONTENT_TYPE.fetchFrom(assoc);
                    if (mimes.size() <= 1) continue;
                    throw new ConfigException(MessageFormat.format(I18N.getString("error.too-many-content-types-for-file-association"), i), I18N.getString("error.too-many-content-types-for-file-association.advice"));
                }
            }
            if (p.containsKey(WindowsBundlerParam.LICENSE_FILE.getID())) {
                List appResourcesList = (List)WindowsBundlerParam.APP_RESOURCES_LIST.fetchFrom(p);
                for (String license : (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(p)) {
                    boolean found = false;
                    for (RelativeFileSet appResources : appResourcesList) {
                        found = found || appResources.contains(license);
                    }
                    if (found) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), license));
                }
            }
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    static boolean isVersionStringValid(String v) {
        if (v == null) {
            return true;
        }
        String[] p = v.split("\\.");
        if (p.length > 3) {
            Log.verbose(I18N.getString("message.version-string-too-many-components"));
            return false;
        }
        try {
            int val = Integer.parseInt(p[0]);
            if (val < 0 || val > 255) {
                Log.verbose(I18N.getString("error.version-string-major-out-of-range"));
                return false;
            }
            if (p.length > 1 && ((val = Integer.parseInt(p[1])) < 0 || val > 255)) {
                Log.verbose(I18N.getString("error.version-string-minor-out-of-range"));
                return false;
            }
            if (p.length > 2 && ((val = Integer.parseInt(p[2])) < 0 || val > 65535)) {
                Log.verbose(I18N.getString("error.version-string-build-out-of-range"));
                return false;
            }
        }
        catch (NumberFormatException ne) {
            Log.verbose(I18N.getString("error.version-string-part-not-number"));
            Log.verbose(ne);
            return false;
        }
        return true;
    }

    private boolean prepareProto(Map<String, ? super Object> p) throws IOException {
        List licenseFiles;
        File bundleRoot = MSI_IMAGE_DIR.fetchFrom(p);
        File appDir = APP_BUNDLER.fetchFrom(p).doBundle(p, bundleRoot, true);
        p.put(WIN_APP_IMAGE.getID(), appDir);
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(p)).booleanValue() && appDir != null) {
            appDir = SERVICE_BUNDLER.fetchFrom(p).doBundle(p, appDir, true);
        }
        if ((licenseFiles = (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(p)) != null) {
            block2: for (RelativeFileSet rfs : (List)WindowsBundlerParam.APP_RESOURCES_LIST.fetchFrom(p)) {
                for (String s : licenseFiles) {
                    if (!rfs.contains(s)) continue;
                    File lfile = new File(rfs.getBaseDirectory(), s);
                    File destFile = new File(appDir, lfile.getName());
                    IOUtils.copyFile(lfile, destFile);
                    WinMsiBundler.ensureByMutationFileIsRTF(destFile);
                    break block2;
                }
            }
        }
        List fileAssociations = (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(p);
        for (Map fileAssociation : fileAssociations) {
            File icon = (File)WindowsBundlerParam.FA_ICON.fetchFrom(fileAssociation);
            if (icon == null) continue;
            File faIconFile = new File(appDir, icon.getName());
            if (!icon.exists()) continue;
            try {
                IOUtils.copyFile(icon, faIconFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return appDir != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> p, File outdir) {
        File imageDir;
        block38: {
            File configScript;
            if (!outdir.isDirectory() && !outdir.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outdir.getAbsolutePath()));
            }
            if (!outdir.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outdir.getAbsolutePath()));
            }
            String light = TOOL_LIGHT_EXECUTABLE.fetchFrom(p);
            String candle = TOOL_CANDLE_EXECUTABLE.fetchFrom(p);
            if (light == null || !new File(light).isFile() || candle == null || !new File(candle).isFile()) {
                Log.info(I18N.getString("error.no-wix-tools"));
                Log.info(MessageFormat.format(I18N.getString("message.light-file-string"), light));
                Log.info(MessageFormat.format(I18N.getString("message.candle-file-string"), candle));
                return null;
            }
            imageDir = MSI_IMAGE_DIR.fetchFrom(p);
            imageDir.mkdirs();
            boolean menuShortcut = (Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(p);
            boolean desktopShortcut = (Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(p);
            if (!menuShortcut && !desktopShortcut) {
                Log.verbose(I18N.getString("message.one-shortcut-required"));
                p.put(WindowsBundlerParam.MENU_HINT.getID(), (Object)true);
            }
            if (!this.prepareProto(p) || !this.prepareWiXConfig(p) || !this.prepareBasicProjectConfig(p)) break block38;
            File configScriptSrc = this.getConfig_Script(p);
            if (configScriptSrc.exists()) {
                configScript = new File(imageDir, configScriptSrc.getName());
                IOUtils.copyFile(configScriptSrc, configScript);
                Log.info(MessageFormat.format(I18N.getString("message.running-wsh-script"), configScript.getAbsolutePath()));
                IOUtils.run("wscript", configScript, (Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(p));
            }
            configScript = this.buildMSI(p, outdir);
            try {
                if (imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(imageDir);
                } else if (imageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                }
                if (((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(p).getAbsolutePath()));
                } else {
                    this.cleanupConfigFiles(p);
                }
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            return configScript;
        }
        File configScriptSrc = null;
        try {
            if (imageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(imageDir);
            } else if (imageDir != null) {
                Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
            }
            if (((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(p).getAbsolutePath()));
            } else {
                this.cleanupConfigFiles(p);
            }
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        return configScriptSrc;
        catch (IOException ex) {
            File file;
            try {
                Log.verbose(ex);
                file = null;
            }
            catch (Throwable throwable) {
                try {
                    if (imageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(imageDir);
                    } else if (imageDir != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                    }
                    if (((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(p).getAbsolutePath()));
                    } else {
                        this.cleanupConfigFiles(p);
                    }
                }
                catch (FileNotFoundException ex2) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(imageDir);
                } else if (imageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                }
                if (((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(p).getAbsolutePath()));
                } else {
                    this.cleanupConfigFiles(p);
                }
            }
            catch (FileNotFoundException ex3) {
                return null;
            }
            return file;
        }
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> params) {
        if (this.getConfig_ProjectFile(params) != null) {
            this.getConfig_ProjectFile(params).delete();
        }
        if (this.getConfig_Script(params) != null) {
            this.getConfig_Script(params).delete();
        }
    }

    private File getConfig_Script(Map<String, ? super Object> params) {
        return new File(CONFIG_ROOT.fetchFrom(params), (String)WindowsBundlerParam.APP_FS_NAME.fetchFrom(params) + "-post-image.wsf");
    }

    private boolean prepareBasicProjectConfig(Map<String, ? super Object> params) throws IOException {
        this.fetchResource("package/windows/" + this.getConfig_Script(params).getName(), I18N.getString("resource.post-install-script"), (String)null, this.getConfig_Script(params), (boolean)((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(params)), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        return true;
    }

    private String relativePath(File basedir, File file) {
        return file.getAbsolutePath().substring(basedir.getAbsolutePath().length() + 1);
    }

    boolean prepareMainProjectFile(Map<String, ? super Object> params) throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        UUID productGUID = UUID.randomUUID();
        Log.verbose(MessageFormat.format(I18N.getString("message.generated-product-guid"), productGUID.toString()));
        data.put("PRODUCT_GUID", productGUID.toString());
        data.put("PRODUCT_UPGRADE_GUID", UPGRADE_UUID.fetchFrom(params).toString());
        data.put("APPLICATION_NAME", (String)WindowsBundlerParam.APP_NAME.fetchFrom(params));
        data.put("APPLICATION_DESCRIPTION", (String)StandardBundlerParam.DESCRIPTION.fetchFrom(params));
        data.put("APPLICATION_VENDOR", (String)WindowsBundlerParam.VENDOR.fetchFrom(params));
        data.put("APPLICATION_VERSION", (String)PRODUCT_VERSION.fetchFrom(params));
        File imageRootDir = WIN_APP_IMAGE.fetchFrom(params);
        File launcher = new File(imageRootDir, WinAppBundler.getLauncherName(params));
        String launcherPath = this.relativePath(imageRootDir, launcher);
        data.put("APPLICATION_LAUNCHER", launcherPath);
        String iconPath = launcherPath.replace(".exe", ".ico");
        data.put("APPLICATION_ICON", iconPath);
        data.put("REGISTRY_ROOT", this.getRegistryRoot(params));
        boolean canUseWix36Features = CAN_USE_WIX36.fetchFrom(params);
        data.put("WIX36_ONLY_START", canUseWix36Features ? "" : "<!--");
        data.put("WIX36_ONLY_END", canUseWix36Features ? "" : "-->");
        if (((Boolean)MSI_SYSTEM_WIDE.fetchFrom(params)).booleanValue()) {
            data.put("INSTALL_SCOPE", "perMachine");
        } else {
            data.put("INSTALL_SCOPE", "perUser");
        }
        if (((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params)).booleanValue()) {
            data.put("PLATFORM", "x64");
            data.put("WIN64", "yes");
        } else {
            data.put("PLATFORM", "x86");
            data.put("WIN64", "no");
        }
        data.put("UI_BLOCK", this.getUIBlock(params));
        data.put("APP_CDS_BLOCK", this.getAppCDSBlock(params));
        List secondaryLaunchers = (List)WindowsBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(params);
        StringBuilder secondaryLauncherIcons = new StringBuilder();
        for (int i = 0; i < secondaryLaunchers.size(); ++i) {
            Map sl = (Map)secondaryLaunchers.get(i);
            if (!((Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(sl)).booleanValue() && !((Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(sl)).booleanValue()) continue;
            File secondaryLauncher = new File(imageRootDir, WinAppBundler.getLauncherName(sl));
            String secondaryLauncherPath = this.relativePath(imageRootDir, secondaryLauncher);
            String secondaryLauncherIconPath = secondaryLauncherPath.replace(".exe", ".ico");
            secondaryLauncherIcons.append("        <Icon Id=\"Launcher");
            secondaryLauncherIcons.append(i);
            secondaryLauncherIcons.append(".exe\" SourceFile=\"");
            secondaryLauncherIcons.append(secondaryLauncherIconPath);
            secondaryLauncherIcons.append("\" />\r\n");
        }
        data.put("SECONDARY_LAUNCHER_ICONS", secondaryLauncherIcons.toString());
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_ProjectFile(params)));
        w.write(this.preprocessTextResource("package/windows/" + this.getConfig_ProjectFile(params).getName(), I18N.getString("resource.wix-config-file"), MSI_PROJECT_TEMPLATE, data, (Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(params), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params)));
        ((Writer)w).close();
        return true;
    }

    private String getUIBlock(Map<String, ? super Object> params) {
        String uiBlock = "     <UI/>\n";
        if (WindowsBundlerParam.INSTALLDIR_CHOOSER.fetchFrom(params).booleanValue()) {
            boolean enableTweakForExcludingLicense = this.getLicenseFile(params) == null;
            uiBlock = "     <UI>\n     <Property Id=\"WIXUI_INSTALLDIR\" Value=\"APPLICATIONFOLDER\" />\n     <UIRef Id=\"WixUI_InstallDir\" />\n" + (enableTweakForExcludingLicense ? TWEAK_FOR_EXCLUDING_LICENSE : "") + "     </UI>\n";
        } else if (this.getLicenseFile(params) != null) {
            uiBlock = "     <UI>\n     <UIRef Id=\"WixUI_Minimal\" />\n     </UI>\n";
        }
        return uiBlock;
    }

    private String getAppCDSBlock(Map<String, ? super Object> params) {
        String cdsBlock = "";
        if (((Boolean)WindowsBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(params)).booleanValue() && ((Boolean)WindowsBundlerParam.ENABLE_APP_CDS.fetchFrom(params)).booleanValue() && ("install".equals(WindowsBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params)) || "auto+install".equals(WindowsBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params)))) {
            cdsBlock = "     <CustomAction Id=\"CACHE_CDS\"\n          Directory=\"APPLICATIONFOLDER\"\n          ExeCommand=\"[APPLICATIONFOLDER]" + WinAppBundler.getLauncherName(params) + " -Xappcds:generatecache\"\n          Execute=\"commit\"\n          Return=\"check\"/>\n\n     <InstallExecuteSequence>\n         <Custom Action=\"CACHE_CDS\" Before=\"InstallFinalize\" />\n     </InstallExecuteSequence>";
        }
        return cdsBlock;
    }

    private void walkFileTree(Map<String, ? super Object> params, File root, PrintStream out, String prefix) {
        boolean isLauncherSvc;
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        if (!root.isDirectory()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-walk-directory"), root.getAbsolutePath()));
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File f : children) {
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                files.add(f);
            }
        }
        out.println(prefix + " <Component Id=\"comp" + this.compId++ + "\" DiskId=\"1\" Guid=\"" + UUID.randomUUID().toString() + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params) != false ? " Win64=\"yes\"" : "") + ">");
        out.println(prefix + "  <CreateFolder/>");
        out.println(prefix + "  <RemoveFolder Id=\"RemoveDir" + this.id++ + "\" On=\"uninstall\" />");
        boolean needRegistryKey = (Boolean)MSI_SYSTEM_WIDE.fetchFrom(params) == false;
        File imageRootDir = WIN_APP_IMAGE.fetchFrom(params);
        File launcherFile = new File(imageRootDir, WinAppBundler.getLauncherName(params));
        File launcherSvcFile = WinServiceBundler.getLauncherSvc(imageRootDir, params);
        for (File f : files) {
            boolean isLauncher = f.equals(launcherFile);
            if (!isLauncher) continue;
            needRegistryKey = true;
        }
        if (needRegistryKey) {
            out.println(prefix + "    <RegistryKey Root=\"HKCU\"  Key=\"Software\\" + (String)WindowsBundlerParam.VENDOR.fetchFrom(params) + "\\" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "\"" + (CAN_USE_WIX36.fetchFrom(params) != false ? ">" : " Action=\"createAndRemoveOnUninstall\">"));
            out.println(prefix + "     <RegistryValue Name=\"Version\" Value=\"" + (String)WindowsBundlerParam.VERSION.fetchFrom(params) + "\" Type=\"string\" KeyPath=\"yes\"/>");
            out.println(prefix + "   </RegistryKey>");
        }
        boolean menuShortcut = (Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(params);
        boolean desktopShortcut = (Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(params);
        TreeMap<String, String> idToFileMap = new TreeMap<String, String>();
        boolean launcherSet = false;
        for (File f : files) {
            boolean isLauncher = f.equals(launcherFile);
            isLauncherSvc = f.equals(launcherSvcFile);
            if (isLauncherSvc) continue;
            launcherSet = launcherSet || isLauncher;
            boolean doShortcuts = isLauncher && (menuShortcut || desktopShortcut);
            String thisFileId = isLauncher ? LAUNCHER_ID : "FileId" + this.id++;
            idToFileMap.put(f.getName(), thisFileId);
            out.println(prefix + "   <File Id=\"" + thisFileId + "\" Name=\"" + f.getName() + "\"  Source=\"" + this.relativePath(imageRootDir, f) + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params) != false ? " ProcessorArchitecture=\"x64\"" : "") + ">");
            if (doShortcuts && desktopShortcut) {
                out.println(prefix + "  <Shortcut Id=\"desktopShortcut\" Directory=\"DesktopFolder\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "\" WorkingDirectory=\"INSTALLDIR\" Advertise=\"no\" Icon=\"DesktopIcon.exe\" IconIndex=\"0\" />");
            }
            if (doShortcuts && menuShortcut) {
                out.println(prefix + "     <Shortcut Id=\"ExeShortcut\" Directory=\"ProgramMenuDir\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "\" Advertise=\"no\" Icon=\"StartMenuIcon.exe\" IconIndex=\"0\" />");
            }
            List secondaryLaunchers = (List)WindowsBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(params);
            for (int i = 0; i < secondaryLaunchers.size(); ++i) {
                Map sl = (Map)secondaryLaunchers.get(i);
                File secondaryLauncherFile = new File(imageRootDir, WinAppBundler.getLauncherName(sl));
                if (!f.equals(secondaryLauncherFile)) continue;
                if (((Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(sl)).booleanValue()) {
                    out.println(prefix + "  <Shortcut Id=\"desktopShortcut" + i + "\" Directory=\"DesktopFolder\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(sl) + "\" WorkingDirectory=\"INSTALLDIR\" Advertise=\"no\" Icon=\"Launcher" + i + ".exe\" IconIndex=\"0\" />");
                }
                if (!((Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(sl)).booleanValue()) continue;
                out.println(prefix + "     <Shortcut Id=\"ExeShortcut" + i + "\" Directory=\"ProgramMenuDir\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(sl) + "\" Advertise=\"no\" Icon=\"Launcher" + i + ".exe\" IconIndex=\"0\" />");
            }
            out.println(prefix + "   </File>");
        }
        if (launcherSet) {
            List fileAssociations = (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(params);
            String regName = WindowsBundlerParam.APP_REGISTRY_NAME.fetchFrom(params);
            TreeSet<String> defaultedMimes = new TreeSet<String>();
            int count = 0;
            for (Map fileAssociation : fileAssociations) {
                String mime;
                String description = (String)WindowsBundlerParam.FA_DESCRIPTION.fetchFrom(fileAssociation);
                List extensions = (List)WindowsBundlerParam.FA_EXTENSIONS.fetchFrom(fileAssociation);
                List mimeTypes = (List)WindowsBundlerParam.FA_CONTENT_TYPE.fetchFrom(fileAssociation);
                File icon = (File)WindowsBundlerParam.FA_ICON.fetchFrom(fileAssociation);
                String string = mime = mimeTypes == null || mimeTypes.isEmpty() ? null : (String)mimeTypes.get(0);
                if (extensions == null) {
                    Log.info(I18N.getString("message.creating-association-with-null-extension"));
                    String entryName = regName + "File";
                    if (count > 0) {
                        entryName = entryName + "." + count;
                    }
                    ++count;
                    out.print(prefix + "   <ProgId Id='" + entryName + "' Description='" + description + "'");
                    if (icon != null && icon.exists()) {
                        out.print(" Icon='" + (String)idToFileMap.get(icon.getName()) + "' IconIndex='0'");
                    }
                    out.println(" />");
                    continue;
                }
                for (String ext : extensions) {
                    String entryName = regName + "File";
                    if (count > 0) {
                        entryName = entryName + "." + count;
                    }
                    ++count;
                    out.print(prefix + "   <ProgId Id='" + entryName + "' Description='" + description + "'");
                    if (icon != null && icon.exists()) {
                        out.print(" Icon='" + (String)idToFileMap.get(icon.getName()) + "' IconIndex='0'");
                    }
                    out.println(">");
                    if (extensions == null) {
                        Log.info(I18N.getString("message.creating-association-with-null-extension"));
                    } else {
                        out.print(prefix + "    <Extension Id='" + ext + "' Advertise='no'");
                        if (mime == null) {
                            out.println(">");
                        } else {
                            out.println(" ContentType='" + mime + "'>");
                            if (!defaultedMimes.contains(mime)) {
                                out.println(prefix + "      <MIME ContentType='" + mime + "' Default='yes' />");
                                defaultedMimes.add(mime);
                            }
                        }
                        out.println(prefix + "      <Verb Id='open' Command='Open' TargetFile='" + LAUNCHER_ID + "' Argument='\"%1\"' />");
                        out.println(prefix + "    </Extension>");
                    }
                    out.println(prefix + "   </ProgId>");
                }
            }
        }
        out.println(prefix + " </Component>");
        boolean needServiceEntries = false;
        for (File f : files) {
            isLauncherSvc = f.equals(launcherSvcFile);
            if (!isLauncherSvc || !((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) continue;
            needServiceEntries = true;
        }
        if (needServiceEntries) {
            out.println(prefix + " <Component Id=\"comp" + this.compId++ + "\" DiskId=\"1\" Guid=\"" + UUID.randomUUID().toString() + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params) != false ? " Win64=\"yes\"" : "") + ">");
            out.println("  <CreateFolder/>");
            out.println("  <RemoveFolder Id=\"RemoveDir" + this.id++ + "\" On=\"uninstall\" />");
            out.println(prefix + "   <File Id=\"" + LAUNCHER_SVC_ID + "\" Name=\"" + launcherSvcFile.getName() + "\"  Source=\"" + this.relativePath(imageRootDir, launcherSvcFile) + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params) != false ? " ProcessorArchitecture=\"x64\"" : "") + " KeyPath=\"yes\">");
            out.println(prefix + "   </File>");
            out.println(prefix + "   <ServiceInstall Id=\"" + (String)WindowsBundlerParam.APP_FS_NAME.fetchFrom(params) + "\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "\" Description=\"" + (String)StandardBundlerParam.DESCRIPTION.fetchFrom(params) + "\" ErrorControl=\"normal\" Start=\"" + ((Boolean)StandardBundlerParam.RUN_AT_STARTUP.fetchFrom(params) != false ? "auto" : "demand") + "\" Type=\"ownProcess\" Vital=\"yes\" Account=\"LocalSystem\" Arguments='-mainExe \"" + launcherFile.getName() + "\"'/>");
            out.println(prefix + "   <ServiceControl Id=\"" + (String)WindowsBundlerParam.APP_FS_NAME.fetchFrom(params) + "\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "\"" + ((Boolean)StandardBundlerParam.START_ON_INSTALL.fetchFrom(params) != false ? " Start=\"install\"" : "") + ((Boolean)StandardBundlerParam.STOP_ON_UNINSTALL.fetchFrom(params) != false ? " Stop=\"uninstall\"" : "") + " Remove=\"uninstall\" Wait=\"yes\" />");
            out.println(prefix + " </Component>");
        }
        for (File d : dirs) {
            out.println(prefix + " <Directory Id=\"dirid" + this.id++ + "\" Name=\"" + d.getName() + "\">");
            this.walkFileTree(params, d, out, prefix + " ");
            out.println(prefix + " </Directory>");
        }
    }

    String getRegistryRoot(Map<String, ? super Object> params) {
        if (((Boolean)MSI_SYSTEM_WIDE.fetchFrom(params)).booleanValue()) {
            return "HKLM";
        }
        return "HKCU";
    }

    boolean prepareContentList(Map<String, ? super Object> params) throws FileNotFoundException {
        File f = new File(CONFIG_ROOT.fetchFrom(params), MSI_PROJECT_CONTENT_FILE);
        PrintStream out = new PrintStream(f);
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        out.println("<Include>");
        out.println(" <Directory Id=\"TARGETDIR\" Name=\"SourceDir\">");
        if (((Boolean)MSI_SYSTEM_WIDE.fetchFrom(params)).booleanValue()) {
            if (((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params)).booleanValue()) {
                out.println("  <Directory Id=\"ProgramFiles64Folder\" Name=\"PFiles\">");
            } else {
                out.println("  <Directory Id=\"ProgramFilesFolder\" Name=\"PFiles\">");
            }
        } else {
            out.println("  <Directory Name=\"AppData\" Id=\"LocalAppDataFolder\">");
        }
        out.println("   <Directory Id=\"APPLICATIONFOLDER\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "\">");
        this.id = 0;
        this.compId = 0;
        this.walkFileTree(params, WIN_APP_IMAGE.fetchFrom(params), out, "    ");
        out.println("   </Directory>");
        out.println("  </Directory>");
        if (((Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(params)).booleanValue()) {
            out.println("  <Directory Id=\"DesktopFolder\" />");
        }
        if (((Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(params)).booleanValue()) {
            out.println("  <Directory Id=\"ProgramMenuFolder\">");
            out.println("    <Directory Id=\"ProgramMenuDir\" Name=\"" + (String)WindowsBundlerParam.MENU_GROUP.fetchFrom(params) + "\">");
            out.println("      <Component Id=\"comp" + this.compId++ + "\" Guid=\"" + UUID.randomUUID().toString() + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params) != false ? " Win64=\"yes\"" : "") + ">");
            out.println("        <RemoveFolder Id=\"ProgramMenuDir\" On=\"uninstall\" />");
            out.println("         <RegistryValue Root=\"HKCU\" Key=\"Software\\" + (String)WindowsBundlerParam.VENDOR.fetchFrom(params) + "\\" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "\" Type=\"string\" Value=\"\" />");
            out.println("      </Component>");
            out.println("    </Directory>");
            out.println(" </Directory>");
        }
        out.println(" </Directory>");
        out.println(" <Feature Id=\"DefaultFeature\" Title=\"Main Feature\" Level=\"1\">");
        for (int j = 0; j < this.compId; ++j) {
            out.println("    <ComponentRef Id=\"comp" + j + "\" />");
        }
        out.println("    <ComponentRef Id=\"CleanupMainApplicationFolder\" />");
        out.println(" </Feature>");
        out.println("</Include>");
        out.close();
        return true;
    }

    private File getConfig_ProjectFile(Map<String, ? super Object> params) {
        return new File(CONFIG_ROOT.fetchFrom(params), (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + ".wxs");
    }

    private String getLicenseFile(Map<String, ? super Object> params) {
        List licenseFiles = (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(params);
        if (licenseFiles == null || licenseFiles.isEmpty()) {
            return null;
        }
        return (String)licenseFiles.get(0);
    }

    private boolean prepareWiXConfig(Map<String, ? super Object> params) throws IOException {
        return this.prepareMainProjectFile(params) && this.prepareContentList(params);
    }

    private File buildMSI(Map<String, ? super Object> params, File outdir) throws IOException {
        File tmpDir = new File((File)WindowsBundlerParam.BUILD_ROOT.fetchFrom(params), "tmp");
        File candleOut = new File(tmpDir, (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + ".wixobj");
        File msiOut = new File(outdir, WindowsBundlerParam.INSTALLER_FILE_NAME.fetchFrom(params) + ".msi");
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-msi-config"), msiOut.getAbsolutePath()));
        msiOut.getParentFile().mkdirs();
        ProcessBuilder pb = new ProcessBuilder(TOOL_CANDLE_EXECUTABLE.fetchFrom(params), "-nologo", this.getConfig_ProjectFile(params).getAbsolutePath(), "-ext", "WixUtilExtension", "-out", candleOut.getAbsolutePath());
        pb = pb.directory(WIN_APP_IMAGE.fetchFrom(params));
        IOUtils.exec(pb, (Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(params));
        Log.verbose(MessageFormat.format(I18N.getString("message.generating-msi"), msiOut.getAbsolutePath()));
        boolean enableLicenseUI = this.getLicenseFile(params) != null;
        boolean enableInstalldirUI = WindowsBundlerParam.INSTALLDIR_CHOOSER.fetchFrom(params);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(TOOL_LIGHT_EXECUTABLE.fetchFrom(params));
        if (enableLicenseUI) {
            commandLine.add("-dWixUILicenseRtf=" + this.getLicenseFile(params));
        }
        commandLine.add("-nologo");
        commandLine.add("-spdb");
        commandLine.add("-sice:60");
        commandLine.add(candleOut.getAbsolutePath());
        commandLine.add("-ext");
        commandLine.add("WixUtilExtension");
        if (enableLicenseUI || enableInstalldirUI) {
            commandLine.add("-ext");
            commandLine.add("WixUIExtension.dll");
        }
        commandLine.add("-out");
        commandLine.add(msiOut.getAbsolutePath());
        pb = new ProcessBuilder(commandLine);
        pb = pb.directory(WIN_APP_IMAGE.fetchFrom(params));
        IOUtils.exec(pb, (Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(params));
        candleOut.delete();
        IOUtils.deleteRecursive(tmpDir);
        return msiOut;
    }

    public static void ensureByMutationFileIsRTF(File f) {
        block29: {
            if (f == null || !f.isFile()) {
                return;
            }
            try {
                boolean existingLicenseIsRTF = false;
                try (FileInputStream fin = new FileInputStream(f);){
                    byte[] firstBits = new byte[7];
                    if (fin.read(firstBits) == firstBits.length) {
                        String header = new String(firstBits);
                        existingLicenseIsRTF = "{\\rtf1\\".equals(header);
                    }
                }
                if (existingLicenseIsRTF) break block29;
                List<String> oldLicense = Files.readAllLines(f.toPath());
                try (BufferedWriter w = Files.newBufferedWriter(f.toPath(), Charset.forName("Windows-1252"), new OpenOption[0]);){
                    w.write("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1033{\\fonttbl{\\f0\\fnil\\fcharset0 Arial;}}\n\\viewkind4\\uc1\\pard\\sa200\\sl276\\slmult1\\lang9\\fs20 ");
                    oldLicense.forEach(l -> {
                        try {
                            for (char c : l.toCharArray()) {
                                if (c < '\u0010') {
                                    w.write("\\'0");
                                    w.write(Integer.toHexString(c));
                                    continue;
                                }
                                if (c > '\u00ff') {
                                    w.write("\\ud");
                                    w.write(Integer.toString(c));
                                    w.write("?");
                                    continue;
                                }
                                if (c < ' ' || c >= '\u0080' || c == '\\' || c == '{' || c == '}') {
                                    w.write("\\'");
                                    w.write(Integer.toHexString(c));
                                    continue;
                                }
                                w.write(c);
                            }
                            if (l.length() < 1) {
                                w.write("\\par");
                            } else {
                                w.write(" ");
                            }
                            w.write("\r\n");
                        }
                        catch (IOException e) {
                            Log.verbose(e);
                        }
                    });
                    w.write("}\r\n");
                }
            }
            catch (IOException e) {
                Log.verbose(e);
            }
        }
    }

    static class VersionExtractor
    extends PrintStream {
        double version = 0.0;

        public VersionExtractor() {
            super(new ByteArrayOutputStream());
        }

        double getVersion() {
            if (this.version == 0.0) {
                String content = new String(((ByteArrayOutputStream)this.out).toByteArray());
                Pattern pattern = Pattern.compile("version (\\d+.\\d+)");
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    String v = matcher.group(1);
                    this.version = new Double(v);
                }
            }
            return this.version;
        }
    }
}

