/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.AbstractImageBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.windows.WinResources;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class WinAppBundler
extends AbstractImageBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(WinAppBundler.class.getName());
    public static final BundlerParamInfo<File> CONFIG_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, params -> {
        File imagesRoot = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)params), "windows");
        imagesRoot.mkdirs();
        return imagesRoot;
    }, (s, p) -> null);
    private static final String EXECUTABLE_NAME = "WinLauncher.exe";
    private static final String LIBRARY_NAME = "packager.dll";
    private static final String[] VS_VERS = new String[]{"100", "110", "120", "140"};
    private static final String REDIST_MSVCR = "vcruntimeVS_VER.dll";
    private static final String REDIST_MSVCP = "msvcpVS_VER.dll";
    private static final String TOOL_ICON_SWAP = "IconSwap.exe";
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL = new WindowsBundlerParam<URL>(I18N.getString("param.raw-executable-url.name"), I18N.getString("param.raw-executable-url.description"), "win.launcher.url", URL.class, params -> WinResources.class.getResource(EXECUTABLE_NAME), (s, p) -> {
        try {
            return new URL((String)s);
        }
        catch (MalformedURLException e) {
            Log.info(e.toString());
            return null;
        }
    });
    public static final BundlerParamInfo<Boolean> REBRAND_EXECUTABLE = new WindowsBundlerParam<Boolean>(I18N.getString("param.rebrand-executable.name"), I18N.getString("param.rebrand-executable.description"), "win.launcher.rebrand", Boolean.class, params -> Boolean.TRUE, (s, p) -> Boolean.valueOf(s));
    public static final BundlerParamInfo<File> ICON_ICO = new StandardBundlerParam<File>(I18N.getString("param.icon-ico.name"), I18N.getString("param.icon-ico.description"), "icon.ico", File.class, params -> {
        File f = (File)StandardBundlerParam.ICON.fetchFrom((Map<String, Object>)params);
        if (f != null && !f.getName().toLowerCase().endsWith(".ico")) {
            Log.info(MessageFormat.format(I18N.getString("message.icon-not-ico"), f));
            return null;
        }
        return f;
    }, (s, p) -> new File((String)s));
    public static final String WIN_BUNDLER_PREFIX = "package/windows/";
    private static final String TEMPLATE_APP_ICON = "javalogo_white_48.ico";

    public WinAppBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    File getConfigRoot(Map<String, ? super Object> params) {
        return CONFIG_ROOT.fetchFrom(params);
    }

    @Override
    public boolean validate(Map<String, ? super Object> params) throws UnsupportedPlatformException, ConfigException {
        try {
            if (params == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            return this.doValidate(params);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    boolean doValidate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new UnsupportedPlatformException();
        }
        this.imageBundleValidation(p);
        if (WinResources.class.getResource(TOOL_ICON_SWAP) == null) {
            throw new ConfigException(I18N.getString("error.no-windows-resources"), I18N.getString("error.no-windows-resources.advice"));
        }
        this.testRuntime(WindowsBundlerParam.WIN_RUNTIME.fetchFrom(p), new String[]{"bin\\\\[^\\\\]+\\\\jvm.dll", "lib\\\\rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(p)).booleanValue()) {
            this.testRuntime(WindowsBundlerParam.WIN_RUNTIME.fetchFrom(p), new String[]{"lib\\\\ext\\\\jfxrt.jar", "lib\\\\jfxrt.jar"});
        }
        WinAppBundler.testRuntimeBitArchitecture(p);
        return true;
    }

    private static void testRuntimeBitArchitecture(Map<String, ? super Object> params) throws ConfigException {
        if ("true".equalsIgnoreCase(System.getProperty("fxpackager.disableBitArchitectureMismatchCheck"))) {
            Log.debug(I18N.getString("message.disable-bit-architecture-check"));
            return;
        }
        if (WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params) != WindowsBundlerParam.BIT_ARCH_64_RUNTIME.fetchFrom(params) && !"systemjre".equals(params.get(".runtime.autodetect"))) {
            throw new ConfigException(I18N.getString("error.bit-architecture-mismatch"), I18N.getString("error.bit-architecture-mismatch.advice"));
        }
    }

    private static File getRootDir(File outDir, Map<String, ? super Object> p) {
        return new File(outDir, (String)StandardBundlerParam.APP_NAME.fetchFrom(p));
    }

    public static String getLauncherName(Map<String, ? super Object> p) {
        return (String)StandardBundlerParam.APP_NAME.fetchFrom(p) + ".exe";
    }

    public static String getLauncherCfgName(Map<String, ? super Object> p) {
        return "app\\" + (String)StandardBundlerParam.APP_NAME.fetchFrom(p) + ".cfg";
    }

    private File getConfig_AppIcon(Map<String, ? super Object> params) {
        return new File(this.getConfigRoot(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".ico");
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> params) {
        this.getConfig_AppIcon(params).delete();
    }

    private void prepareConfigFiles(Map<String, ? super Object> params) throws IOException {
        File iconTarget = this.getConfig_AppIcon(params);
        File icon = ICON_ICO.fetchFrom(params);
        if (icon != null && icon.exists()) {
            this.fetchResource(WIN_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.application-icon"), icon, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        } else {
            this.fetchResource(WIN_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.application-icon"), TEMPLATE_APP_ICON, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        }
    }

    public boolean bundle(Map<String, ? super Object> p, File outputDirectory) {
        return this.doBundle(p, outputDirectory, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File doBundle(Map<String, ? super Object> p, File outputDirectory, boolean dependentTask) {
        File file;
        block13: {
            block11: {
                HashMap<String, ? super Object> originalParams = new HashMap<String, Object>(p);
                if (!outputDirectory.isDirectory() && !outputDirectory.mkdirs()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outputDirectory.getAbsolutePath()));
                }
                if (!outputDirectory.canWrite()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outputDirectory.getAbsolutePath()));
                }
                try {
                    if (!dependentTask) {
                        Log.info(MessageFormat.format(I18N.getString("message.creating-app-bundle"), StandardBundlerParam.APP_NAME.fetchFrom(p), outputDirectory.getAbsolutePath()));
                    }
                    File rootDirectory = WinAppBundler.getRootDir(outputDirectory, p);
                    IOUtils.deleteRecursive(rootDirectory);
                    rootDirectory.mkdirs();
                    File appDirectory = new File(rootDirectory, "app");
                    appDirectory.mkdirs();
                    this.createLauncherForEntryPoint(p, rootDirectory);
                    this.copyApplication(p, appDirectory);
                    File runtimeDirectory = new File(rootDirectory, "runtime");
                    this.copyRuntime(p, runtimeDirectory);
                    IOUtils.copyFromURL(WinResources.class.getResource(LIBRARY_NAME), new File(rootDirectory, LIBRARY_NAME));
                    this.copyMSVCDLLs(rootDirectory, runtimeDirectory);
                    List entryPoints = (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(p);
                    for (Map entryPoint : entryPoints) {
                        HashMap<String, ? super Object> tmp = new HashMap<String, Object>(originalParams);
                        tmp.putAll(entryPoint);
                        this.createLauncherForEntryPoint(tmp, rootDirectory);
                    }
                    if (!dependentTask) {
                        Log.info(MessageFormat.format(I18N.getString("message.result-dir"), outputDirectory.getAbsolutePath()));
                    }
                    file = rootDirectory;
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) break block11;
                }
                catch (IOException ex) {
                    File file2;
                    block14: {
                        block12: {
                            try {
                                Log.info("Exception: " + ex);
                                Log.debug(ex);
                                file2 = null;
                                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) break block12;
                            }
                            catch (Throwable throwable) {
                                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(p).getAbsolutePath()));
                                } else {
                                    this.cleanupConfigFiles(p);
                                }
                                throw throwable;
                            }
                            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(p).getAbsolutePath()));
                            break block14;
                        }
                        this.cleanupConfigFiles(p);
                    }
                    return file2;
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(p).getAbsolutePath()));
                break block13;
            }
            this.cleanupConfigFiles(p);
        }
        return file;
    }

    private void copyMSVCDLLs(File rootDirectory, File jreDir) throws IOException {
        String vsVer = null;
        if (jreDir == null || !jreDir.isDirectory()) {
            jreDir = new File(System.getProperty("java.home"));
        }
        for (String thisVer : VS_VERS) {
            if (!this.copyMSVCDLLs(rootDirectory, thisVer)) continue;
            vsVer = thisVer;
            break;
        }
        if (vsVer == null) {
            throw new RuntimeException("Not found MSVC dlls");
        }
        AtomicReference ioe = new AtomicReference();
        String finalVsVer = vsVer;
        Files.list(jreDir.toPath().resolve("bin")).filter(p -> Pattern.matches("^(vcruntime|msvcp|msvcr|ucrtbase|api-ms-win-).*\\.dll$", p.toFile().getName().toLowerCase())).filter(p -> !p.toString().toLowerCase().endsWith(finalVsVer + ".dll")).forEach(p -> {
            try {
                IOUtils.copyFile(p.toFile(), new File(rootDirectory, p.toFile().getName()));
            }
            catch (IOException e) {
                ioe.set(e);
            }
        });
        IOException e = (IOException)ioe.get();
        if (e != null) {
            throw e;
        }
    }

    private boolean copyMSVCDLLs(File rootDirectory, String VS_VER) throws IOException {
        URL REDIST_MSVCR_URL = WinResources.class.getResource(REDIST_MSVCR.replaceAll("VS_VER", VS_VER));
        URL REDIST_MSVCP_URL = WinResources.class.getResource(REDIST_MSVCP.replaceAll("VS_VER", VS_VER));
        if (REDIST_MSVCR_URL != null && REDIST_MSVCP_URL != null) {
            IOUtils.copyFromURL(REDIST_MSVCR_URL, new File(rootDirectory, REDIST_MSVCR.replaceAll("VS_VER", VS_VER)));
            IOUtils.copyFromURL(REDIST_MSVCP_URL, new File(rootDirectory, REDIST_MSVCP.replaceAll("VS_VER", VS_VER)));
            return true;
        }
        return false;
    }

    private void createLauncherForEntryPoint(Map<String, ? super Object> p, File rootDirectory) throws IOException {
        this.prepareConfigFiles(p);
        if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(p)).equals("prop")) {
            this.writeCfgFile(p, rootDirectory);
        } else {
            this.writeCfgFile(p, new File(rootDirectory, WinAppBundler.getLauncherCfgName(p)), this.getRuntimeLocation(p));
        }
        File executableFile = new File(rootDirectory, WinAppBundler.getLauncherName(p));
        IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(p), executableFile);
        executableFile.setExecutable(true, false);
        if (REBRAND_EXECUTABLE.fetchFrom(p).booleanValue() && this.getConfig_AppIcon(p).exists()) {
            File iconSwapTool = File.createTempFile("iconswap", ".exe");
            iconSwapTool.delete();
            IOUtils.copyFromURL(WinResources.class.getResource(TOOL_ICON_SWAP), iconSwapTool);
            iconSwapTool.setExecutable(true, false);
            iconSwapTool.deleteOnExit();
            executableFile.setWritable(true);
            ProcessBuilder pb = new ProcessBuilder(iconSwapTool.getAbsolutePath(), this.getConfig_AppIcon(p).getAbsolutePath(), executableFile.getAbsolutePath());
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
            executableFile.setReadOnly();
            iconSwapTool.delete();
        }
        IOUtils.copyFile(this.getConfig_AppIcon(p), new File(rootDirectory, (String)StandardBundlerParam.APP_NAME.fetchFrom(p) + ".ico"));
    }

    private void copyApplication(Map<String, ? super Object> params, File appDirectory) throws IOException {
        List appResourcesList = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params);
        if (appResourcesList == null) {
            throw new RuntimeException("Null app resources?");
        }
        for (RelativeFileSet appResources : appResourcesList) {
            if (appResources == null) {
                throw new RuntimeException("Null app resources?");
            }
            File srcdir = appResources.getBaseDirectory();
            for (String fname : appResources.getIncludedFiles()) {
                IOUtils.copyFile(new File(srcdir, fname), new File(appDirectory, fname));
            }
        }
    }

    private String getRuntimeLocation(Map<String, ? super Object> params) {
        if (WindowsBundlerParam.WIN_RUNTIME.fetchFrom(params) == null) {
            return "";
        }
        return "$APPDIR\\runtime";
    }

    private void writeCfgFile(Map<String, ? super Object> params, File rootDir) throws FileNotFoundException {
        File cfgFile = new File(rootDir, WinAppBundler.getLauncherCfgName(params));
        cfgFile.delete();
        PrintStream out = new PrintStream(cfgFile);
        out.println("app.runtime=" + this.getRuntimeLocation(params));
        out.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(params)).getIncludedFiles().iterator().next());
        out.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(params));
        out.println("app.id=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params));
        out.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(params));
        out.println("app.identifier=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params));
        out.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params)).replaceAll("\\.", "/"));
        out.println("app.classpath=" + (String)StandardBundlerParam.CLASSPATH.fetchFrom(params));
        List jvmargs = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(params);
        int idx = 1;
        for (Object a : jvmargs) {
            out.println("jvmarg." + idx + "=" + (String)a);
            ++idx;
        }
        Map jvmProps = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(params);
        for (Map.Entry entry : jvmProps.entrySet()) {
            out.println("jvmarg." + idx + "=-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            ++idx;
        }
        String preloader = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(params);
        if (preloader != null) {
            out.println("jvmarg." + idx + "=-Djavafx.preloader=" + preloader);
        }
        Map map = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(params);
        idx = 1;
        for (Map.Entry arg : map.entrySet()) {
            if (arg.getKey() == null || arg.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
            } else {
                out.println("jvmuserarg." + idx + ".name=" + (String)arg.getKey());
                out.println("jvmuserarg." + idx + ".value=" + (String)arg.getValue());
            }
            ++idx;
        }
        List args = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(params);
        idx = 1;
        for (String a : args) {
            out.println("arg." + idx + "=" + a);
            ++idx;
        }
        out.close();
    }

    private void copyRuntime(Map<String, ? super Object> params, File runtimeDirectory) throws IOException {
        RelativeFileSet runtime = WindowsBundlerParam.WIN_RUNTIME.fetchFrom(params);
        if (runtime == null) {
            return;
        }
        runtimeDirectory.mkdirs();
        File srcdir = runtime.getBaseDirectory();
        Set<String> filesToCopy = runtime.getIncludedFiles();
        for (String fname : filesToCopy) {
            IOUtils.copyFile(new File(srcdir, fname), new File(runtimeDirectory, fname));
        }
    }

    @Override
    public void extractRuntimeFlags(Map<String, ? super Object> params) {
        WinAppBundler.extractFlagsFromRuntime(params);
    }

    public static void extractFlagsFromRuntime(Map<String, ? super Object> params) {
        if (params.containsKey(".runtime.autodetect")) {
            return;
        }
        params.put(".runtime.autodetect", "attempted");
        RelativeFileSet runtime = WindowsBundlerParam.WIN_RUNTIME.fetchFrom(params);
        if (runtime == null) {
            params.put(".runtime.autodetect", "systemjre");
        } else {
            String commandline;
            File runtimePath = runtime.getBaseDirectory();
            File launcherPath = new File(runtimePath, "bin\\java");
            ProcessBuilder pb = new ProcessBuilder(launcherPath.getAbsolutePath(), "-version");
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                try (PrintStream pout = new PrintStream(baos);){
                    IOUtils.exec(pb, Log.isDebug(), true, pout);
                }
                commandline = baos.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                params.put(".runtime.autodetect", "failed");
                return;
            }
            AbstractImageBundler.extractFlagsFromVersion(params, commandline);
            params.put(".runtime.autodetect", "succeeded");
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "windows.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return WinAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, StandardBundlerParam.ARGUMENTS, StandardBundlerParam.CLASSPATH, ICON_ICO, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.PRELOADER_CLASS, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION, WindowsBundlerParam.WIN_RUNTIME);
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.doBundle(params, outputParentDir, false);
    }

    @Override
    protected String getCacheLocation(Map<String, ? super Object> params) {
        return "$CACHEDIR/";
    }
}

