/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.linux;

import com.oracle.tools.packager.AbstractImageBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.linux.LinuxResources;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class LinuxAppBundler
extends AbstractImageBundler {
    private static final ResourceBundle I18N;
    protected static final String LINUX_BUNDLER_PREFIX;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String LIBRARY_NAME = "libpackager.so";
    public static final BundlerParamInfo<File> ICON_PNG;
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL;
    public static final BundlerParamInfo<JreUtils.Rule[]> LINUX_JRE_RULES;
    public static final BundlerParamInfo<RelativeFileSet> LINUX_RUNTIME;

    @Override
    public boolean validate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        try {
            if (p == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            return this.doValidate(p);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    boolean doValidate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            throw new UnsupportedPlatformException();
        }
        this.imageBundleValidation(p);
        if (RAW_EXECUTABLE_URL.fetchFrom(p) == null) {
            throw new ConfigException(I18N.getString("error.no-linux-resources"), I18N.getString("error.no-linux-resources.advice"));
        }
        this.testRuntime(LINUX_RUNTIME.fetchFrom(p), new String[]{"lib/[^/]+/[^/]+/libjvm.so", "lib/rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(p)).booleanValue()) {
            this.testRuntime(LINUX_RUNTIME.fetchFrom(p), new String[]{"lib/ext/jfxrt.jar", "lib/jfxrt.jar"});
        }
        return true;
    }

    public static File getRootDir(File outDir, Map<String, ? super Object> p) {
        return new File(outDir, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(p));
    }

    public static String getLauncherName(Map<String, ? super Object> p) {
        return (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(p);
    }

    public static String getLauncherCfgName(Map<String, ? super Object> p) {
        return "app/" + (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(p) + ".cfg";
    }

    File doBundle(Map<String, ? super Object> p, File outputDirectory, boolean dependentTask) {
        HashMap<String, ? super Object> originalParams = new HashMap<String, Object>(p);
        try {
            if (!outputDirectory.isDirectory() && !outputDirectory.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outputDirectory.getAbsolutePath()));
            }
            if (!outputDirectory.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outputDirectory.getAbsolutePath()));
            }
            File rootDirectory = LinuxAppBundler.getRootDir(outputDirectory, p);
            IOUtils.deleteRecursive(rootDirectory);
            rootDirectory.mkdirs();
            if (!dependentTask) {
                Log.info(MessageFormat.format(I18N.getString("message.creating-bundle-location"), rootDirectory.getAbsolutePath()));
            }
            File runtimeDirectory = new File(rootDirectory, "runtime");
            File appDirectory = new File(rootDirectory, "app");
            appDirectory.mkdirs();
            this.createLauncherForEntryPoint(p, rootDirectory);
            IOUtils.copyFromURL(LinuxResources.class.getResource(LIBRARY_NAME), new File(rootDirectory, LIBRARY_NAME));
            List entryPoints = (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(p);
            for (Map entryPoint : entryPoints) {
                HashMap<String, ? super Object> tmp = new HashMap<String, Object>(originalParams);
                tmp.putAll(entryPoint);
                this.createLauncherForEntryPoint(tmp, rootDirectory);
            }
            this.copyRuntime(p, runtimeDirectory);
            this.copyApplication(p, appDirectory);
            return rootDirectory;
        }
        catch (IOException ex) {
            Log.info("Exception: " + ex);
            Log.debug(ex);
            return null;
        }
    }

    private void createLauncherForEntryPoint(Map<String, ? super Object> p, File rootDir) throws IOException {
        File executableFile = new File(rootDir, LinuxAppBundler.getLauncherName(p));
        IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(p), executableFile);
        executableFile.setExecutable(true, false);
        executableFile.setWritable(true, true);
        if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(p)).equals("prop")) {
            this.writeCfgFile(p, rootDir);
        } else {
            this.writeCfgFile(p, new File(rootDir, LinuxAppBundler.getLauncherCfgName(p)), this.getRuntimeLocation(p));
        }
    }

    private void copyApplication(Map<String, ? super Object> params, File appDirectory) throws IOException {
        List appResourcesList = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params);
        if (appResourcesList == null) {
            throw new RuntimeException("Null app resources?");
        }
        for (RelativeFileSet appResources : appResourcesList) {
            if (appResources == null) {
                throw new RuntimeException("Null app resources?");
            }
            File srcdir = appResources.getBaseDirectory();
            for (String fname : appResources.getIncludedFiles()) {
                IOUtils.copyFile(new File(srcdir, fname), new File(appDirectory, fname));
            }
        }
    }

    private String getRuntimeLocation(Map<String, ? super Object> params) {
        if (LINUX_RUNTIME.fetchFrom(params) == null) {
            return "";
        }
        return "$APPDIR/runtime";
    }

    private void writeCfgFile(Map<String, ? super Object> params, File rootDir) throws FileNotFoundException {
        File cfgFile = new File(rootDir, LinuxAppBundler.getLauncherCfgName(params));
        cfgFile.delete();
        PrintStream out = new PrintStream(cfgFile);
        out.println("app.runtime=" + this.getRuntimeLocation(params));
        out.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(params)).getIncludedFiles().iterator().next());
        out.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(params));
        out.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params)).replaceAll("\\.", "/"));
        StringBuilder macroedPath = new StringBuilder();
        for (String s : ((String)StandardBundlerParam.CLASSPATH.fetchFrom(params)).split("[ ;:]+")) {
            macroedPath.append(s);
            macroedPath.append(":");
        }
        macroedPath.deleteCharAt(macroedPath.length() - 1);
        out.println("app.classpath=" + macroedPath.toString());
        List jvmargs = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(params);
        int idx = 1;
        for (Object a : jvmargs) {
            out.println("jvmarg." + idx + "=" + (String)a);
            ++idx;
        }
        Map jvmProps = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(params);
        for (Map.Entry entry : jvmProps.entrySet()) {
            out.println("jvmarg." + idx + "=-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            ++idx;
        }
        String preloader = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(params);
        if (preloader != null) {
            out.println("jvmarg." + idx + "=-Djavafx.preloader=" + preloader);
        }
        out.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(params));
        out.println("app.identifier=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params));
        Map map = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(params);
        idx = 1;
        for (Map.Entry arg : map.entrySet()) {
            if (arg.getKey() == null || arg.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
            } else {
                out.println("jvmuserarg." + idx + ".name=" + (String)arg.getKey());
                out.println("jvmuserarg." + idx + ".value=" + (String)arg.getValue());
            }
            ++idx;
        }
        List args = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(params);
        idx = 1;
        for (String a : args) {
            out.println("arg." + idx + "=" + a);
            ++idx;
        }
        out.close();
    }

    private void copyRuntime(Map<String, ? super Object> params, File runtimeDirectory) throws IOException {
        RelativeFileSet runtime = LINUX_RUNTIME.fetchFrom(params);
        if (runtime == null) {
            return;
        }
        runtimeDirectory.mkdirs();
        File srcdir = runtime.getBaseDirectory();
        Set<String> filesToCopy = runtime.getIncludedFiles();
        for (String fname : filesToCopy) {
            IOUtils.copyFile(new File(srcdir, fname), new File(runtimeDirectory, fname));
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "linux.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return LinuxAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, StandardBundlerParam.ARGUMENTS, StandardBundlerParam.CLASSPATH, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, LINUX_RUNTIME, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.PRELOADER_CLASS, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION);
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.doBundle(params, outputParentDir, false);
    }

    @Override
    protected String getCacheLocation(Map<String, ? super Object> params) {
        return "$CACHEDIR/";
    }

    @Override
    public void extractRuntimeFlags(Map<String, ? super Object> params) {
        if (params.containsKey(".runtime.autodetect")) {
            return;
        }
        params.put(".runtime.autodetect", "attempted");
        RelativeFileSet runtime = LINUX_RUNTIME.fetchFrom(params);
        if (runtime == null) {
            params.put(".runtime.autodetect", "systemjre");
        } else {
            String commandline;
            File runtimePath = runtime.getBaseDirectory();
            File launcherPath = new File(runtimePath, "bin/java");
            ProcessBuilder pb = new ProcessBuilder(launcherPath.getAbsolutePath(), "-version");
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                try (PrintStream pout = new PrintStream(baos);){
                    IOUtils.exec(pb, Log.isDebug(), true, pout);
                }
                commandline = baos.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                params.put(".runtime.autodetect", "failed");
                return;
            }
            AbstractImageBundler.extractFlagsFromVersion(params, commandline);
            params.put(".runtime.autodetect", "succeeded");
        }
    }

    private static /* synthetic */ RelativeFileSet lambda$static$7(String s, Map p) {
        return JreUtils.extractJreAsRelativeFileSet(s, LINUX_JRE_RULES.fetchFrom(p));
    }

    private static /* synthetic */ RelativeFileSet lambda$static$6(Map params) {
        return JreUtils.extractJreAsRelativeFileSet(System.getProperty("java.home"), LINUX_JRE_RULES.fetchFrom(params));
    }

    private static /* synthetic */ JreUtils.Rule[] lambda$static$5(String s, Map p) {
        return null;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

