/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class StandardBundlerParam<T>
extends BundlerParamInfo<T> {
    public static final String MANIFEST_JAVAFX_MAIN = "JavaFX-Application-Class";
    public static final String MANIFEST_PRELOADER = "JavaFX-Preloader-Class";
    private static final ResourceBundle I18N = ResourceBundle.getBundle(StandardBundlerParam.class.getName());
    public static final StandardBundlerParam<RelativeFileSet> APP_RESOURCES = new StandardBundlerParam<RelativeFileSet>(I18N.getString("param.app-resources.name"), I18N.getString("param.app-resource.description"), "appResources", RelativeFileSet.class, null, null);
    public static final StandardBundlerParam<List<RelativeFileSet>> APP_RESOURCES_LIST = new StandardBundlerParam<List>(I18N.getString("param.app-resources-list.name"), I18N.getString("param.app-resource-list.description"), "appResourcesList", List.class, p -> new ArrayList<RelativeFileSet>(Arrays.asList((RelativeFileSet)APP_RESOURCES.fetchFrom((Map<String, Object>)p))), null);
    public static final StandardBundlerParam<File> ICON = new StandardBundlerParam<File>(I18N.getString("param.icon-file.name"), I18N.getString("param.icon-file.description"), "icon", File.class, params -> null, (s, p) -> new File((String)s));
    public static final StandardBundlerParam<String> MAIN_CLASS = new StandardBundlerParam<String>(I18N.getString("param.main-class.name"), I18N.getString("param.main-class.description"), "applicationClass", String.class, params -> {
        StandardBundlerParam.extractMainClassInfoFromAppResources(params);
        return (String)params.get("applicationClass");
    }, (s, p) -> s);
    public static final StandardBundlerParam<String> APP_NAME = new StandardBundlerParam<String>(I18N.getString("param.app-name.name"), I18N.getString("param.app-name.description"), "name", String.class, params -> {
        String s = (String)MAIN_CLASS.fetchFrom((Map<String, Object>)params);
        if (s == null) {
            return null;
        }
        int idx = s.lastIndexOf(".");
        if (idx >= 0) {
            return s.substring(idx + 1);
        }
        return s;
    }, (s, p) -> s);
    private static Pattern TO_FS_NAME = Pattern.compile("\\s|[\\\\/?:*<>|]");
    public static final StandardBundlerParam<String> APP_FS_NAME = new StandardBundlerParam<String>(I18N.getString("param.app-fs-name.name"), I18N.getString("param.app-fs-name.description"), "name.fs", String.class, params -> TO_FS_NAME.matcher((CharSequence)APP_NAME.fetchFrom((Map<String, Object>)params)).replaceAll(""), (s, p) -> s);
    public static final StandardBundlerParam<String> VENDOR = new StandardBundlerParam<String>(I18N.getString("param.vendor.name"), I18N.getString("param.vendor.description"), "vendor", String.class, params -> I18N.getString("param.vendor.default"), (s, p) -> s);
    public static final StandardBundlerParam<String> CATEGORY = new StandardBundlerParam<String>(I18N.getString("param.category.name"), I18N.getString("param.category.description"), "applicationCategory", String.class, params -> I18N.getString("param.category.default"), (s, p) -> s);
    public static final StandardBundlerParam<String> DESCRIPTION = new StandardBundlerParam<String>(I18N.getString("param.description.name"), I18N.getString("param.description.description"), "description", String.class, params -> params.containsKey(APP_NAME.getID()) ? (String)APP_NAME.fetchFrom((Map<String, Object>)params) : I18N.getString("param.description.default"), (s, p) -> s);
    public static final StandardBundlerParam<String> COPYRIGHT = new StandardBundlerParam<String>(I18N.getString("param.copyright.name"), I18N.getString("param.copyright.description"), "copyright", String.class, params -> MessageFormat.format(I18N.getString("param.copyright.default"), new Date()), (s, p) -> s);
    public static final StandardBundlerParam<RelativeFileSet> MAIN_JAR = new StandardBundlerParam<RelativeFileSet>(I18N.getString("param.main-jar.name"), I18N.getString("param.main-jar.description"), "mainJar", RelativeFileSet.class, params -> {
        StandardBundlerParam.extractMainClassInfoFromAppResources(params);
        return (RelativeFileSet)params.get("mainJar");
    }, (s, p) -> {
        for (RelativeFileSet rfs : (List)APP_RESOURCES_LIST.fetchFrom((Map<String, Object>)p)) {
            File appResourcesRoot = rfs.getBaseDirectory();
            File f = new File(appResourcesRoot, (String)s);
            if (!f.exists()) continue;
            return new RelativeFileSet(appResourcesRoot, (Set<File>)new LinkedHashSet<File>(Arrays.asList(f)));
        }
        throw new IllegalArgumentException(new ConfigException(MessageFormat.format(I18N.getString("error.main-jar-does-not-exist"), s), I18N.getString("error.main-jar-does-not-exist.advice")));
    });
    public static final StandardBundlerParam<String> CLASSPATH = new StandardBundlerParam<String>(I18N.getString("param.classpath.name"), I18N.getString("param.classpath.description"), "classpath", String.class, params -> {
        StandardBundlerParam.extractMainClassInfoFromAppResources(params);
        String cp = (String)params.get("classpath");
        return cp == null ? "" : cp;
    }, (s, p) -> s.replace(File.pathSeparator, " "));
    public static final StandardBundlerParam<Boolean> USE_FX_PACKAGING = new StandardBundlerParam<Boolean>(I18N.getString("param.use-javafx-packaging.name"), I18N.getString("param.use-javafx-packaging.description"), "fxPackaging", Boolean.class, params -> {
        StandardBundlerParam.extractMainClassInfoFromAppResources(params);
        Boolean result = (Boolean)params.get("fxPackaging");
        return result == null ? Boolean.FALSE : result;
    }, (s, p) -> Boolean.valueOf(s));
    public static final StandardBundlerParam<List<String>> ARGUMENTS = new StandardBundlerParam<List>(I18N.getString("param.arguments.name"), I18N.getString("param.arguments.description"), "arguments", List.class, params -> Collections.emptyList(), (s, p) -> StandardBundlerParam.splitStringWithEscapes(s));
    public static final StandardBundlerParam<List<String>> JVM_OPTIONS = new StandardBundlerParam<List>(I18N.getString("param.jvm-options.name"), I18N.getString("param.jvm-options.description"), "jvmOptions", List.class, params -> Collections.emptyList(), (s, p) -> Arrays.asList(s.split("\\s+")));
    public static final StandardBundlerParam<Map<String, String>> JVM_PROPERTIES = new StandardBundlerParam<Map>(I18N.getString("param.jvm-system-properties.name"), I18N.getString("param.jvm-system-properties.description"), "jvmProperties", Map.class, params -> Collections.emptyMap(), (s, params) -> {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Properties p = new Properties();
            p.load(new StringReader((String)s));
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    });
    public static final StandardBundlerParam<Map<String, String>> USER_JVM_OPTIONS = new StandardBundlerParam<Map>(I18N.getString("param.user-jvm-options.name"), I18N.getString("param.user-jvm-options.description"), "userJvmOptions", Map.class, params -> Collections.emptyMap(), (s, params) -> {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Properties p = new Properties();
            p.load(new StringReader((String)s));
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    });
    public static final StandardBundlerParam<String> TITLE = new StandardBundlerParam<String>(I18N.getString("param.title.name"), I18N.getString("param.title.description"), "title", String.class, APP_NAME::fetchFrom, (s, p) -> s);
    public static final StandardBundlerParam<String> VERSION = new StandardBundlerParam<String>(I18N.getString("param.version.name"), I18N.getString("param.version.description"), "appVersion", String.class, params -> I18N.getString("param.version.default"), (s, p) -> s);
    public static final StandardBundlerParam<Boolean> SYSTEM_WIDE = new StandardBundlerParam<Boolean>(I18N.getString("param.system-wide.name"), I18N.getString("param.system-wide.description"), "systemWide", Boolean.class, params -> null, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? null : Boolean.valueOf(s));
    public static final StandardBundlerParam<Boolean> SERVICE_HINT = new StandardBundlerParam<Boolean>(I18N.getString("param.service-hint.name"), I18N.getString("param.service-hint.description"), "serviceHint", Boolean.class, params -> false, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? false : Boolean.valueOf(s));
    public static final StandardBundlerParam<Boolean> START_ON_INSTALL = new StandardBundlerParam<Boolean>(I18N.getString("param.start-on-install.name"), I18N.getString("param.start-on-install.description"), "startOnInstall", Boolean.class, params -> false, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? false : Boolean.valueOf(s));
    public static final StandardBundlerParam<Boolean> STOP_ON_UNINSTALL = new StandardBundlerParam<Boolean>(I18N.getString("param.stop-on-uninstall.name"), I18N.getString("param.stop-on-uninstall.description"), "stopOnUninstall", Boolean.class, params -> true, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? true : Boolean.valueOf(s));
    public static final StandardBundlerParam<Boolean> RUN_AT_STARTUP = new StandardBundlerParam<Boolean>(I18N.getString("param.run-at-startup.name"), I18N.getString("param.run-at-startup.description"), "runAtStartup", Boolean.class, params -> false, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? false : Boolean.valueOf(s));
    public static final StandardBundlerParam<Boolean> SIGN_BUNDLE = new StandardBundlerParam<Boolean>(I18N.getString("param.sign-bundle.name"), I18N.getString("param.sign-bundle.description"), "signBundle", Boolean.class, params -> null, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? null : Boolean.valueOf(s));
    public static final StandardBundlerParam<Boolean> SHORTCUT_HINT = new StandardBundlerParam<Boolean>(I18N.getString("param.desktop-shortcut-hint.name"), I18N.getString("param.desktop-shortcut-hint.description"), "shortcutHint", Boolean.class, params -> false, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? false : Boolean.valueOf(s));
    public static final StandardBundlerParam<Boolean> MENU_HINT = new StandardBundlerParam<Boolean>(I18N.getString("param.menu-shortcut-hint.name"), I18N.getString("param.menu-shortcut-hint.description"), "menuHint", Boolean.class, params -> true, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? true : Boolean.valueOf(s));
    public static final StandardBundlerParam<List<String>> LICENSE_FILE = new StandardBundlerParam<List>(I18N.getString("param.license-file.name"), I18N.getString("param.license-file.description"), "licenseFile", List.class, params -> Collections.emptyList(), (s, p) -> Arrays.asList(s.split(",")));
    public static final BundlerParamInfo<String> LICENSE_TYPE = new StandardBundlerParam<String>(I18N.getString("param.license-type.name"), I18N.getString("param.license-type.description"), "licenseType", String.class, params -> I18N.getString("param.license-type.default"), (s, p) -> s);
    public static final StandardBundlerParam<File> BUILD_ROOT = new StandardBundlerParam<File>(I18N.getString("param.build-root.name"), I18N.getString("param.build-root.description"), "buildRoot", File.class, params -> {
        try {
            return Files.createTempDirectory("fxbundler", new FileAttribute[0]).toFile();
        }
        catch (IOException ioe) {
            return null;
        }
    }, (s, p) -> new File((String)s));
    public static final StandardBundlerParam<String> IDENTIFIER = new StandardBundlerParam<String>(I18N.getString("param.identifier.name"), I18N.getString("param.identifier.description"), "identifier", String.class, params -> {
        String s = (String)MAIN_CLASS.fetchFrom((Map<String, Object>)params);
        if (s == null) {
            return null;
        }
        int idx = s.lastIndexOf(".");
        if (idx >= 1) {
            return s.substring(0, idx);
        }
        return s;
    }, (s, p) -> s);
    public static final StandardBundlerParam<String> PREFERENCES_ID = new StandardBundlerParam<String>(I18N.getString("param.preferences-id.name"), I18N.getString("param.preferences-id.description"), "preferencesID", String.class, p -> Optional.ofNullable(IDENTIFIER.fetchFrom((Map<String, Object>)p)).orElse("").replace('.', '/'), (s, p) -> s);
    public static final StandardBundlerParam<String> PRELOADER_CLASS = new StandardBundlerParam<String>(I18N.getString("param.preloader.name"), I18N.getString("param.preloader.description"), "preloader", String.class, p -> null, null);
    public static final StandardBundlerParam<Boolean> VERBOSE = new StandardBundlerParam<Boolean>(I18N.getString("param.verbose.name"), I18N.getString("param.verbose.description"), "verbose", Boolean.class, params -> false, (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? true : Boolean.valueOf(s));
    public static final StandardBundlerParam<File> DROP_IN_RESOURCES_ROOT = new StandardBundlerParam<File>(I18N.getString("param.drop-in-resources-root.name"), I18N.getString("param.drop-in-resources-root.description"), "dropinResourcesRoot", File.class, params -> null, (s, p) -> new File((String)s));
    public static final StandardBundlerParam<List<Map<String, ? super Object>>> SECONDARY_LAUNCHERS = new StandardBundlerParam<List>(I18N.getString("param.secondary-launchers.name"), I18N.getString("param.secondary-launchers.description"), "secondaryLaunchers", List.class, params -> new ArrayList(1), (s, p) -> null);
    public static final StandardBundlerParam<List<Map<String, ? super Object>>> FILE_ASSOCIATIONS = new StandardBundlerParam<List>(I18N.getString("param.file-associations.name"), I18N.getString("param.file-associations.description"), "fileAssociations", List.class, params -> new ArrayList(1), (s, p) -> null);
    public static final StandardBundlerParam<List<String>> FA_EXTENSIONS = new StandardBundlerParam<List>(I18N.getString("param.fa-extension.name"), I18N.getString("param.fa-extension.description"), "fileAssociation.extension", List.class, params -> null, (s, p) -> Arrays.asList(s.split("(,|\\s)+")));
    public static final StandardBundlerParam<List<String>> FA_CONTENT_TYPE = new StandardBundlerParam<List>(I18N.getString("param.fa-content-type.name"), I18N.getString("param.fa-content-type.description"), "fileAssociation.contentType", List.class, params -> null, (s, p) -> Arrays.asList(s.split("(,|\\s)+")));
    public static final StandardBundlerParam<String> FA_DESCRIPTION = new StandardBundlerParam<String>(I18N.getString("param.fa-description.name"), I18N.getString("param.fa-description.description"), "fileAssociation.description", String.class, params -> (String)APP_NAME.fetchFrom((Map<String, Object>)params) + " File", null);
    public static final StandardBundlerParam<File> FA_ICON = new StandardBundlerParam<File>(I18N.getString("param.fa-icon.name"), I18N.getString("param.fa-icon.description"), "fileAssociation.icon", File.class, ICON::fetchFrom, (s, p) -> new File((String)s));
    public static final StandardBundlerParam<Boolean> UNLOCK_COMMERCIAL_FEATURES = new StandardBundlerParam<Boolean>(I18N.getString("param.commercial-features.name"), I18N.getString("param.commercial-features.description"), "commercialFeatures", Boolean.class, p -> false, (s, p) -> Boolean.parseBoolean(s));
    public static final StandardBundlerParam<Boolean> ENABLE_APP_CDS = new StandardBundlerParam<Boolean>(I18N.getString("param.com-app-cds.name"), I18N.getString("param.com-app-cds.description"), "commercial.AppCDS", Boolean.class, p -> false, (s, p) -> Boolean.parseBoolean(s));
    public static final StandardBundlerParam<String> APP_CDS_CACHE_MODE = new StandardBundlerParam<String>(I18N.getString("param.com-app-cds-cache-mode.name"), I18N.getString("param.com-app-cds-cache-mode.description"), "commercial.AppCDS.cache", String.class, p -> "auto", (s, p) -> s);
    public static final StandardBundlerParam<List<String>> APP_CDS_CLASS_ROOTS = new StandardBundlerParam<List>(I18N.getString("param.com-app-cds-root.name"), I18N.getString("param.com-app-cds-root.description"), "commercial.AppCDS.classRoots", List.class, p -> Arrays.asList((String)MAIN_CLASS.fetchFrom((Map<String, Object>)p)), (s, p) -> Arrays.asList(s.split("[ ,:]")));

    public StandardBundlerParam(String name, String description, String id, Class<T> valueType, Function<Map<String, ? super Object>, T> defaultValueFunction, BiFunction<String, Map<String, ? super Object>, T> stringConverter) {
        this.name = name;
        this.description = description;
        this.id = id;
        this.valueType = valueType;
        this.defaultValueFunction = defaultValueFunction;
        this.stringConverter = stringConverter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractMainClassInfoFromAppResources(Map<String, ? super Object> params) {
        boolean hasMainClass = params.containsKey(MAIN_CLASS.getID());
        boolean hasMainJar = params.containsKey(MAIN_JAR.getID());
        boolean hasMainJarClassPath = params.containsKey(CLASSPATH.getID());
        boolean hasPreloader = params.containsKey(PRELOADER_CLASS.getID());
        if (hasMainClass && hasMainJar && hasMainJarClassPath) {
            return;
        }
        ArrayList<String[]> filesToCheck = new ArrayList<String[]>();
        if (hasMainJar) {
            String[] rfs = (String[])MAIN_JAR.fetchFrom(params);
            for (String s : rfs.getIncludedFiles()) {
                filesToCheck.add(new String[]{rfs.getBaseDirectory().toString(), s});
            }
        } else if (hasMainJarClassPath) {
            for (String s : ((String)CLASSPATH.fetchFrom(params)).split("\\s+")) {
                filesToCheck.add(new String[]{((RelativeFileSet)APP_RESOURCES.fetchFrom(params)).getBaseDirectory().toString(), s});
            }
        } else {
            List rfsl = (List)APP_RESOURCES_LIST.fetchFrom(params);
            if (rfsl == null) return;
            if (rfsl.isEmpty()) {
                return;
            }
            for (RelativeFileSet rfs : rfsl) {
                if (rfs == null) continue;
                for (String s : rfs.getIncludedFiles()) {
                    filesToCheck.add(new String[]{rfs.getBaseDirectory().toString(), s});
                }
            }
        }
        String declaredMainClass = (String)params.get(MAIN_CLASS.getID());
        Iterator<String> iterator = filesToCheck.iterator();
        while (iterator.hasNext()) {
            String[] fnames = (String[])iterator.next();
            try {
                File file;
                if (!fnames[1].toLowerCase().endsWith(".jar") || !(file = new File(fnames[0], fnames[1])).exists()) continue;
                JarFile jf = new JarFile(file);
                Throwable throwable = null;
                try {
                    String preloaderClass;
                    Attributes attrs;
                    block41: {
                        String fxMain;
                        String mainClass;
                        block42: {
                            Manifest m = jf.getManifest();
                            attrs = m != null ? m.getMainAttributes() : null;
                            if (attrs == null) continue;
                            mainClass = attrs.getValue(Attributes.Name.MAIN_CLASS);
                            fxMain = attrs.getValue(MANIFEST_JAVAFX_MAIN);
                            preloaderClass = attrs.getValue(MANIFEST_PRELOADER);
                            if (!hasMainClass) break block42;
                            if (declaredMainClass.equals(fxMain)) {
                                params.put(USE_FX_PACKAGING.getID(), (Object)true);
                                break block41;
                            } else if (declaredMainClass.equals(mainClass)) {
                                params.put(USE_FX_PACKAGING.getID(), (Object)false);
                                break block41;
                            } else {
                                if (fxMain != null) {
                                    Log.info(MessageFormat.format(I18N.getString("message.fx-app-does-not-match-specified-main"), fnames[1], fxMain, declaredMainClass));
                                }
                                if (mainClass == null) continue;
                                Log.info(MessageFormat.format(I18N.getString("message.main-class-does-not-match-specified-main"), fnames[1], mainClass, declaredMainClass));
                                continue;
                            }
                        }
                        if (fxMain != null) {
                            params.put(USE_FX_PACKAGING.getID(), (Object)true);
                            params.put(MAIN_CLASS.getID(), fxMain);
                        } else {
                            if (mainClass == null) continue;
                            params.put(USE_FX_PACKAGING.getID(), (Object)false);
                            params.put(MAIN_CLASS.getID(), mainClass);
                        }
                    }
                    if (!hasPreloader && preloaderClass != null) {
                        params.put(PRELOADER_CLASS.getID(), preloaderClass);
                    }
                    if (!hasMainJar) {
                        if (fnames[0] == null) {
                            fnames[0] = file.getParentFile().toString();
                        }
                        params.put(MAIN_JAR.getID(), new RelativeFileSet(new File(fnames[0]), (Set<File>)new LinkedHashSet<File>(Arrays.asList(file))));
                    }
                    if (hasMainJarClassPath) return;
                    String cp = attrs.getValue(Attributes.Name.CLASS_PATH);
                    params.put(CLASSPATH.getID(), cp == null ? "" : cp);
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jf == null) continue;
                    if (throwable != null) {
                        try {
                            jf.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jf.close();
                }
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void validateMainClassInfoFromAppResources(Map<String, ? super Object> params) throws ConfigException {
        boolean hasMainClass = params.containsKey(MAIN_CLASS.getID());
        boolean hasMainJar = params.containsKey(MAIN_JAR.getID());
        boolean hasMainJarClassPath = params.containsKey(CLASSPATH.getID());
        if (hasMainClass && hasMainJar && hasMainJarClassPath) {
            return;
        }
        StandardBundlerParam.extractMainClassInfoFromAppResources(params);
        if (!params.containsKey(MAIN_CLASS.getID())) {
            if (hasMainJar) {
                throw new ConfigException(MessageFormat.format(I18N.getString("error.no-main-class-with-main-jar"), MAIN_JAR.fetchFrom(params)), MessageFormat.format(I18N.getString("error.no-main-class-with-main-jar.advice"), MAIN_JAR.fetchFrom(params)));
            }
            if (hasMainJarClassPath) {
                throw new ConfigException(I18N.getString("error.no-main-class-with-classpath"), I18N.getString("error.no-main-class-with-classpath.advice"));
            }
            throw new ConfigException(I18N.getString("error.no-main-class"), I18N.getString("error.no-main-class.advice"));
        }
    }

    private static List<String> splitStringWithEscapes(String s) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean quoted = false;
        boolean escaped = false;
        for (char c : s.toCharArray()) {
            if (escaped) {
                current.append(c);
                continue;
            }
            if ('\"' == c) {
                quoted = !quoted;
                continue;
            }
            if (!quoted && Character.isWhitespace(c)) {
                l.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        l.add(current.toString());
        return l;
    }
}

