/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.InvalidBundlerParamException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class EnumeratedBundlerParam<T>
extends BundlerParamInfo<T> {
    private Map<String, T> elements;
    private boolean strict;

    public EnumeratedBundlerParam(String name, String description, String id, Class<T> valueType, Function<Map<String, ? super Object>, T> defaultValueFunction, BiFunction<String, Map<String, ? super Object>, T> stringConverter, Map<String, T> elements, boolean strict) {
        this.name = name;
        this.description = description;
        this.id = id;
        this.valueType = valueType;
        this.defaultValueFunction = defaultValueFunction;
        this.stringConverter = stringConverter;
        this.elements = elements;
        this.strict = strict;
    }

    public boolean isInPossibleValues(T value) {
        return this.elements.values().contains(value);
    }

    public Set<String> getDisplayableKeys() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public T getValueForDisplayableKey(String displayableKey) {
        return this.elements.get(displayableKey);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isLoose() {
        return !this.isStrict();
    }

    public T validatedFetchFrom(Map<String, ? super Object> params) throws InvalidBundlerParamException {
        if (this.isStrict()) {
            Object value = this.fetchFrom(params);
            if (!this.isInPossibleValues(value)) {
                throw new InvalidBundlerParamException("Parameter " + value.toString() + " not in valid set of values for BundlerParam " + this.name);
            }
            return value;
        }
        return this.fetchFrom(params);
    }
}

