/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class AbstractBundler
implements Bundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(AbstractBundler.class.getName());
    public static final BundlerParamInfo<File> IMAGES_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.images-root.name"), I18N.getString("param.images-root.description"), "imagesRoot", File.class, params -> new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)params), "images"), (s, p) -> null);
    public static final String BUNDLER_PREFIX = "package/";
    protected Class baseResourceLoader = null;

    protected void fetchResource(String publicName, String category, String defaultName, File result, boolean verbose, File publicRoot) throws IOException {
        URL u = this.locateResource(publicName, category, defaultName, verbose, publicRoot);
        if (u != null) {
            IOUtils.copyFromURL(u, result);
        } else if (verbose) {
            Log.info(MessageFormat.format(I18N.getString("message.using-default-resource"), category == null ? "" : "[" + category + "] ", publicName));
        }
    }

    protected void fetchResource(String publicName, String category, File defaultFile, File result, boolean verbose, File publicRoot) throws IOException {
        URL u = this.locateResource(publicName, category, null, verbose, publicRoot);
        if (u != null) {
            IOUtils.copyFromURL(u, result);
        } else {
            IOUtils.copyFile(defaultFile, result);
            if (verbose) {
                Log.info(MessageFormat.format(I18N.getString("message.using-custom-resource-from-file"), category == null ? "" : "[" + category + "] ", defaultFile.getAbsoluteFile()));
            }
        }
    }

    private URL locateResource(String publicName, String category, String defaultName, boolean verbose, File publicRoot) throws IOException {
        URL u = null;
        boolean custom = false;
        if (publicName != null) {
            if (publicRoot != null) {
                File publicResource = new File(publicRoot, publicName);
                if (publicResource.exists() && publicResource.isFile()) {
                    u = publicResource.toURI().toURL();
                }
            } else {
                u = this.baseResourceLoader.getClassLoader().getResource(publicName);
            }
            boolean bl = custom = u != null;
        }
        if (u == null && defaultName != null) {
            u = this.baseResourceLoader.getResource(defaultName);
        }
        String msg = null;
        if (custom) {
            msg = MessageFormat.format(I18N.getString("message.using-custom-resource-from-classpath"), category == null ? "" : "[" + category + "] ", publicName);
        } else if (u != null) {
            msg = MessageFormat.format(I18N.getString("message.using-default-resource-from-classpath"), category == null ? "" : "[" + category + "] ", publicName);
        }
        if (verbose && u != null) {
            Log.info(msg);
        }
        return u;
    }

    protected String preprocessTextResource(String publicName, String category, String defaultName, Map<String, String> pairs, boolean verbose, File publicRoot) throws IOException {
        int length;
        URL u = this.locateResource(publicName, category, defaultName, verbose, publicRoot);
        InputStream inp = u.openStream();
        if (inp == null) {
            throw new RuntimeException("Jar corrupt? No " + defaultName + " resource!");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inp.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        String result = new String(baos.toByteArray());
        for (Map.Entry<String, String> e : pairs.entrySet()) {
            if (e.getValue() == null) continue;
            result = result.replace(e.getKey(), e.getValue());
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

