/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.scene.control.SelectionModel;

public abstract class SingleSelectionModel<T>
extends SelectionModel<T> {
    @Override
    public void clearSelection() {
        this.updateSelectedIndex(-1);
    }

    @Override
    public void clearSelection(int index) {
        if (this.getSelectedIndex() == index) {
            this.clearSelection();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0 || this.getSelectedIndex() == -1;
    }

    @Override
    public boolean isSelected(int index) {
        return this.getSelectedIndex() == index;
    }

    @Override
    public void clearAndSelect(int index) {
        this.select(index);
    }

    @Override
    public void select(T obj) {
        if (obj == null) {
            this.setSelectedIndex(-1);
            this.setSelectedItem(null);
            return;
        }
        int itemCount = this.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            T value = this.getModelItem(i);
            if (value == null || !value.equals(obj)) continue;
            this.select(i);
            return;
        }
        this.setSelectedItem(obj);
    }

    @Override
    public void select(int index) {
        if (index == -1) {
            this.clearSelection();
            return;
        }
        int itemCount = this.getItemCount();
        if (itemCount == 0 || index < 0 || index >= itemCount) {
            return;
        }
        this.updateSelectedIndex(index);
    }

    @Override
    public void selectPrevious() {
        if (this.getSelectedIndex() == 0) {
            return;
        }
        this.select(this.getSelectedIndex() - 1);
    }

    @Override
    public void selectNext() {
        this.select(this.getSelectedIndex() + 1);
    }

    @Override
    public void selectFirst() {
        if (this.getItemCount() > 0) {
            this.select(0);
        }
    }

    @Override
    public void selectLast() {
        int numItems = this.getItemCount();
        if (numItems > 0 && this.getSelectedIndex() < numItems - 1) {
            this.select(numItems - 1);
        }
    }

    protected abstract T getModelItem(int var1);

    protected abstract int getItemCount();

    private void updateSelectedIndex(int newIndex) {
        int currentIndex = this.getSelectedIndex();
        Object currentItem = this.getSelectedItem();
        this.setSelectedIndex(newIndex);
        if (currentIndex != -1 || currentItem == null || newIndex != -1) {
            this.setSelectedItem(this.getModelItem(this.getSelectedIndex()));
        }
    }
}

