/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.NumberTangentInterpolator;
import javafx.animation.Interpolator;
import javafx.animation.KeyValue;
import javafx.beans.value.WritableBooleanValue;
import javafx.beans.value.WritableDoubleValue;
import javafx.beans.value.WritableFloatValue;
import javafx.beans.value.WritableIntegerValue;
import javafx.beans.value.WritableLongValue;
import javafx.beans.value.WritableValue;

public abstract class InterpolationInterval {
    protected final long ticks;
    protected final Interpolator rightInterpolator;

    protected InterpolationInterval(long ticks, Interpolator rightInterpolator) {
        this.ticks = ticks;
        this.rightInterpolator = rightInterpolator;
    }

    public abstract void interpolate(double var1);

    public abstract void recalculateStartValue();

    public static InterpolationInterval create(KeyValue rightKeyValue, long ticks, KeyValue leftKeyValue, long duration) {
        switch (rightKeyValue.getType()) {
            case BOOLEAN: {
                return new BooleanInterpolationInterval(rightKeyValue, ticks, leftKeyValue.getEndValue());
            }
            case DOUBLE: {
                return leftKeyValue.getInterpolator() instanceof NumberTangentInterpolator || rightKeyValue.getInterpolator() instanceof NumberTangentInterpolator ? new TangentDoubleInterpolationInterval(rightKeyValue, ticks, leftKeyValue, duration) : new DoubleInterpolationInterval(rightKeyValue, ticks, leftKeyValue.getEndValue());
            }
            case FLOAT: {
                return leftKeyValue.getInterpolator() instanceof NumberTangentInterpolator || rightKeyValue.getInterpolator() instanceof NumberTangentInterpolator ? new TangentFloatInterpolationInterval(rightKeyValue, ticks, leftKeyValue, duration) : new FloatInterpolationInterval(rightKeyValue, ticks, leftKeyValue.getEndValue());
            }
            case INTEGER: {
                return leftKeyValue.getInterpolator() instanceof NumberTangentInterpolator || rightKeyValue.getInterpolator() instanceof NumberTangentInterpolator ? new TangentIntegerInterpolationInterval(rightKeyValue, ticks, leftKeyValue, duration) : new IntegerInterpolationInterval(rightKeyValue, ticks, leftKeyValue.getEndValue());
            }
            case LONG: {
                return leftKeyValue.getInterpolator() instanceof NumberTangentInterpolator || rightKeyValue.getInterpolator() instanceof NumberTangentInterpolator ? new TangentLongInterpolationInterval(rightKeyValue, ticks, leftKeyValue, duration) : new LongInterpolationInterval(rightKeyValue, ticks, leftKeyValue.getEndValue());
            }
            case OBJECT: {
                return new ObjectInterpolationInterval(rightKeyValue, ticks, leftKeyValue.getEndValue());
            }
        }
        throw new RuntimeException("Should not reach here");
    }

    public static InterpolationInterval create(KeyValue rightKeyValue, long ticks) {
        switch (rightKeyValue.getType()) {
            case BOOLEAN: {
                return new BooleanInterpolationInterval(rightKeyValue, ticks);
            }
            case DOUBLE: {
                return rightKeyValue.getInterpolator() instanceof NumberTangentInterpolator ? new TangentDoubleInterpolationInterval(rightKeyValue, ticks) : new DoubleInterpolationInterval(rightKeyValue, ticks);
            }
            case FLOAT: {
                return rightKeyValue.getInterpolator() instanceof NumberTangentInterpolator ? new TangentFloatInterpolationInterval(rightKeyValue, ticks) : new FloatInterpolationInterval(rightKeyValue, ticks);
            }
            case INTEGER: {
                return rightKeyValue.getInterpolator() instanceof NumberTangentInterpolator ? new TangentIntegerInterpolationInterval(rightKeyValue, ticks) : new IntegerInterpolationInterval(rightKeyValue, ticks);
            }
            case LONG: {
                return rightKeyValue.getInterpolator() instanceof NumberTangentInterpolator ? new TangentLongInterpolationInterval(rightKeyValue, ticks) : new LongInterpolationInterval(rightKeyValue, ticks);
            }
            case OBJECT: {
                return new ObjectInterpolationInterval(rightKeyValue, ticks);
            }
        }
        throw new RuntimeException("Should not reach here");
    }

    private static class ObjectInterpolationInterval
    extends InterpolationInterval {
        private final WritableValue target;
        private Object leftValue;
        private final Object rightValue;

        private ObjectInterpolationInterval(KeyValue keyValue, long ticks, Object leftValue) {
            super(ticks, keyValue.getInterpolator());
            this.target = keyValue.getTarget();
            this.rightValue = keyValue.getEndValue();
            this.leftValue = leftValue;
        }

        private ObjectInterpolationInterval(KeyValue keyValue, long ticks) {
            super(ticks, keyValue.getInterpolator());
            this.target = keyValue.getTarget();
            this.rightValue = keyValue.getEndValue();
            this.leftValue = this.target.getValue();
        }

        @Override
        public void interpolate(double frac) {
            Object value = this.rightInterpolator.interpolate(this.leftValue, this.rightValue, frac);
            this.target.setValue(value);
        }

        @Override
        public void recalculateStartValue() {
            this.leftValue = this.target.getValue();
        }
    }

    private static class TangentLongInterpolationInterval
    extends TangentInterpolationInterval {
        private final WritableLongValue target;

        private TangentLongInterpolationInterval(KeyValue rightKeyValue, long ticks, KeyValue leftKeyValue, long duration) {
            super(rightKeyValue, ticks, leftKeyValue, duration);
            assert (rightKeyValue.getTarget() instanceof WritableLongValue);
            this.target = (WritableLongValue)rightKeyValue.getTarget();
        }

        private TangentLongInterpolationInterval(KeyValue rightKeyValue, long ticks) {
            super(rightKeyValue, ticks);
            assert (rightKeyValue.getTarget() instanceof WritableLongValue);
            this.target = (WritableLongValue)rightKeyValue.getTarget();
            this.recalculateStartValue(this.target.get());
        }

        @Override
        public void interpolate(double frac) {
            this.target.set(Math.round(this.calculate(frac)));
        }

        @Override
        public void recalculateStartValue() {
            this.recalculateStartValue(this.target.get());
        }
    }

    private static class LongInterpolationInterval
    extends InterpolationInterval {
        private final WritableLongValue target;
        private long leftValue;
        private final long rightValue;

        private LongInterpolationInterval(KeyValue keyValue, long ticks, Object leftValue) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableLongValue && keyValue.getEndValue() instanceof Number && leftValue instanceof Number);
            this.target = (WritableLongValue)keyValue.getTarget();
            this.rightValue = ((Number)keyValue.getEndValue()).longValue();
            this.leftValue = ((Number)leftValue).longValue();
        }

        private LongInterpolationInterval(KeyValue keyValue, long ticks) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableLongValue && keyValue.getEndValue() instanceof Number);
            this.target = (WritableLongValue)keyValue.getTarget();
            this.rightValue = ((Number)keyValue.getEndValue()).longValue();
            this.leftValue = this.target.get();
        }

        @Override
        public void interpolate(double frac) {
            long value = this.rightInterpolator.interpolate(this.leftValue, this.rightValue, frac);
            this.target.set(value);
        }

        @Override
        public void recalculateStartValue() {
            this.leftValue = this.target.get();
        }
    }

    private static class TangentIntegerInterpolationInterval
    extends TangentInterpolationInterval {
        private final WritableIntegerValue target;

        private TangentIntegerInterpolationInterval(KeyValue rightKeyValue, long ticks, KeyValue leftKeyValue, long duration) {
            super(rightKeyValue, ticks, leftKeyValue, duration);
            assert (rightKeyValue.getTarget() instanceof WritableIntegerValue);
            this.target = (WritableIntegerValue)rightKeyValue.getTarget();
        }

        private TangentIntegerInterpolationInterval(KeyValue rightKeyValue, long ticks) {
            super(rightKeyValue, ticks);
            assert (rightKeyValue.getTarget() instanceof WritableIntegerValue);
            this.target = (WritableIntegerValue)rightKeyValue.getTarget();
            this.recalculateStartValue(this.target.get());
        }

        @Override
        public void interpolate(double frac) {
            this.target.set((int)Math.round(this.calculate(frac)));
        }

        @Override
        public void recalculateStartValue() {
            this.recalculateStartValue(this.target.get());
        }
    }

    private static class IntegerInterpolationInterval
    extends InterpolationInterval {
        private final WritableIntegerValue target;
        private int leftValue;
        private final int rightValue;

        private IntegerInterpolationInterval(KeyValue keyValue, long ticks, Object leftValue) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableIntegerValue && keyValue.getEndValue() instanceof Number && leftValue instanceof Number);
            this.target = (WritableIntegerValue)keyValue.getTarget();
            this.rightValue = ((Number)keyValue.getEndValue()).intValue();
            this.leftValue = ((Number)leftValue).intValue();
        }

        private IntegerInterpolationInterval(KeyValue keyValue, long ticks) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableIntegerValue && keyValue.getEndValue() instanceof Number);
            this.target = (WritableIntegerValue)keyValue.getTarget();
            this.rightValue = ((Number)keyValue.getEndValue()).intValue();
            this.leftValue = this.target.get();
        }

        @Override
        public void interpolate(double frac) {
            int value = this.rightInterpolator.interpolate(this.leftValue, this.rightValue, frac);
            this.target.set(value);
        }

        @Override
        public void recalculateStartValue() {
            this.leftValue = this.target.get();
        }
    }

    private static class TangentFloatInterpolationInterval
    extends TangentInterpolationInterval {
        private final WritableFloatValue target;

        private TangentFloatInterpolationInterval(KeyValue rightKeyValue, long ticks, KeyValue leftKeyValue, long duration) {
            super(rightKeyValue, ticks, leftKeyValue, duration);
            assert (rightKeyValue.getTarget() instanceof WritableFloatValue);
            this.target = (WritableFloatValue)rightKeyValue.getTarget();
        }

        private TangentFloatInterpolationInterval(KeyValue rightKeyValue, long ticks) {
            super(rightKeyValue, ticks);
            assert (rightKeyValue.getTarget() instanceof WritableFloatValue);
            this.target = (WritableFloatValue)rightKeyValue.getTarget();
            this.recalculateStartValue(this.target.get());
        }

        @Override
        public void interpolate(double frac) {
            this.target.set((float)this.calculate(frac));
        }

        @Override
        public void recalculateStartValue() {
            this.recalculateStartValue(this.target.get());
        }
    }

    private static class FloatInterpolationInterval
    extends InterpolationInterval {
        private final WritableFloatValue target;
        private float leftValue;
        private final float rightValue;

        private FloatInterpolationInterval(KeyValue keyValue, long ticks, Object leftValue) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableFloatValue && keyValue.getEndValue() instanceof Number && leftValue instanceof Number);
            this.target = (WritableFloatValue)keyValue.getTarget();
            this.rightValue = ((Number)keyValue.getEndValue()).floatValue();
            this.leftValue = ((Number)leftValue).floatValue();
        }

        private FloatInterpolationInterval(KeyValue keyValue, long ticks) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableFloatValue && keyValue.getEndValue() instanceof Number);
            this.target = (WritableFloatValue)keyValue.getTarget();
            this.rightValue = ((Number)keyValue.getEndValue()).floatValue();
            this.leftValue = this.target.get();
        }

        @Override
        public void interpolate(double frac) {
            float value = (float)this.rightInterpolator.interpolate(this.leftValue, this.rightValue, frac);
            this.target.set(value);
        }

        @Override
        public void recalculateStartValue() {
            this.leftValue = this.target.get();
        }
    }

    private static class TangentDoubleInterpolationInterval
    extends TangentInterpolationInterval {
        private final WritableDoubleValue target;

        private TangentDoubleInterpolationInterval(KeyValue rightKeyValue, long ticks, KeyValue leftKeyValue, long duration) {
            super(rightKeyValue, ticks, leftKeyValue, duration);
            assert (rightKeyValue.getTarget() instanceof WritableDoubleValue);
            this.target = (WritableDoubleValue)rightKeyValue.getTarget();
        }

        private TangentDoubleInterpolationInterval(KeyValue rightKeyValue, long ticks) {
            super(rightKeyValue, ticks);
            assert (rightKeyValue.getTarget() instanceof WritableDoubleValue);
            this.target = (WritableDoubleValue)rightKeyValue.getTarget();
            this.recalculateStartValue(this.target.get());
        }

        @Override
        public void interpolate(double frac) {
            this.target.set(this.calculate(frac));
        }

        @Override
        public void recalculateStartValue() {
            this.recalculateStartValue(this.target.get());
        }
    }

    private static class DoubleInterpolationInterval
    extends InterpolationInterval {
        private final WritableDoubleValue target;
        private double leftValue;
        private final double rightValue;

        private DoubleInterpolationInterval(KeyValue keyValue, long ticks, Object leftValue) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableDoubleValue && keyValue.getEndValue() instanceof Number && leftValue instanceof Number);
            this.target = (WritableDoubleValue)keyValue.getTarget();
            this.rightValue = ((Number)keyValue.getEndValue()).doubleValue();
            this.leftValue = ((Number)leftValue).doubleValue();
        }

        private DoubleInterpolationInterval(KeyValue keyValue, long ticks) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableDoubleValue && keyValue.getEndValue() instanceof Number);
            this.target = (WritableDoubleValue)keyValue.getTarget();
            this.rightValue = ((Number)keyValue.getEndValue()).doubleValue();
            this.leftValue = this.target.get();
        }

        @Override
        public void interpolate(double frac) {
            double value = this.rightInterpolator.interpolate(this.leftValue, this.rightValue, frac);
            this.target.set(value);
        }

        @Override
        public void recalculateStartValue() {
            this.leftValue = this.target.get();
        }
    }

    private static class BooleanInterpolationInterval
    extends InterpolationInterval {
        private final WritableBooleanValue target;
        private boolean leftValue;
        private final boolean rightValue;

        private BooleanInterpolationInterval(KeyValue keyValue, long ticks, Object leftValue) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableBooleanValue && keyValue.getEndValue() instanceof Boolean && leftValue instanceof Boolean);
            this.target = (WritableBooleanValue)keyValue.getTarget();
            this.rightValue = (Boolean)keyValue.getEndValue();
            this.leftValue = (Boolean)leftValue;
        }

        private BooleanInterpolationInterval(KeyValue keyValue, long ticks) {
            super(ticks, keyValue.getInterpolator());
            assert (keyValue.getTarget() instanceof WritableBooleanValue && keyValue.getEndValue() instanceof Boolean);
            this.target = (WritableBooleanValue)keyValue.getTarget();
            this.rightValue = (Boolean)keyValue.getEndValue();
            this.leftValue = this.target.get();
        }

        @Override
        public void interpolate(double frac) {
            boolean value = this.rightInterpolator.interpolate(this.leftValue, this.rightValue, frac);
            this.target.set(value);
        }

        @Override
        public void recalculateStartValue() {
            this.leftValue = this.target.get();
        }
    }

    private static abstract class TangentInterpolationInterval
    extends InterpolationInterval {
        private final double duration;
        private final double p2;
        protected final double p3;
        private final NumberTangentInterpolator leftInterpolator;
        protected double p0;
        private double p1;

        private TangentInterpolationInterval(KeyValue rightKeyValue, long ticks, KeyValue leftKeyValue, long duration) {
            super(ticks, rightKeyValue.getInterpolator());
            assert (rightKeyValue.getEndValue() instanceof Number && leftKeyValue.getEndValue() instanceof Number);
            this.duration = duration;
            Interpolator rawLeftInterpolator = leftKeyValue.getInterpolator();
            this.leftInterpolator = rawLeftInterpolator instanceof NumberTangentInterpolator ? (NumberTangentInterpolator)rawLeftInterpolator : null;
            this.recalculateStartValue(((Number)leftKeyValue.getEndValue()).doubleValue());
            NumberTangentInterpolator interpolator = this.rightInterpolator instanceof NumberTangentInterpolator ? (NumberTangentInterpolator)this.rightInterpolator : null;
            this.p3 = ((Number)rightKeyValue.getEndValue()).doubleValue();
            double p2Delta = interpolator == null ? 0.0 : (interpolator.getInValue() - this.p3) * (double)duration / interpolator.getInTicks() / 3.0;
            this.p2 = this.p3 + p2Delta;
        }

        private TangentInterpolationInterval(KeyValue rightKeyValue, long ticks) {
            super(ticks, rightKeyValue.getInterpolator());
            assert (rightKeyValue.getEndValue() instanceof Number);
            this.duration = ticks;
            this.leftInterpolator = null;
            NumberTangentInterpolator interpolator = this.rightInterpolator instanceof NumberTangentInterpolator ? (NumberTangentInterpolator)this.rightInterpolator : null;
            this.p3 = ((Number)rightKeyValue.getEndValue()).doubleValue();
            double p2Delta = interpolator == null ? 0.0 : (interpolator.getInValue() - this.p3) * this.duration / interpolator.getInTicks() / 3.0;
            this.p2 = this.p3 + p2Delta;
        }

        protected double calculate(double t) {
            double oneMinusT = 1.0 - t;
            double tSquared = t * t;
            double oneMinusTSquared = oneMinusT * oneMinusT;
            return oneMinusTSquared * oneMinusT * this.p0 + 3.0 * oneMinusTSquared * t * this.p1 + 3.0 * oneMinusT * tSquared * this.p2 + tSquared * t * this.p3;
        }

        protected final void recalculateStartValue(double leftValue) {
            this.p0 = leftValue;
            double p1Delta = this.leftInterpolator == null ? 0.0 : (this.leftInterpolator.getOutValue() - this.p0) * this.duration / this.leftInterpolator.getOutTicks() / 3.0;
            this.p1 = this.p0 + p1Delta;
        }
    }
}

