/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.event.EventDispatchChainImpl;
import com.sun.javafx.scene.control.skin.InputField;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.event.EventDispatchChain;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;

abstract class InputFieldSkin
implements Skin<InputField> {
    protected InputField control;
    private InnerTextField textField;
    private InvalidationListener InputFieldFocusListener;
    private InvalidationListener InputFieldStyleClassListener;

    public InputFieldSkin(InputField control) {
        this.control = control;
        this.textField = new InnerTextField(){

            @Override
            public void replaceText(int start, int end, String text) {
                String t = InputFieldSkin.this.textField.getText() == null ? "" : InputFieldSkin.this.textField.getText();
                if (InputFieldSkin.this.accept(t = t.substring(0, start) + text + t.substring(end))) {
                    super.replaceText(start, end, text);
                }
            }

            @Override
            public void replaceSelection(String text) {
                String t = InputFieldSkin.this.textField.getText() == null ? "" : InputFieldSkin.this.textField.getText();
                int start = Math.min(InputFieldSkin.this.textField.getAnchor(), InputFieldSkin.this.textField.getCaretPosition());
                int end = Math.max(InputFieldSkin.this.textField.getAnchor(), InputFieldSkin.this.textField.getCaretPosition());
                if (InputFieldSkin.this.accept(t = t.substring(0, start) + text + t.substring(end))) {
                    super.replaceSelection(text);
                }
            }
        };
        this.textField.setId("input-text-field");
        this.textField.setFocusTraversable(false);
        control.getStyleClass().addAll((Collection<String>)this.textField.getStyleClass());
        this.textField.getStyleClass().setAll((Collection<String>)control.getStyleClass());
        this.InputFieldStyleClassListener = observable -> this.textField.getStyleClass().setAll((Collection<String>)control.getStyleClass());
        control.getStyleClass().addListener(this.InputFieldStyleClassListener);
        this.textField.promptTextProperty().bind(control.promptTextProperty());
        this.textField.prefColumnCountProperty().bind(control.prefColumnCountProperty());
        this.textField.textProperty().addListener(observable -> this.updateValue());
        this.InputFieldFocusListener = observable -> this.textField.handleFocus(control.isFocused());
        control.focusedProperty().addListener(this.InputFieldFocusListener);
        this.updateText();
    }

    @Override
    public InputField getSkinnable() {
        return this.control;
    }

    @Override
    public Node getNode() {
        return this.textField;
    }

    @Override
    public void dispose() {
        this.control.getStyleClass().removeListener(this.InputFieldStyleClassListener);
        this.control.focusedProperty().removeListener(this.InputFieldFocusListener);
        this.textField = null;
    }

    protected abstract boolean accept(String var1);

    protected abstract void updateText();

    protected abstract void updateValue();

    protected TextField getTextField() {
        return this.textField;
    }

    private class InnerTextField
    extends TextField {
        private InnerTextField() {
        }

        public void handleFocus(boolean b) {
            this.setFocused(b);
        }

        @Override
        public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
            EventDispatchChainImpl chain = new EventDispatchChainImpl();
            chain.append(InputFieldSkin.this.textField.getEventDispatcher());
            return chain;
        }
    }
}

