/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.directwrite;

import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.directwrite.DWFontFile;
import com.sun.javafx.font.directwrite.DWGlyph;
import com.sun.javafx.font.directwrite.DWRITE_MATRIX;
import com.sun.javafx.font.directwrite.IDWriteFontFace;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;

class DWFontStrike
extends PrismFontStrike<DWFontFile> {
    DWRITE_MATRIX matrix;
    static final boolean SUBPIXEL_ON;
    static final boolean SUBPIXEL_Y;
    static final boolean SUBPIXEL_NATIVE;

    DWFontStrike(DWFontFile fontResource, float size, BaseTransform tx, int aaMode, FontStrikeDesc desc) {
        super(fontResource, size, tx, aaMode, desc);
        float maxDim = PrismFontFactory.getFontSizeLimit();
        if (tx.isTranslateOrIdentity()) {
            this.drawShapes = size > maxDim;
        } else {
            BaseTransform tx2d = this.getTransform();
            this.matrix = new DWRITE_MATRIX();
            this.matrix.m11 = (float)tx2d.getMxx();
            this.matrix.m12 = (float)tx2d.getMyx();
            this.matrix.m21 = (float)tx2d.getMxy();
            this.matrix.m22 = (float)tx2d.getMyy();
            if (Math.abs(this.matrix.m11 * size) > maxDim || Math.abs(this.matrix.m12 * size) > maxDim || Math.abs(this.matrix.m21 * size) > maxDim || Math.abs(this.matrix.m22 * size) > maxDim) {
                this.drawShapes = true;
            }
        }
    }

    @Override
    protected DisposerRecord createDisposer(FontStrikeDesc desc) {
        return null;
    }

    @Override
    public int getQuantizedPosition(Point2D point) {
        if (SUBPIXEL_ON && (this.matrix == null || SUBPIXEL_NATIVE) && (this.getAAMode() == 0 || SUBPIXEL_NATIVE)) {
            float subPixel = point.x;
            point.x = (int)point.x;
            subPixel -= point.x;
            int index = 0;
            if (subPixel >= 0.66f) {
                index = 2;
            } else if (subPixel >= 0.33f) {
                index = 1;
            }
            if (SUBPIXEL_Y) {
                subPixel = point.y;
                point.y = (int)point.y;
                if ((subPixel -= point.y) >= 0.66f) {
                    index += 6;
                } else if (subPixel >= 0.33f) {
                    index += 3;
                }
            } else {
                point.y = Math.round(point.y);
            }
            return index;
        }
        return super.getQuantizedPosition(point);
    }

    IDWriteFontFace getFontFace() {
        DWFontFile fontResource = (DWFontFile)this.getFontResource();
        return fontResource.getFontFace();
    }

    RectBounds getBBox(int glyphCode) {
        DWFontFile fontResource = (DWFontFile)this.getFontResource();
        return fontResource.getBBox(glyphCode, this.getSize());
    }

    int getUpem() {
        return ((DWFontFile)this.getFontResource()).getUnitsPerEm();
    }

    @Override
    protected Path2D createGlyphOutline(int glyphCode) {
        DWFontFile fontResource = (DWFontFile)this.getFontResource();
        return fontResource.getGlyphOutline(glyphCode, this.getSize());
    }

    @Override
    protected Glyph createGlyph(int glyphCode) {
        return new DWGlyph(this, glyphCode, this.drawShapes);
    }

    static {
        int mode = PrismFontFactory.getFontFactory().getSubPixelMode();
        SUBPIXEL_ON = (mode & 1) != 0;
        SUBPIXEL_Y = (mode & 2) != 0;
        SUBPIXEL_NATIVE = (mode & 4) != 0;
    }
}

