/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.StringStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FontFace {
    private final Map<String, String> descriptors;
    private final List<FontFaceSrc> sources;

    public FontFace(Map<String, String> descriptors, List<FontFaceSrc> sources) {
        this.descriptors = descriptors;
        this.sources = sources;
    }

    public Map<String, String> getDescriptors() {
        return this.descriptors;
    }

    public List<FontFaceSrc> getSources() {
        return this.sources;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("@font-face { ");
        for (Map.Entry<String, String> desc : this.descriptors.entrySet()) {
            sb.append(desc.getKey());
            sb.append(" : ");
            sb.append(desc.getValue());
            sb.append("; ");
        }
        sb.append("src : ");
        for (FontFaceSrc src : this.sources) {
            sb.append((Object)src.getType());
            sb.append(" \"");
            sb.append(src.getSrc());
            sb.append("\", ");
        }
        sb.append("; ");
        sb.append(" }");
        return sb.toString();
    }

    final void writeBinary(DataOutputStream os, StringStore stringStore) throws IOException {
        List<FontFaceSrc> fontFaceSrcs;
        Set<Map.Entry<String, String>> entrySet = this.getDescriptors() != null ? this.getDescriptors().entrySet() : null;
        int nEntries = entrySet != null ? entrySet.size() : 0;
        os.writeShort(nEntries);
        if (entrySet != null) {
            for (Map.Entry<String, String> entry : entrySet) {
                int index = stringStore.addString(entry.getKey());
                os.writeInt(index);
                index = stringStore.addString(entry.getValue());
                os.writeInt(index);
            }
        }
        nEntries = (fontFaceSrcs = this.getSources()) != null ? fontFaceSrcs.size() : 0;
        os.writeShort(nEntries);
        for (int n = 0; n < nEntries; ++n) {
            FontFaceSrc fontFaceSrc = fontFaceSrcs.get(n);
            fontFaceSrc.writeBinary(os, stringStore);
        }
    }

    static final FontFace readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        int nEntries = is.readShort();
        HashMap<String, String> descriptors = new HashMap<String, String>(nEntries);
        for (int n = 0; n < nEntries; ++n) {
            int index = is.readInt();
            String key = strings[index];
            index = is.readInt();
            String value = strings[index];
            descriptors.put(key, value);
        }
        nEntries = is.readShort();
        ArrayList<FontFaceSrc> fontFaceSrcs = new ArrayList<FontFaceSrc>(nEntries);
        for (int n = 0; n < nEntries; ++n) {
            FontFaceSrc fontFaceSrc = FontFaceSrc.readBinary(bssVersion, is, strings);
            fontFaceSrcs.add(fontFaceSrc);
        }
        return new FontFace(descriptors, fontFaceSrcs);
    }

    public static class FontFaceSrc {
        private final FontFaceSrcType type;
        private final String src;
        private final String format;

        public FontFaceSrc(FontFaceSrcType type, String src, String format) {
            this.type = type;
            this.src = src;
            this.format = format;
        }

        public FontFaceSrc(FontFaceSrcType type, String src) {
            this.type = type;
            this.src = src;
            this.format = null;
        }

        public FontFaceSrcType getType() {
            return this.type;
        }

        public String getSrc() {
            return this.src;
        }

        public String getFormat() {
            return this.format;
        }

        final void writeBinary(DataOutputStream os, StringStore stringStore) throws IOException {
            os.writeInt(stringStore.addString(this.type.name()));
            os.writeInt(stringStore.addString(this.src));
            os.writeInt(stringStore.addString(this.format));
        }

        static final FontFaceSrc readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
            int index = is.readInt();
            FontFaceSrcType type = strings[index] != null ? FontFaceSrcType.valueOf(strings[index]) : null;
            index = is.readInt();
            String src = strings[index];
            index = is.readInt();
            String format = strings[index];
            return new FontFaceSrc(type, src, format);
        }
    }

    public static enum FontFaceSrcType {
        URL,
        LOCAL,
        REFERENCE;

    }
}

