/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.ParsedValueImpl;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.converters.URLConverter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;

public final class Declaration {
    final String property;
    final ParsedValueImpl parsedValue;
    final boolean important;
    Rule rule;

    public Declaration(String propertyName, ParsedValueImpl parsedValue, boolean important) {
        this.property = propertyName;
        this.parsedValue = parsedValue;
        this.important = important;
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName cannot be null");
        }
        if (parsedValue == null) {
            throw new IllegalArgumentException("parsedValue cannot be null");
        }
    }

    public ParsedValue getParsedValue() {
        return this.parsedValue;
    }

    ParsedValueImpl getParsedValueImpl() {
        return this.parsedValue;
    }

    public String getProperty() {
        return this.property;
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean isImportant() {
        return this.important;
    }

    private StyleOrigin getOrigin() {
        Rule rule = this.getRule();
        if (rule != null) {
            return rule.getOrigin();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Declaration other = (Declaration)obj;
        if (this.important != other.important) {
            return false;
        }
        if (this.getOrigin() != other.getOrigin()) {
            return false;
        }
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        return this.parsedValue == other.parsedValue || this.parsedValue != null && this.parsedValue.equals(other.parsedValue);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.property != null ? this.property.hashCode() : 0);
        hash = 89 * hash + (this.parsedValue != null ? this.parsedValue.hashCode() : 0);
        hash = 89 * hash + (this.important ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder(this.property);
        sbuf.append(": ");
        sbuf.append(this.parsedValue);
        if (this.important) {
            sbuf.append(" !important");
        }
        return sbuf.toString();
    }

    void fixUrl(String stylesheetUrl) {
        if (stylesheetUrl == null) {
            return;
        }
        StyleConverter converter = this.parsedValue.getConverter();
        if (converter == URLConverter.getInstance()) {
            ParsedValue[] values = (ParsedValue[])this.parsedValue.getValue();
            values[1] = new ParsedValueImpl(stylesheetUrl, null);
        } else if (converter == URLConverter.SequenceConverter.getInstance()) {
            ParsedValue[] layers = (ParsedValue[])this.parsedValue.getValue();
            for (int layer = 0; layer < layers.length; ++layer) {
                ParsedValue[] values = (ParsedValue[])layers[layer].getValue();
                values[1] = new ParsedValueImpl(stylesheetUrl, null);
            }
        }
    }

    final void writeBinary(DataOutputStream os, StringStore stringStore) throws IOException {
        os.writeShort(stringStore.addString(this.getProperty()));
        this.getParsedValueImpl().writeBinary(os, stringStore);
        os.writeBoolean(this.isImportant());
    }

    static Declaration readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        String propertyName = strings[is.readShort()];
        ParsedValueImpl parsedValue = ParsedValueImpl.readBinary(bssVersion, is, strings);
        boolean important = is.readBoolean();
        return new Declaration(propertyName, parsedValue, important);
    }
}

