/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.Match;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.StringStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.css.Styleable;

public final class CompoundSelector
extends Selector {
    private final List<SimpleSelector> selectors;
    private final List<Combinator> relationships;
    private int hash = -1;

    public List<SimpleSelector> getSelectors() {
        return this.selectors;
    }

    public List<Combinator> getRelationships() {
        return this.relationships;
    }

    public CompoundSelector(List<SimpleSelector> selectors, List<Combinator> relationships) {
        this.selectors = selectors != null ? Collections.unmodifiableList(selectors) : Collections.EMPTY_LIST;
        this.relationships = relationships != null ? Collections.unmodifiableList(relationships) : Collections.EMPTY_LIST;
    }

    private CompoundSelector() {
        this(null, null);
    }

    @Override
    Match createMatch() {
        PseudoClassState allPseudoClasses = new PseudoClassState();
        int idCount = 0;
        int styleClassCount = 0;
        int nMax = this.selectors.size();
        for (int n = 0; n < nMax; ++n) {
            Selector sel = this.selectors.get(n);
            Match match = sel.createMatch();
            allPseudoClasses.addAll((Collection)match.pseudoClasses);
            idCount += match.idCount;
            styleClassCount += match.styleClassCount;
        }
        return new Match(this, allPseudoClasses, idCount, styleClassCount);
    }

    @Override
    public boolean applies(Styleable styleable) {
        return this.applies(styleable, this.selectors.size() - 1, null, 0);
    }

    @Override
    boolean applies(Styleable styleable, Set<PseudoClass>[] triggerStates, int depth) {
        assert (triggerStates == null || depth < triggerStates.length);
        if (triggerStates != null && triggerStates.length <= depth) {
            return false;
        }
        PseudoClassState[] tempStates = triggerStates != null ? new PseudoClassState[triggerStates.length] : null;
        boolean applies = this.applies(styleable, this.selectors.size() - 1, tempStates, depth);
        if (applies && tempStates != null) {
            for (int n = 0; n < triggerStates.length; ++n) {
                Set<PseudoClass> pseudoClassOut = triggerStates[n];
                PseudoClassState pseudoClassIn = tempStates[n];
                if (pseudoClassOut != null) {
                    pseudoClassOut.addAll(pseudoClassIn);
                    continue;
                }
                triggerStates[n] = pseudoClassIn;
            }
        }
        return applies;
    }

    private boolean applies(Styleable styleable, int index, Set<PseudoClass>[] triggerStates, int depth) {
        if (index < 0) {
            return false;
        }
        if (!this.selectors.get(index).applies(styleable, triggerStates, depth)) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        Combinator relationship = this.relationships.get(index - 1);
        if (relationship == Combinator.CHILD) {
            Styleable parent = styleable.getStyleableParent();
            if (parent == null) {
                return false;
            }
            return this.applies(parent, index - 1, triggerStates, ++depth);
        }
        for (Styleable parent = styleable.getStyleableParent(); parent != null; parent = parent.getStyleableParent()) {
            boolean answer;
            if (!(answer = this.applies(parent, index - 1, triggerStates, ++depth))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean stateMatches(Styleable styleable, Set<PseudoClass> states) {
        return this.stateMatches(styleable, states, this.selectors.size() - 1);
    }

    private boolean stateMatches(Styleable styleable, Set<PseudoClass> states, int index) {
        if (index < 0) {
            return false;
        }
        if (!this.selectors.get(index).stateMatches(styleable, states)) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        Combinator relationship = this.relationships.get(index - 1);
        if (relationship == Combinator.CHILD) {
            Styleable parent = styleable.getStyleableParent();
            if (parent == null) {
                return false;
            }
            if (this.selectors.get(index - 1).applies(parent)) {
                ObservableSet<PseudoClass> parentStates = parent.getPseudoClassStates();
                return this.stateMatches(parent, parentStates, index - 1);
            }
        } else {
            for (Styleable parent = styleable.getStyleableParent(); parent != null; parent = parent.getStyleableParent()) {
                if (!this.selectors.get(index - 1).applies(parent)) continue;
                ObservableSet<PseudoClass> parentStates = parent.getPseudoClassStates();
                return this.stateMatches(parent, parentStates, index - 1);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == -1) {
            int i;
            int max = this.selectors.size();
            for (i = 0; i < max; ++i) {
                this.hash = 31 * (this.hash + this.selectors.get(i).hashCode());
            }
            max = this.relationships.size();
            for (i = 0; i < max; ++i) {
                this.hash = 31 * (this.hash + this.relationships.get(i).hashCode());
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundSelector other = (CompoundSelector)obj;
        if (other.selectors.size() != this.selectors.size()) {
            return false;
        }
        int max = this.selectors.size();
        for (i = 0; i < max; ++i) {
            if (other.selectors.get(i).equals(this.selectors.get(i))) continue;
            return false;
        }
        if (other.relationships.size() != this.relationships.size()) {
            return false;
        }
        max = this.relationships.size();
        for (i = 0; i < max; ++i) {
            if (other.relationships.get(i).equals((Object)this.relationships.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(this.selectors.get(0));
        for (int n = 1; n < this.selectors.size(); ++n) {
            sbuf.append((Object)this.relationships.get(n - 1));
            sbuf.append(this.selectors.get(n));
        }
        return sbuf.toString();
    }

    @Override
    public final void writeBinary(DataOutputStream os, StringStore stringStore) throws IOException {
        int n;
        super.writeBinary(os, stringStore);
        os.writeShort(this.selectors.size());
        for (n = 0; n < this.selectors.size(); ++n) {
            this.selectors.get(n).writeBinary(os, stringStore);
        }
        os.writeShort(this.relationships.size());
        for (n = 0; n < this.relationships.size(); ++n) {
            os.writeByte(this.relationships.get(n).ordinal());
        }
    }

    public static CompoundSelector readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        int nSelectors = is.readShort();
        ArrayList<SimpleSelector> selectors = new ArrayList<SimpleSelector>();
        for (int n = 0; n < nSelectors; ++n) {
            selectors.add((SimpleSelector)Selector.readBinary(bssVersion, is, strings));
        }
        int nRelationships = is.readShort();
        ArrayList<Combinator> relationships = new ArrayList<Combinator>();
        for (int n = 0; n < nRelationships; ++n) {
            byte ordinal = is.readByte();
            if (ordinal == Combinator.CHILD.ordinal()) {
                relationships.add(Combinator.CHILD);
                continue;
            }
            if (ordinal == Combinator.DESCENDANT.ordinal()) {
                relationships.add(Combinator.DESCENDANT);
                continue;
            }
            assert (false) : "error deserializing CompoundSelector: Combinator = " + ordinal;
            relationships.add(Combinator.DESCENDANT);
        }
        return new CompoundSelector(selectors, relationships);
    }
}

