/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ElementObserver;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import com.sun.javafx.collections.SortableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.util.Callback;

public final class ObservableSequentialListWrapper<E>
extends ModifiableObservableListBase<E>
implements ObservableList<E>,
SortableList<E> {
    private final List<E> backingList;
    private final ElementObserver elementObserver;
    private SortHelper helper;

    public ObservableSequentialListWrapper(List<E> list) {
        this.backingList = list;
        this.elementObserver = null;
    }

    public ObservableSequentialListWrapper(List<E> list, Callback<E, Observable[]> extractor) {
        this.backingList = list;
        this.elementObserver = new ElementObserver<E>(extractor, new Callback<E, InvalidationListener>(){

            @Override
            public InvalidationListener call(final E e) {
                return new InvalidationListener(){

                    @Override
                    public void invalidated(Observable observable) {
                        ObservableSequentialListWrapper.this.beginChange();
                        int i = 0;
                        Iterator it = ObservableSequentialListWrapper.this.backingList.iterator();
                        while (it.hasNext()) {
                            if (it.next() == e) {
                                ObservableSequentialListWrapper.this.nextUpdate(i);
                            }
                            ++i;
                        }
                        ObservableSequentialListWrapper.this.endChange();
                    }
                };
            }
        }, this);
        for (E e : this.backingList) {
            this.elementObserver.attachListener(e);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingList.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.backingList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.backingList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            private final ListIterator<E> backingIt;
            private E lastReturned;
            {
                this.backingIt = ObservableSequentialListWrapper.this.backingList.listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.backingIt.hasNext();
            }

            @Override
            public E next() {
                this.lastReturned = this.backingIt.next();
                return this.lastReturned;
            }

            @Override
            public boolean hasPrevious() {
                return this.backingIt.hasPrevious();
            }

            @Override
            public E previous() {
                this.lastReturned = this.backingIt.previous();
                return this.lastReturned;
            }

            @Override
            public int nextIndex() {
                return this.backingIt.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.backingIt.previousIndex();
            }

            @Override
            public void remove() {
                ObservableSequentialListWrapper.this.beginChange();
                int idx = this.previousIndex();
                this.backingIt.remove();
                ObservableSequentialListWrapper.this.nextRemove(idx, this.lastReturned);
                ObservableSequentialListWrapper.this.endChange();
            }

            @Override
            public void set(E e) {
                ObservableSequentialListWrapper.this.beginChange();
                int idx = this.previousIndex();
                this.backingIt.set(e);
                ObservableSequentialListWrapper.this.nextSet(idx, this.lastReturned);
                ObservableSequentialListWrapper.this.endChange();
            }

            @Override
            public void add(E e) {
                ObservableSequentialListWrapper.this.beginChange();
                int idx = this.nextIndex();
                this.backingIt.add(e);
                ObservableSequentialListWrapper.this.nextAdd(idx, idx + 1);
                ObservableSequentialListWrapper.this.endChange();
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public E get(int index) {
        try {
            return this.backingList.listIterator(index).next();
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        try {
            this.beginChange();
            boolean modified = false;
            ListIterator<E> e1 = this.listIterator(index);
            Iterator<E> e2 = c.iterator();
            while (e2.hasNext()) {
                e1.add(e2.next());
                modified = true;
            }
            this.endChange();
            return modified;
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    protected void doAdd(int index, E element) {
        try {
            this.backingList.listIterator(index).add(element);
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    @Override
    protected E doSet(int index, E element) {
        try {
            ListIterator<E> e = this.backingList.listIterator(index);
            E oldVal = e.next();
            e.set(element);
            return oldVal;
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    @Override
    protected E doRemove(int index) {
        try {
            ListIterator<E> e = this.backingList.listIterator(index);
            E outCast = e.next();
            e.remove();
            return outCast;
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    @Override
    public void sort() {
        if (this.backingList.isEmpty()) {
            return;
        }
        int[] perm = this.getSortHelper().sort(this.backingList);
        this.fireChange(new NonIterableChange.SimplePermutationChange(0, this.size(), perm, this));
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.backingList.isEmpty()) {
            return;
        }
        int[] perm = this.getSortHelper().sort(this.backingList, comparator);
        this.fireChange(new NonIterableChange.SimplePermutationChange(0, this.size(), perm, this));
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }
}

