#Larissa dos Anjos Miyagi
#Numero USP: 6818653
# Exercicio Programa 07 - MAP2212

#Os pacotes necessários
require(MASS)

#Entrada dos dados
entrada<-function(){
tabela <-matrix(1:50,ncol=10) # def tabela com dados de entrada
tabela <- read.table("tabela1.txt")
return (tabela)
 }

ts <- function(tabela, col, N){
i = 1
j = 1
k = 1
t = rep(0,0)
while(i <=N){
while(k <= col){
t[i] = c(tabela[j,k])
k = k + 1
i = i + 1
}
k = 1
j = j + 1
}
return (t)
}

Tr <-function(t){ # pontos aceitos
tr = rep(0,0)
tr = t
tr = tr[-((n+1):(n+m))]
return(tr)
}

Tw <- function(t){ # pontos não aceitos
tw = rep(0,0)
tw = t
tw = tw[-(1:n)]
return(tw)
}

#Implementação para a função r de alfa dados beta e gama
funcaoRa <- function(alfa, beta, gama) 
return ( exp(-(alfa/gama)^beta) )


#Implementação para a função r de tj dados alfa,beta e gama
funcaoWti <- function(t, alfa, beta, gama) 
return( (beta*(t + alfa)^(beta-1)/gama^beta)*exp(-((t + alfa)/gama)^beta)/rr(alfa,beta,gama) )

#Implementação para a função w de ti dados alfa,beta e gama
funcaoRtj <- function(t, alfa, beta, gama)
return( exp(-((t + alfa)/gama)^beta)/rr(alfa, beta, gama) )

#Implementamos o produtorio para a rtj
funcaoProdr = function(dados,alpha,beta,gama)
{
  resultado<-numeric()
  resultado=1
  for(i in 1:(length(dados)))
  {
   resultado=resultado*funcaoRtj(t=dados[i],alpha=alpha,beta=beta,gama=gama)
  }
  return(resultado)
}

#Implementamos o produtorio para a Wti
funcaoProdw = function(dados,alpha,beta,gama)
{
  resultado<-numeric()
  resultado=1
  for(i in 1:(length(dados)))
  {
   resultado=resultado*funcaoWti(t=dados[i],alpha=alpha,beta=beta,gama=gama)
  }
  return(resultado)
}

#Implementação da função que vai verificar a aceitação ou rejeição do ponto
#Essa função devolve 1 em caso de aceitação e 0 em caso de rejeição

funcaoVerifica = function(proximo,anterior)
{
 u<-numeric()
 u<-runif(1,0,1)

 if( (proximo/anterior) < 1)
 {
   if(u < (proximo/anterior))
     return(1)
   else
     return(0)
 }
 else
 {
     return(1)
 }
}
   

#Implementamos o random walk pela função geraPontos
geraPontos = function(npontos)
{
  #Definimos a matriz de covariancia sigma que usaremos para gerar a normal multivariada
  #Desenvolvemos sua estimação no relatório
  k<-numeric()
  k<-0.055
  
  Sigm<-matrix()
  Sigma<-k*diag(1,3)

  #Definimos um vetor resultado que será usado no cálculo da integral
  resultado<-array()

  #Para facilitar a implementação,vamos usar um vetor para cada
  #dimensão no R³,isto é,um vetor para a,outro para b e outro para g

  alfa<-array()
  beta<-array()
  gama<-array()

  #Chute inicial
  #Usaremos as estimativas de verossimilhança do paper
  alfa[1] <- 1.25
  beta[1] <- 3.28
  gama[1] <- 3.54

  #Variável auxiliar para verificar o Metropolis-Hastings da rodada
  verifica<-numeric()
  resultado[1]=funcaoProdw(dadosN,alpha=alfa[1],beta=beta[1],gama=gama[1])*funcaoProdr(dadosM,alpha=alfa[1],beta=beta[1],gama=gama[1])

  #Laço para gerar os pontos
  for(i in 2:(npontos))
  {
    #Retiro um numero de uma normal multivariada.
    Z<-array()
    Z<-rmvnorm(1,c(0,0,0),Sigma)

    #Calculo o proximo ponto usando um passo normal em R³
    alfa[i] <- alfa[i-1]+Z[,1]
    beta[i] <- beta[i-1]+Z[,2]
    gama[i] <- gama[i-1]+Z[,3]

    #Vamos fazer as checagens se o novo ponto está dentro do domínio estabelecido
    while( (alfa[i] < 0) || (beta[i] < 1) || (gama[i] < 0) )
    {
      #Estamos fora do domínio!Sorteamos um novo ponto.
      Z<-rmvnorm(1,c(0,0,0),Sigma)

      alfa[i] <- alfa[i-1]+Z[,1]
      beta[i] <- beta[i-1]+Z[,2]
      gama[i] <- gama[i-1]+Z[,3]
    }

    #Temos um novo ponto compatível com o domínio estabelecido. 

    #Calculo a imagem em L de xi e xi-1
    imagemXi<-numeric()
    imagemXi=funcaoProdw(dadosN,alpha=alfa[i],beta=beta[i],gama=gama[i])*funcaoProdr(dadosM,alpha=alfa[i],beta=beta[i],gama=gama[i])
  
    imagemXiant<-numeric()
    imagemXiant<-resultado[i-1]

    verifica<-funcaoVerifica(proximo=imagemXi,anterior=imagemXiant)

    #Vamos fazer a checagem se o novo ponto deve ser aceito
    if(verifica==0)
    {
      #O ponto não satisfaz a probabilidade alfa
      #De acordo com o algoritmo de Metropolis-Hastings,o ponto atual recebe o anterior
      alfa[i] <- alfa[i-1]
      beta[i] <- beta[i-1]
      gama[i] <- gama[i-1]

      resultado[i]<-imagemXiant     
    }
    
   #Caso contrário,verifica==1 e o ponto pode ser aceito,podemos prosseguir para o próximo ponto
   else if(verifica==1)
   {
     resultado[i]<-imagemXi
   }
      
 }

  return(resultado)
}

#Implementamos uma função interpoladora para a condensação dos pontos na terceira parte
interpola = function(xA,pA,PA,xB,pB,PB)
{
  pnovo<-numeric()
  xnovo<-numeric()

  pnovo<-pA*PA + pB*PB
  xnovo<-(1/pnovo)*(xA*pA*PA + xB*pB*PB)

  return(xnovo)
}

#Implementamos o calculo da constante de normalização
primeiraparte = function(n)
{
  #Primeira questão:queremos a constante de normalização
  #Usamos crude Monte Carlo implementado na função geraPontos. Devolveremos,de acordo com o enunciado,o inverso
  #do resultado da integral  

  results<-array()
  results<-geraPontos(n)

  return(1/(sum(results)/n))
  
}

segundaparte = function(results,v)
{
  
  #Segunda Questão : calcular uma aproximação da função verdade
  #O parâmetro results é um vetor já multiplicado pela constante
  #de normalização

  cont<-numeric()
  cont<-0

  n<-numeric()
  n<-length(results)

  #Ordenando o vetor para contar quantos pontos são menores que v
  sort(results)

  for(i in 1:n)
  {
    if(results[i] < v)
    {
       cont<-cont+1
    }
  }

  return(cont/n)
}

terceiraparte = function(valores)
{
  
  #Terceira Questão
  #Para trabalhar com milhões de pontos
  #Condensaremos o vetor "valores" usando a função verdade. 
  valores<-sort(valores)

  n<-numeric()
  n<-length(valores)

  #Declaramos os contadores auxiliares
  j<-numeric()
  k<-numeric()
  cont<-numeric()
  aux<-array()

  #Primeiramente calculamos a acumulada para cada ponto
  #A acumulada é dada pela função verdade. Montamos um vetor com a acumulada de cada ponto

  vetorP<-array()

  for(i in 1:n)
  {
    vetorP[i]<-segundaparte(valores,valores[i])
  }

  #Montando um vetor com a probabilidade de cada ponto
  
  vetorp<-array()

  for(i in 1:n)
  { 
    aux<-which(valores == valores[i])
    vetorp[i]<-(length(aux)/n)      
  }

  #Finalmente gerar o novo vetor,interpolando os pontos 2 a 2
  
  vetorfinal<-array()
  
  j<-1
  k<-1
  while(j < n)
  {
    vetorfinal[k]<-interpola(xA=valores[j],pA=vetorp[j],PA=vetorP[j],xB=valores[j+1],pB=vetorp[j+1],PB=vetorP[j+1])
    j<-j+2
    k<-k+1
  }

  return(vetorfinal)
}

tabela = entrada()
n = 45 # numero de t's aceitos
m = 5 # numero de t's não aceitos
i = j = 0 # contadores
t = ts(tabela, 10, n+m) #lista de todos os t's
dadosN = Tr(t) # lista de t's aceitos
dadosM = Tw(t) # lista de t's não aceitos
res = rep(0,0)

print("***Exemplo de execução***")
print("Utilizamos 2 mil pontos")

C<-primeiraparte(2000)
print("Constante de normalização:")
print(C)

res<-geraPontos(2000)
res<-C*res
print("Media do vetor original com 2 mil pontos")
print(sum(res)/(length(res)))

res2<-terceiraparte(res)
print("Media do vetor condensado com mil pontos")
print(sum(res2)/(length(res2)))

